#!/bin/sh
# the next line restarts using wish \
exec wishstep8.0 "$0" "$@"
#
#    PrefDesktop Desktop preference module
#
#			Wed Dec 16 23:40:03 JST 1998 Jun Wakaya
#

set JackModeName {};set JackModeText {}
set button -1

proc pref_JackSpace_mkIcons {} {
	global dtLib

	image create photo JS_mICN -file $dtLib/icons/modes/random.gif
}

proc pref_truncateList {list} {

	set retList {}

	set list [join [join $list]]

	foreach i $list {
		if {$i == {}} {
			continue
		}

		lappend retList $i
	}

	return $retList
}

proc pref_JackSpace_init {} {
	global JackModeName JackModeText

	set ret [split [exec xlock -help] \n]

	for {set i 0} {$i<[llength $ret]} {incr i} {
		if {[string match [lindex $ret $i] "    where mode is one of:"]} {
			incr i
			break
		}
	}

	for {set i $i} {$i<[llength $ret]} {incr i} {

		if {[string range [lindex $ret $i] 10 10]!=" "} {
			lappend JackModeName [string range [lindex $ret $i] 10 33]
			lappend JackModeText [string range [lindex $ret $i] 34 end]
		}
	}

	set JackModeName [pref_truncateList [split $JackModeName]]

	return $JackModeName
}

proc pref_Page1_makeSkel {tl} {
	global button dtLib rootBG fgColor bgColor rootSolid
	global FG BG lFont

	$tl configure -bd 10 -bg $BG

	label $tl.l0 -font $lFont -text "Color setting" \
		-fg $BG -bg $FG -width 32
	pack $tl.l0

	frame $tl.u -bd 5 -bg $BG
	pack $tl.u

	button $tl.u.bg -fg black -bg $bgColor -text "menu color" \
		-command "pref_setColor $tl.u.bg bgColor"
	button $tl.u.fg -fg #c0c0c0 -bg $fgColor -text "text color" \
		-command "pref_setColor $tl.u.fg fgColor"

	pack $tl.u.bg $tl.u.fg -side left -fill both -padx 5

	label $tl.l1 -font $lFont -text "Default language" \
		-fg $BG -bg $FG -width 32
	pack $tl.l1

	frame $tl.m -bd 5 -bg $BG
	pack $tl.m

	image create photo ja -file "$dtLib/icons/Pref.ja.gif"
	image create photo en -file "$dtLib/icons/Pref.en.gif"

	label $tl.m.l2 -image ja -bg $BG
	label $tl.m.l3 -image en -bg $BG

	radiobutton $tl.m.l4 -relief flat -value ja\
		-variable lang -bg $BG
	radiobutton $tl.m.l5 -relief flat -value en\
		-variable lang -bg $BG

	pack $tl.m.l4 $tl.m.l2 $tl.m.l5 $tl.m.l3 -side left

	pack [label $tl.l2 -font $lFont -text "Background" \
		-fg $BG -bg $FG -width 32]

	pack [frame $tl.l -bd 5 -bg $BG]

	button $tl.l.rbg -fg #c0c0c0 -bg $rootSolid -text "solid" \
		-command "pref_setColor $tl.l.rbg rootSolid"
	pack $tl.l.rbg -side left -fill both -padx 5

	pack [button $tl.l.b0 -text "erace BG" -command "desktop_bgErace"\
		-fg black -bg #c0c0c0 ] -padx 5 -side left

	pack [button $tl.l.b1 -text image -command "pref_setBGimage set"\
		-fg black -bg #c0c0c0 ] -padx 5 -side left
}

proc pref_Page2_makeSkel {tl} {
	global button dtLib rootBG fgColor bgColor rootSolid
	global FG BG lFont JackMode
	global JackModeName
	global JackLock

	$tl configure -bd 10 -bg $BG

	label $tl.l0 -font $lFont -text "Mode setting" \
		-fg $BG -bg $FG -width 32
	pack $tl.l0

	pack [frame $tl.u -bd 5 -bg $BG]

	scrollbar $tl.u.s0 -command "$tl.u.l0 yview"
	listbox $tl.u.l0 -yscrollcommand "$tl.u.s0 set"
	pref_refSSList $tl.u.l0

	set idx [lsearch $JackModeName $JackMode]

	frame $tl.u.f0 -bg $BG
	button $tl.u.f0.lb0 -bd 2 -image JS_mICN \
		-command "pref_JackSpace_launch $tl.u.l0 $tl.u.f0.lb0"
	pref_coolbutton $tl.u.f0.lb0

	text $tl.u.f0.t0 -state disabled -height 6 -width 16 \
		-relief flat -bg $BG -fg $FG -wrap word

	checkbutton $tl.u.f0.cb0 -text "Lock screen" \
		-bg $BG -fg $FG -variable JackLock

	pack $tl.u.f0.lb0 $tl.u.f0.t0 $tl.u.f0.cb0 -in $tl.u.f0 -padx 5

	bind $tl.u.l0 <Any-ButtonRelease-1> \
		"pref_JackSpace_cur $tl.u.f0.t0 $tl.u.l0 $tl.u.f0.lb0"

	pack $tl.u.s0 $tl.u.l0 $tl.u.f0 -side left -fill both



	$tl.u.l0 selection set $idx
	pref_JackSpace_cur $tl.u.f0.t0 $tl.u.l0 $tl.u.f0.lb0

}

proc pref_JackSpace_launch {l lb} {
	global JackModeText JackModeName dtLib

	if {[$l curselection]==""} return

	exec xlock -nolock -mode [lindex $JackModeName [$l curselection]]
}

proc pref_coolbutton {b} {
	$b configure -relief flat -highlightthickness 0

	bind $b <Enter> {
		if {[%W cget -state]!="disabled"} {
			%W configure -relief raise
		}
	}
	bind $b <Leave> {%W configure -relief flat}
}

proc pref_JackSpace_cur {t l lb} {
	global JackModeText JackModeName dtLib JackMode

	$t configure -state normal
	$t delete 1.0 end
	$t insert end [lindex $JackModeText [$l curselection]]
	$t configure -state disabled

	JS_mICN configure -file \
		$dtLib/icons/modes/[lindex $JackModeName [$l curselection]].gif

	set JackMode [lindex $JackModeName [$l curselection]]
}

proc pref_refSSList {l} {
	global JackModeText

	foreach i [pref_JackSpace_init] {
		$l insert end $i
	}
}

proc pref_save {tl} {
	global dtDef
	global fgColor bgColor
	global rootSolid rootBG
	global lang
	global button
	global JackMode JackLock

	set fp [open $dtDef/SeizeDesktop w]

	puts $fp "set lang \{$lang\}"
	puts $fp "set fgColor \{$fgColor\}"
	puts $fp "set bgColor \{$bgColor\}"
	puts $fp "set rootSolid \{$rootSolid\}"
	puts $fp "set rootBG \{$rootBG\}"
	puts $fp "set JackMode \{$JackMode\}"
	puts $fp "set JackLock \{$JackLock\}"

	close $fp

	set button 0
}

proc pref_cancel {tl} {
	global button

	set button 1
}

proc pref_setColor {w name} {
	global bgColor fgColor rootSolid

	eval set backup \$$name

	set $name [tk_chooseColor -title "Choose a color" -parent . \
		-initialcolor $backup]

	eval set temp \$$name

	if {$temp==""} {
		set $name $backup
		set temp $backup
	}

	$w configure -bg $temp
}

proc pref_setBGimage {mode} {

	switch $mode {
		"set" {
			set fName [pref_openBG]
			desktop_wallPaper .c $fName
		}
		"reset" {
			bg configure -data {}
		}
	}
}

proc pref_openBG {} {
	set types {
		{"All supported" {.jpg .JPG .gif .GIF .xpm .png .pnm .ppm .tif .tiff}}
		{"All files"	 *}
	}

	set file [tk_getOpenFile -filetypes $types -parent .]
	if {$file!=""} "return $file"
}

proc desktop_Preference {} {
	global button dtLib rootBG
	global FG BG lFont

	pref_JackSpace_mkIcons

	set oldFocus [focus]

	if {[winfo exists .prefer]} {
		raise .prefer
		return
	} else {
		toplevel .prefer -bd 5
	}

	wm title .prefer "Desktop preferences"

	grab .prefer

	pack [frame .prefer.f -relief sunken -bd 2]

	global button dtLib rootBG
	global bgColor fgColor rootBG rootSolid lang
	set FG $fgColor;set BG $bgColor

	.prefer configure -bg $BG

	set xFont "Courier 18"
	set lFont "Fixed 14"
	set mFont "Fixed 12"

	tabnotebook_create .prefer.f.tn
	pack .prefer.f.tn
	set tl [tabnotebook_page .prefer.f.tn "Global"]
	pref_Page1_makeSkel $tl
	set tl [tabnotebook_page .prefer.f.tn "Screen saver"]
	pref_Page2_makeSkel $tl

	##################### bottom #########################

	button .prefer.ok -text save -font $lFont -default active \
		-command "pref_save .prefer" -bg $BG -fg $FG
	button .prefer.cancel -text cancel -font $lFont -default normal \
		-command "pref_cancel .prefer" -bg $BG -fg $FG

	pack .prefer.cancel .prefer.ok -side right -padx 5 -pady 5
	tkwait variable button
	destroy .prefer
	focus $oldFocus

	return $button
}
