/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import org.apache.jasper.compiler.Mangler;
import org.apache.tomcat.util.JavaGeneratorTool;
import org.apache.tomcat.util.io.FileUtil;

public class JasperMangler
implements Mangler {
    private String jspFile;
    private String jspFilePath = null;
    private int version;
    private String workDir;
    private String docBase;
    private String pkgDir;
    private String baseClassN;
    private String classDir;
    private String javaFileName;
    private String classFileName;

    public JasperMangler(String workDir, String docBase, String jspFile) {
        this.jspFile = jspFile;
        this.workDir = workDir;
        this.docBase = docBase;
        this.init();
    }

    public String getClassName() {
        return JavaGeneratorTool.getVersionedName(this.baseClassN, this.version);
    }

    public String getJavaFileName() {
        return this.javaFileName;
    }

    public String getPackageName() {
        if (this.pkgDir != null) {
            return this.pkgDir.replace('/', '.');
        }
        return null;
    }

    public String getClassFileName() {
        return this.classFileName;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public String getClassDir() {
        return this.classDir;
    }

    public String getServletClassName() {
        if (this.pkgDir != null) {
            return this.getPackageName() + "." + this.getClassName();
        }
        return this.getClassName();
    }

    public int getVersion() {
        return this.version;
    }

    public String getBaseClassName() {
        return this.baseClassN;
    }

    public String getPackageDir() {
        return this.pkgDir;
    }

    public String getJspFilePath() {
        if (this.jspFilePath == null) {
            this.jspFilePath = FileUtil.safePath(this.docBase, this.jspFile);
        }
        return this.jspFilePath;
    }

    private String fixInvalidChars(String className) {
        StringBuffer modifiedClassName = new StringBuffer();
        char c = '/';
        if (Character.isDigit(className.charAt(0))) {
            className = "_" + className;
        }
        int i = 0;
        while (i < className.length()) {
            char prev = c;
            c = className.charAt(i);
            if (prev != '/' || c != '/') {
                if (Character.isLetterOrDigit(c) || c == '_' || c == '/') {
                    modifiedClassName.append(className.substring(i, i + 1));
                } else {
                    modifiedClassName.append(JasperMangler.mangleChar(className.charAt(i)));
                }
            }
            ++i;
        }
        return modifiedClassName.toString();
    }

    private static final String mangleChar(char ch) {
        if (ch == File.separatorChar) {
            ch = (char)47;
        }
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        int i = 1;
        while (i <= nzeros) {
            result[i] = 48;
            ++i;
        }
        int i2 = nzeros + 1;
        int j = 0;
        while (i2 < 6) {
            result[i2] = s.charAt(j);
            ++i2;
            ++j;
        }
        return new String(result);
    }

    private void init() {
        int lastComp = this.jspFile.lastIndexOf("/");
        if (lastComp > 0) {
            this.pkgDir = this.jspFile.substring(1, lastComp);
        }
        if (this.pkgDir != null) {
            this.pkgDir = JavaGeneratorTool.manglePackage(this.pkgDir);
            this.pkgDir = this.pkgDir.replace('.', '_');
            this.pkgDir = this.fixInvalidChars(this.pkgDir);
            this.classDir = "/".equals(File.separator) ? this.workDir + File.separator + this.pkgDir : this.workDir + File.separator + this.pkgDir.replace('/', File.separatorChar);
        } else {
            this.classDir = this.workDir;
        }
        int extIdx = this.jspFile.lastIndexOf(".");
        this.baseClassN = extIdx < 0 ? (lastComp >= 0 ? this.jspFile.substring(lastComp + 1) : this.jspFile.substring(0)) : (lastComp >= 0 ? this.jspFile.substring(lastComp + 1, extIdx) : this.jspFile.substring(0, extIdx));
        if (JavaGeneratorTool.isKeyword(this.baseClassN)) {
            this.baseClassN = "_" + this.baseClassN;
        }
        this.baseClassN = this.fixInvalidChars(this.baseClassN);
        this.version = JavaGeneratorTool.readVersion(this.classDir, this.baseClassN);
        if (this.version == -1) {
            this.version = 0;
        }
        this.updateVersionPaths();
    }

    private void updateVersionPaths() {
        String baseName = this.classDir + File.separator + JavaGeneratorTool.getVersionedName(this.baseClassN, this.version);
        this.javaFileName = baseName + ".java";
        this.classFileName = baseName + ".class";
    }

    public void nextVersion() {
        ++this.version;
        JavaGeneratorTool.writeVersion(this.getClassDir(), this.baseClassN, this.version);
        this.updateVersionPaths();
    }
}

