/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.io.FileUtil;
import org.apache.tomcat.util.res.StringManager;

public final class PathSetter
extends BaseInterceptor {
    private static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    public static final String DEFAULT_WORK_DIR = "work";

    public void addInterceptor(ContextManager cm, Context ctx, BaseInterceptor module) throws TomcatException {
        String installDir;
        if (this != module) {
            return;
        }
        String home = cm.getHome();
        if (home == null) {
            home = System.getProperty("tomcat.home");
        }
        if (home == null) {
            home = IntrospectionUtils.guessInstall((String)"tomcat.install", (String)"tomcat.home", (String)"tomcat_core.jar", (String)"org/apache/tomcat/core/Request.class");
        }
        if (home != null) {
            home = FileUtil.getCanonicalPath((String)home);
            cm.setHome(home);
        }
        if ((installDir = cm.getInstallDir()) == null) {
            installDir = IntrospectionUtils.guessInstall((String)"tomcat.install", (String)"tomcat.home", (String)"tomcat_core.jar", (String)"org/apache/tomcat/core/Request.class");
        }
        if (installDir != null) {
            installDir = FileUtil.getCanonicalPath((String)installDir);
            cm.setInstallDir(installDir);
        }
        if (home != null && installDir == null) {
            cm.setInstallDir(home);
            installDir = home;
        }
        if (home == null && installDir != null) {
            cm.setHome(installDir);
            home = installDir;
        }
        if (home == null && installDir == null) {
            installDir = home = FileUtil.getCanonicalPath((String)".");
            cm.setHome(home);
            cm.setInstallDir(home);
        }
        ((Hashtable)System.getProperties()).put("tomcat.home", cm.getHome());
        ((Hashtable)System.getProperties()).put("tomcat.install", cm.getInstallDir());
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        String workDir = cm.getWorkDir();
        if (workDir == null) {
            workDir = DEFAULT_WORK_DIR;
        }
        if (!FileUtil.isAbsolute((String)workDir)) {
            workDir = FileUtil.getCanonicalPath((String)(cm.getHome() + File.separator + workDir));
        }
        cm.setWorkDir(workDir);
        if (this.debug > 0 || !cm.getHome().equals(cm.getInstallDir())) {
            this.log("install=" + cm.getInstallDir());
        }
        this.log("home=" + cm.getHome());
        if (this.debug > 0) {
            this.log(" work=" + workDir);
        }
    }

    public void engineState(ContextManager cm, int state) throws TomcatException {
        if (state != 1) {
            return;
        }
        Enumeration ctxsE = cm.getContexts();
        while (ctxsE.hasMoreElements()) {
            Context context = (Context)ctxsE.nextElement();
            this.addContext(cm, context);
        }
    }

    public void addContext(ContextManager cm, Context ctx) throws TomcatException {
        String docBase = ctx.getDocBase();
        String absPath = ctx.getAbsolutePath();
        if (absPath == null) {
            absPath = FileUtil.isAbsolute((String)docBase) ? docBase : cm.getHome() + File.separator + docBase;
            try {
                absPath = new File(absPath).getCanonicalPath();
            }
            catch (IOException npe) {
                // empty catch block
            }
            ctx.setAbsolutePath(absPath);
        }
        if (this.debug > 0) {
            String h = ctx.getHost();
            this.log("addContext: " + (h == null ? "" : h) + ":" + ctx.getPath() + " " + docBase + " " + absPath + " " + cm.getHome());
        }
    }
}

