/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.hooks.Hooks;
import org.apache.tomcat.util.io.FileUtil;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.XmlAction;
import org.apache.tomcat.util.xml.XmlMapper;
import org.xml.sax.AttributeList;

public class ServerXmlReader
extends BaseInterceptor {
    private static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    String configFile = null;
    String moduleFile = null;
    static final String DEFAULT_CONFIG = "conf/server.xml";
    static final String DEFAULT_MODULES = "conf/modules.xml";
    boolean useCachedModules = true;

    public void setConfig(String s) {
        this.configFile = s;
    }

    public void setHome(String h) {
        ((Hashtable)System.getProperties()).put("tomcat.home", h);
    }

    public void setModuleConfig(String f) {
        this.moduleFile = f;
    }

    public void addInterceptor(ContextManager cm, Context ctx, BaseInterceptor module) throws TomcatException {
        if (this != module) {
            return;
        }
        this.setupHookFinder();
        XmlMapper xh = new XmlMapper();
        xh.setDebug(this.debug);
        xh.addRule("ContextManager", xh.setProperties());
        ServerXmlReader.setPropertiesRules(cm, xh);
        ServerXmlReader.setTagRules(xh);
        this.addDefaultTags(cm, xh);
        this.setBackward(xh);
        File f = null;
        f = this.configFile == null ? new File(cm.getHome(), DEFAULT_CONFIG) : new File(this.configFile);
        if (f.exists()) {
            f = new File(f.getAbsolutePath());
            cm.setNote("configFile", (Object)f.getAbsolutePath());
            ServerXmlReader.loadConfigFile(xh, f, cm);
            String s = f.getAbsolutePath();
            if (s.startsWith(cm.getHome())) {
                s = "$TOMCAT_HOME" + s.substring(cm.getHome().length());
            }
            this.log("Config=" + s);
            Vector v = ServerXmlReader.getUserConfigFiles(f);
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                f = (File)e.nextElement();
                ServerXmlReader.loadConfigFile(xh, f, cm);
                cm.log(sm.getString("tomcat.loading") + " " + f);
            }
        } else {
            this.log("Warning: Server configuration file " + f + " was not found!");
        }
    }

    public static void loadConfigFile(XmlMapper xh, File f, Object cm) throws TomcatException {
        try {
            xh.readXml(f, cm);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new TomcatException((Throwable)ex);
        }
    }

    public static void setPropertiesRules(ContextManager cm, XmlMapper xh) throws TomcatException {
        CMPropertySource propS = new CMPropertySource(cm);
        xh.setPropertySource((Object)propS);
        xh.addRule("ContextManager/Property", new XmlAction(){

            public void start(SaxContext ctx) throws Exception {
                AttributeList attributes = ctx.getCurrentAttributes();
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                if (name == null || value == null) {
                    return;
                }
                XmlMapper xm = ctx.getMapper();
                ContextManager cm1 = (ContextManager)ctx.currentObject();
                value = xm.replaceProperties(value);
                if (cm1.getDebug() > 0) {
                    cm1.log("Setting " + name + "=" + value);
                }
                cm1.setProperty(name, value);
            }
        });
        xh.addRule("ContextManager/property", new XmlAction(){

            public void start(SaxContext ctx) throws Exception {
                AttributeList attributes = ctx.getCurrentAttributes();
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                if (name == null || value == null) {
                    return;
                }
                XmlMapper xm = ctx.getMapper();
                ContextManager cm1 = (ContextManager)ctx.currentObject();
                value = xm.replaceProperties(value);
                if (cm1.getDebug() > 0) {
                    cm1.log("Setting " + name + "=" + value);
                }
                cm1.setProperty(name, value);
            }
        });
    }

    public static void addTagRules(ContextManager cm, XmlMapper xh) throws TomcatException {
        Hashtable modules = (Hashtable)cm.getNote("modules");
        if (modules == null) {
            return;
        }
        Enumeration keys = modules.keys();
        while (keys.hasMoreElements()) {
            String tag = (String)keys.nextElement();
            String classN = (String)modules.get(tag);
            ServerXmlReader.addTagRule(xh, tag, classN);
        }
    }

    public static void addTagRule(XmlMapper xh, String tag, String classN) {
        xh.addRule(tag, xh.objectCreate(classN, null));
        xh.addRule(tag, xh.setProperties());
        xh.addRule(tag, xh.addChild("addInterceptor", "org.apache.tomcat.core.BaseInterceptor"));
    }

    public static void setTagRules(XmlMapper xh) {
        xh.addRule("module", new XmlAction(){

            public void start(SaxContext ctx) throws Exception {
                Object elem = ctx.currentObject();
                AttributeList attributes = ctx.getCurrentAttributes();
                String name = attributes.getValue("name");
                String classN = attributes.getValue("javaClass");
                if (name == null || classN == null) {
                    return;
                }
                ContextManager cm = (ContextManager)ctx.currentObject();
                Hashtable modules = (Hashtable)cm.getNote("modules");
                modules.put(name, classN);
                ServerXmlReader.addTagRule(ctx.getMapper(), name, classN);
                if (ctx.getDebug() > 0) {
                    ctx.log("Adding " + name + " " + classN);
                }
            }
        });
    }

    public void addDefaultTags(ContextManager cm, XmlMapper xh) throws TomcatException {
        File f;
        if (cm.getNote("modules") != null) {
            return;
        }
        if (this.moduleFile == null) {
            this.moduleFile = DEFAULT_MODULES;
        }
        if (!(f = new File(this.moduleFile)).isAbsolute()) {
            f = new File(cm.getHome(), this.moduleFile);
        }
        if (f.exists()) {
            File cachedM = new File(cm.getWorkDir());
            if (!cachedM.isAbsolute()) {
                cachedM = new File(cm.getHome(), cm.getWorkDir());
            }
            cachedM = new File(cachedM, "modules.properties");
            Properties modules = new Properties();
            cm.setNote("modules", (Object)modules);
            if (this.useCachedModules && cachedM.exists() && cachedM.lastModified() > f.lastModified()) {
                this.loadCachedModules(cachedM, modules);
                ServerXmlReader.addTagRules(cm, xh);
                return;
            }
            ServerXmlReader.loadConfigFile(xh, f, cm);
            Vector v = ServerXmlReader.getUserConfigFiles(f);
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                f = (File)e.nextElement();
                ServerXmlReader.loadConfigFile(xh, f, cm);
            }
            this.saveCachedModules(cachedM, modules);
        } else {
            this.log("Warning: Modules configuration file " + f + " was not found!");
        }
    }

    void loadCachedModules(File f, Properties mods) {
        try {
            FileInputStream pos = new FileInputStream(f);
            mods.load(pos);
        }
        catch (IOException ex) {
            this.log("Error loading modules ", ex);
        }
    }

    void saveCachedModules(File f, Properties mods) {
        try {
            FileOutputStream pos = new FileOutputStream(f);
            mods.save(pos, "Auto-generated cache file");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void setupHookFinder() {
        Hooks.setHookFinder((Hooks.HookFinder)new IntrospectionHookFinder());
    }

    public static Vector getUserConfigFiles(File master) {
        File dir = new File(master.getParent());
        String[] names = dir.list();
        String masterName = master.getAbsolutePath();
        String base = FileUtil.getBase((String)masterName) + "-";
        String ext = FileUtil.getExtension((String)masterName);
        Vector<File> v = new Vector<File>();
        if (names == null) {
            return v;
        }
        int i = 0;
        while (i < names.length) {
            if (names[i].startsWith(base) && (ext == null || names[i].endsWith(ext))) {
                File found = new File(dir, names[i]);
                v.addElement(found);
            }
            ++i;
        }
        return v;
    }

    private void setBackward(XmlMapper xh) {
        xh.addRule("ContextManager/ContextInterceptor", xh.objectCreate(null, "className"));
        xh.addRule("ContextManager/ContextInterceptor", xh.setProperties());
        xh.addRule("ContextManager/ContextInterceptor", xh.addChild("addInterceptor", "org.apache.tomcat.core.BaseInterceptor"));
        xh.addRule("ContextManager/RequestInterceptor", xh.objectCreate(null, "className"));
        xh.addRule("ContextManager/RequestInterceptor", xh.setProperties());
        xh.addRule("ContextManager/RequestInterceptor", xh.addChild("addInterceptor", "org.apache.tomcat.core.BaseInterceptor"));
        xh.addRule("ContextManager/Connector", xh.objectCreate(null, "className"));
        xh.addRule("ContextManager/Connector", xh.setParent("setContextManager", "org.apache.tomcat.core.ContextManager"));
        xh.addRule("ContextManager/Connector", xh.addChild("addInterceptor", "org.apache.tomcat.core.BaseInterceptor"));
        xh.addRule("ContextManager/Connector/Parameter", xh.methodSetter("setProperty", 2));
        xh.addRule("ContextManager/Connector/Parameter", xh.methodParam(0, "name"));
        xh.addRule("ContextManager/Connector/Parameter", xh.methodParam(1, "value"));
        xh.addRule("Server/Logger", xh.objectCreate("org.apache.tomcat.util.log.QueueLogger"));
        xh.addRule("Server/Logger", xh.setProperties());
        xh.addRule("Server/Logger", xh.addChild("addLogger", "org.apache.tomcat.util.log.Logger"));
    }

    static class IntrospectionHookFinder
    implements Hooks.HookFinder {
        IntrospectionHookFinder() {
        }

        public boolean hasHook(Object o, String hook) {
            return IntrospectionUtils.hasHook((Object)o, (String)hook);
        }
    }

    static class CMPropertySource
    implements IntrospectionUtils.PropertySource {
        ContextManager cm;

        CMPropertySource(ContextManager cm) {
            this.cm = cm;
        }

        public String getProperty(String key) {
            if ("tomcat.home".equals(key)) {
                return this.cm.getHome();
            }
            if ("tomcat.install".equals(key)) {
                return this.cm.getInstallDir();
            }
            String s = this.cm.getProperty(key);
            if (s == null) {
                s = System.getProperty(key);
            }
            return s;
        }
    }
}

