/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.config;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.modules.config.LoaderInterceptor11;
import org.apache.tomcat.modules.config.ServerXmlReader;
import org.apache.tomcat.util.xml.SaxContext;
import org.apache.tomcat.util.xml.XmlAction;
import org.apache.tomcat.util.xml.XmlMapper;
import org.xml.sax.AttributeList;

public class TrustedLoader
extends BaseInterceptor {
    Hashtable allModules = new Hashtable();

    public void engineState(ContextManager cm, int state) throws TomcatException {
        if (state != 1) {
            return;
        }
        if (this.debug > 0) {
            this.log("TrustedLoader: " + state);
        }
        Enumeration ctxsE = cm.getContexts();
        while (ctxsE.hasMoreElements()) {
            File modules;
            Context context = (Context)ctxsE.nextElement();
            if (!context.isTrusted() || (modules = this.getModuleFile(context)) == null) continue;
            LoaderInterceptor11 loaderHelper = new LoaderInterceptor11();
            loaderHelper.setContextManager(cm);
            loaderHelper.addContext(cm, context);
            loaderHelper.contextInit(context);
            Vector modV = new Vector();
            if (this.debug > 0) {
                this.log("loadInterceptors in a dummy classloader for setup " + context + " " + context.isTrusted() + " " + context.getDocBase());
            }
            this.loadInterceptors(context, modules, modV);
            cm.setNote("trustedLoader.currentContext", (Object)context);
            Vector<BaseInterceptor> ctxModules = new Vector<BaseInterceptor>();
            this.allModules.put(context, ctxModules);
            int i = 0;
            while (i < modV.size()) {
                BaseInterceptor bi = (BaseInterceptor)modV.elementAt(i);
                if (this.debug > 0) {
                    this.log("Add dummy module, for configuration " + context.getDocBase() + " " + context);
                }
                cm.addInterceptor(bi);
                ctxModules.addElement(bi);
                ++i;
            }
            cm.setNote("trustedLoader.currentContext", null);
            context.setClassLoader(null);
        }
    }

    public void contextInit(Context ctx) throws TomcatException {
        File modules;
        if (!ctx.isTrusted()) {
            return;
        }
        if (this.debug > 0) {
            this.log("contextInit " + ctx + " " + this.cm.getState());
        }
        if ((modules = this.getModuleFile(ctx)) == null) {
            return;
        }
        this.reInitModules(ctx, modules);
    }

    private void reInitModules(Context ctx, File modules) throws TomcatException {
        Vector<BaseInterceptor> ctxModules;
        if (this.debug > 0) {
            this.log("reInit " + modules);
        }
        if ((ctxModules = (Vector<BaseInterceptor>)this.allModules.get(ctx)) != null) {
            int i = 0;
            while (i < ctxModules.size()) {
                BaseInterceptor bi = (BaseInterceptor)ctxModules.elementAt(i);
                this.cm.removeInterceptor(bi);
                ++i;
            }
            ctxModules.removeAllElements();
        } else {
            ctxModules = new Vector<BaseInterceptor>();
            this.allModules.put(ctx, ctxModules);
        }
        Vector modV = new Vector();
        if (this.debug > 0) {
            this.log("Loading the real module " + ctx + " " + modules);
        }
        this.loadInterceptors(ctx, modules, modV);
        this.cm.setNote("trustedLoader.currentContext", (Object)ctx);
        int i = 0;
        while (i < modV.size()) {
            BaseInterceptor bi = (BaseInterceptor)modV.elementAt(i);
            this.cm.addInterceptor(bi);
            ctxModules.addElement(bi);
            ++i;
        }
        this.cm.setNote("trustedLoader.currentContext", null);
    }

    public void reload(Request req, Context context) throws TomcatException {
        if (!context.isTrusted()) {
            return;
        }
        File modules = this.getModuleFile(context);
        if (modules == null) {
            return;
        }
        if (this.debug > 0) {
            this.log("Reload modules " + context.getPath());
        }
        this.reInitModules(context, modules);
    }

    public void loadInterceptors(Context ctx, File modulesF, Vector modulesV) throws TomcatException {
        XmlMapper xh = new XmlMapper();
        xh.setClassLoader(ctx.getClassLoader());
        TrustedLoader.setTagRules(xh);
        ServerXmlReader.loadConfigFile(xh, modulesF, modulesV);
    }

    public static void addTagRule(XmlMapper xh, String tag, String classN) {
        xh.addRule(tag, xh.objectCreate(classN, null));
        xh.addRule(tag, xh.setProperties());
        xh.addRule(tag, new XmlAction(){

            public void end(SaxContext ctx) throws Exception {
                Vector modules = (Vector)ctx.getRoot();
                Object obj = ctx.currentObject();
                modules.addElement(obj);
            }
        });
    }

    public static void setTagRules(XmlMapper xh) {
        xh.addRule("module", new XmlAction(){

            public void start(SaxContext ctx) throws Exception {
                Object elem = ctx.currentObject();
                AttributeList attributes = ctx.getCurrentAttributes();
                String name = attributes.getValue("name");
                String classN = attributes.getValue("javaClass");
                if (name == null || classN == null) {
                    return;
                }
                TrustedLoader.addTagRule(ctx.getMapper(), name, classN);
                if (ctx.getDebug() > 0) {
                    ctx.log("Adding " + name + " " + classN);
                }
            }
        });
    }

    private File getModuleFile(Context ctx) {
        String dir = ctx.getAbsolutePath();
        File f = new File(dir);
        File modules = new File(f, "WEB-INF" + File.separator + "interceptors.xml");
        if (modules.exists()) {
            ctx.log("Loading modules from webapp " + modules);
            return modules;
        }
        if (this.debug > 0) {
            ctx.log("Can't find " + modules);
        }
        return null;
    }
}

