/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.generators;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Handler;
import org.apache.tomcat.core.OutputBuffer;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.buf.UEncoder;
import org.apache.tomcat.util.http.AcceptLanguage;
import org.apache.tomcat.util.http.LocaleToCharsetMap;
import org.apache.tomcat.util.io.FileUtil;
import org.apache.tomcat.util.res.StringManager;

final class DirHandler
extends Handler {
    private static final String datePattern = "EEE, dd MMM yyyyy HH:mm z";
    int realFileNote;
    int sbNote = 0;
    Context context;
    Locale defLocale = null;
    String defCharset = null;
    StringManager defSM = null;

    DirHandler() {
        this.name = "tomcat.dirHandler";
    }

    public void setNoteId(int n) {
        this.realFileNote = n;
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public void setUseAcceptLanguage(boolean use) {
        if (use) {
            this.defLocale = null;
            this.defSM = null;
        } else {
            this.defLocale = Locale.getDefault();
            this.defSM = StringManager.getManager((String)"org.apache.tomcat.resources", (Locale)this.defLocale);
        }
    }

    public void setCharset(String charset) {
        this.defCharset = charset;
    }

    public void doService(Request req, Response res) throws Exception {
        UEncoder utfEncoder;
        String relPath;
        String relPathU;
        StringManager sm;
        Locale locale;
        String charset = null;
        if (this.defLocale == null) {
            String acceptL = req.getMimeHeaders().getHeader("Accept-Language");
            locale = AcceptLanguage.getLocale((String)acceptL);
            sm = StringManager.getManager((String)"org.apache.tomcat.resources", (Locale)locale);
        } else {
            locale = this.defLocale;
            sm = this.defSM;
        }
        if (this.defCharset != null) {
            charset = "locale".equals(this.defCharset) ? LocaleToCharsetMap.getCharset((Locale)locale) : this.defCharset;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern, locale);
        boolean inInclude = req.getChild() != null;
        Request subReq = req;
        if (inInclude) {
            subReq = req.getChild();
        }
        Context ctx = req.getContext();
        String pathInfo = subReq.servletPath().toString();
        if (pathInfo == null) {
            pathInfo = "";
        }
        String absPath = FileUtil.safePath((String)this.context.getAbsolutePath(), (String)pathInfo);
        File file = new File(absPath);
        String requestURI = subReq.requestURI().toString();
        String base = ctx.getAbsolutePath();
        if (absPath.length() > base.length() && ((relPathU = (relPath = absPath.substring(base.length() + 1)).toUpperCase()).startsWith("WEB-INF") || relPathU.startsWith("META-INF"))) {
            this.context.getContextManager().handleStatus(req, res, 404);
            return;
        }
        OutputBuffer buf = res.getBuffer();
        if (this.sbNote == 0) {
            this.sbNote = req.getContextManager().getNoteId(2, "uft8encoder");
        }
        if ((utfEncoder = (UEncoder)req.getNote(this.sbNote)) == null) {
            utfEncoder = new UEncoder();
            utfEncoder.addSafeCharacter('/');
        }
        if (!inInclude) {
            if (charset == null || charset.equalsIgnoreCase("ISO-8859-1")) {
                res.setContentType("text/html");
            } else {
                res.setContentType("text/html; charset=" + charset);
                res.setUsingWriter(true);
            }
            buf.write("<html>\r\n");
            buf.write("<head>\r\n");
            buf.write("<title>");
            buf.write(sm.getString("defaultservlet.directorylistingfor"));
            buf.write(requestURI);
            buf.write("</title>\r\n</head><body bgcolor=white>\r\n");
        }
        buf.write("<table width=90% cellspacing=0 ");
        buf.write("cellpadding=5 align=center>");
        buf.write("<tr><td colspan=3><font size=+2><strong>");
        buf.write(sm.getString("defaultservlet.directorylistingfor"));
        buf.write(requestURI);
        buf.write("</strong></td></tr>\r\n");
        if (!pathInfo.equals("/")) {
            buf.write("<tr><td colspan=3 bgcolor=#ffffff>");
            String toPath = requestURI;
            if (toPath.endsWith("/")) {
                toPath = toPath.substring(0, toPath.length() - 1);
            }
            toPath = toPath.substring(0, toPath.lastIndexOf("/"));
            toPath = toPath + "/";
            buf.write("<a href=\"");
            utfEncoder.urlEncode((Writer)buf, toPath);
            buf.write("\"><tt>");
            buf.write(sm.getString("defaultservlet.upto"));
            buf.write(toPath);
            buf.write("</tt></a></td></tr>\r\n");
        }
        String slashedRequestURI = null;
        slashedRequestURI = requestURI.endsWith("/") ? requestURI : requestURI + "/";
        String[] fileNames = file.list();
        boolean dirsHead = true;
        boolean shaderow = false;
        int i = 0;
        while (i < fileNames.length) {
            File f;
            String fileName = fileNames[i];
            if ((pathInfo.length() != 0 && !"/".equals(pathInfo) || !"WEB-INF".equalsIgnoreCase(fileName)) && !"META-INF".equalsIgnoreCase(fileName) && (f = new File(file, fileName)).isDirectory()) {
                if (dirsHead) {
                    dirsHead = false;
                    buf.write("<tr><td colspan=3 bgcolor=#cccccc>");
                    buf.write("<font size=+2><strong>");
                    buf.write(sm.getString("defaultservlet.subdirectories"));
                    buf.write("</strong>\r\n");
                    buf.write("</font></td></tr>\r\n");
                }
                String fileN = f.getName();
                buf.write("<tr");
                if (shaderow) {
                    buf.write(" bgcolor=#eeeeee");
                }
                shaderow = !shaderow;
                buf.write("><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                buf.write("<tt><a href=\"");
                utfEncoder.urlEncode((Writer)buf, slashedRequestURI);
                utfEncoder.urlEncode((Writer)buf, fileN);
                buf.write("/\">");
                buf.write(fileN);
                buf.write("/</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                buf.write("</tt>\r\n");
                buf.write("</td><td><tt>&nbsp;&nbsp;</tt></td>");
                buf.write("<td align=right><tt>");
                buf.write(dateFormat.format(new Date(f.lastModified())));
                buf.write("</tt></td></tr>\r\n");
            }
            ++i;
        }
        shaderow = false;
        buf.write("<tr><td colspan=3 bgcolor=#ffffff>&nbsp;</td></tr>");
        boolean fileHead = true;
        int i2 = 0;
        while (i2 < fileNames.length) {
            File f = new File(file, fileNames[i2]);
            if (f.isFile()) {
                String fileN = f.getName();
                if (fileHead) {
                    fileHead = false;
                    buf.write("<tr><td colspan=4 bgcolor=#cccccc>");
                    buf.write("<font size=+2><strong>");
                    buf.write(sm.getString("defaultservlet.files"));
                    buf.write("</strong></font></td></tr>");
                }
                buf.write("<tr");
                if (shaderow) {
                    buf.write(" bgcolor=#eeeeee");
                }
                shaderow = !shaderow;
                buf.write("><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n");
                buf.write("<tt><a href=\"");
                utfEncoder.urlEncode((Writer)buf, slashedRequestURI);
                utfEncoder.urlEncode((Writer)buf, fileN);
                buf.write("\">");
                buf.write(fileN);
                buf.write("</a>");
                buf.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</tt>");
                buf.write("</td>\r\n");
                buf.write("<td align=right><tt>");
                this.displaySize(buf, (int)f.length());
                buf.write("</tt></td>");
                buf.write("<td align=right><tt>");
                buf.write(dateFormat.format(new Date(f.lastModified())));
                buf.write("</tt></td></tr>\r\n");
            }
            buf.write("\r\n");
            ++i2;
        }
        buf.write("<tr><td colspan=3 bgcolor=#ffffff>&nbsp;</td></tr>");
        buf.write("<tr><td colspan=3 bgcolor=#cccccc>");
        buf.write("<font size=-1>");
        buf.write("Tomcat Web Server");
        buf.write(" v");
        buf.write("3.3.1 Final");
        buf.write("</font></td></tr></table>");
        if (!inInclude) {
            buf.write("</body></html>\r\n");
        }
    }

    void displaySize(OutputBuffer buf, int filesize) throws IOException {
        int leftside = filesize / 1024;
        int rightside = filesize % 1024 / 103;
        if (leftside == 0 && rightside == 0 && filesize != 0) {
            rightside = 1;
        }
        buf.write(String.valueOf(leftside));
        buf.write(".");
        buf.write(String.valueOf(rightside));
        buf.write(" KB");
    }
}

