/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.mappers;

import java.io.IOException;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.ContentType;
import org.apache.tomcat.util.http.MimeHeaders;

public class DecodeInterceptor
extends BaseInterceptor {
    private String defaultEncoding = null;
    private boolean useSessionEncoding = true;
    private String charsetAttribute = "charset";
    private String charsetURIAttribute = ";charset=";
    private int encodingInfoNote;
    private int decodedNote;
    private int encodingSourceNote;
    private int sessionEncodingNote;
    private boolean normalize = true;
    private boolean safe = true;
    private boolean saveOriginal = false;

    public void setDefaultEncoding(String s) {
        this.defaultEncoding = s;
    }

    public void setUseSessionEncoding(boolean b) {
        this.useSessionEncoding = b;
    }

    public void setCharsetAttribute(String s) {
        this.charsetAttribute = s;
        this.charsetURIAttribute = ";" + this.charsetAttribute + "=";
    }

    public void setNormalize(boolean b) {
        this.normalize = b;
    }

    public void setSaveOriginal(boolean b) {
        this.saveOriginal = b;
    }

    public void setSafe(boolean b) {
        this.safe = b;
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        this.encodingInfoNote = cm.getNoteId(2, "req.encoding");
        this.encodingSourceNote = cm.getNoteId(2, "req.encodingSource");
        this.sessionEncodingNote = cm.getNoteId(4, "session.encoding");
        this.decodedNote = cm.getNoteId(2, "req.decoded");
    }

    private void normalizePath(MessageBytes pathMB) {
        String str1;
        String orig;
        if (this.debug > 0) {
            this.log("Normalize " + pathMB.toString());
        }
        if (pathMB.getType() == 2) {
            boolean modified = this.normalize(pathMB.getByteChunk());
            if (modified) {
                pathMB.resetStringValue();
            }
        } else if (pathMB.getType() == 3) {
            String str12;
            String orig2 = pathMB.toString();
            if (orig2 != (str12 = this.normalize(orig2))) {
                pathMB.resetStringValue();
                pathMB.setString(str12);
            }
        } else if (pathMB.getType() == 1 && (orig = pathMB.toString()) != (str1 = this.normalize(orig))) {
            pathMB.resetStringValue();
            pathMB.setString(str1);
        }
    }

    private boolean normalize(ByteChunk bc) {
        int start = bc.getStart();
        int end = bc.getEnd();
        byte[] buff = bc.getBytes();
        int i = 0;
        int j = 0;
        boolean modified = false;
        String orig = null;
        if (this.debug > 0) {
            orig = new String(buff, start, end - start);
        }
        i = start;
        j = start;
        while (i < end - 1) {
            if (buff[i] == 47 && buff[i + 1] == 47) {
                while (buff[i + 1] == 47) {
                    ++i;
                }
            }
            buff[j++] = buff[i];
            ++i;
        }
        if (i != j) {
            buff[j++] = buff[end - 1];
            end = j;
            bc.setEnd(end);
            modified = true;
            if (this.debug > 0) {
                this.log("Eliminate // " + orig + " " + start + " " + end);
            }
        }
        i = start;
        j = start;
        while (i < end - 1) {
            if (buff[i] == 46 && buff[i + 1] == 47 && (i == 0 || buff[i - 1] == 47)) {
                if (++i == end - 1) {
                    --j;
                }
            } else {
                buff[j++] = buff[i];
            }
            ++i;
        }
        if (i != j) {
            buff[j++] = buff[end - 1];
            end = j;
            bc.setEnd(end);
            modified = true;
            if (this.debug > 0) {
                this.log("Eliminate /./ " + orig);
            }
        }
        j = end;
        if (end == start + 1 && buff[start] == 46) {
            --end;
        } else if (end > start + 1 && buff[end - 1] == 46 && buff[end - 2] == 47) {
            end -= 2;
        }
        if (end != j) {
            bc.setEnd(end);
            modified = true;
            if (this.debug > 0) {
                this.log("Eliminate ending /. " + orig);
            }
        }
        i = start;
        j = start;
        while (i < end - 2) {
            if (buff[i] == 46 && buff[i + 1] == 46 && buff[i + 2] == 47 && (i == 0 || buff[i - 1] == 47)) {
                ++i;
                j -= 2;
                while (j > 0 && buff[j] != 47) {
                    --j;
                }
            } else {
                buff[j++] = buff[i];
            }
            ++i;
        }
        if (i != j) {
            buff[j++] = buff[end - 2];
            buff[j++] = buff[end - 1];
            end = j;
            bc.setEnd(end);
            modified = true;
            if (this.debug > 0) {
                this.log("Eliminate /../ " + orig);
            }
        }
        j = end;
        if (end > start + 3 && buff[end - 1] == 46 && buff[end - 2] == 46 && buff[end - 3] == 47) {
            end -= 4;
            while (end > 0 && buff[end] != 47) {
                --end;
            }
        }
        if (end != j) {
            bc.setEnd(end);
            modified = true;
            if (this.debug > 0) {
                this.log("Eliminate ending /.. " + orig);
            }
        }
        return modified;
    }

    private String normalize(String str) {
        int start = 0;
        int end = str.length();
        char[] buff = str.toCharArray();
        int i = 0;
        int j = 0;
        boolean modified = false;
        String orig = str;
        i = start;
        j = start;
        while (i < end - 1) {
            if (buff[i] == '/' && buff[i + 1] == '/') {
                while (buff[i + 1] == '/') {
                    ++i;
                }
            }
            buff[j++] = buff[i];
            ++i;
        }
        if (i != j) {
            buff[j++] = buff[end - 1];
            end = j;
            modified = true;
            if (this.debug > 0) {
                this.log("Eliminate // " + orig + " " + start + " " + end);
            }
        }
        i = start;
        j = start;
        while (i < end - 1) {
            if (buff[i] == '.' && buff[i + 1] == '/' && (i == 0 || buff[i - 1] == '/')) {
                if (++i == end - 1) {
                    --j;
                }
            } else {
                buff[j++] = buff[i];
            }
            ++i;
        }
        if (i != j) {
            buff[j++] = buff[end - 1];
            end = j;
            modified = true;
            if (this.debug > 0) {
                this.log("Eliminate /./ " + orig);
            }
        }
        j = end;
        if (end == start + 1 && buff[start] == '.') {
            --end;
        } else if (end > start + 1 && buff[end - 1] == '.' && buff[end - 2] == '/') {
            end -= 2;
        }
        if (end != j) {
            modified = true;
            if (this.debug > 0) {
                this.log("Eliminate ending /. " + orig);
            }
        }
        i = start;
        j = start;
        while (i < end - 2) {
            if (buff[i] == '.' && buff[i + 1] == '.' && buff[i + 2] == '/' && (i == 0 || buff[i - 1] == '/')) {
                ++i;
                j -= 2;
                while (j > 0 && buff[j] != '/') {
                    --j;
                }
            } else {
                buff[j++] = buff[i];
            }
            ++i;
        }
        if (i != j) {
            buff[j++] = buff[end - 2];
            buff[j++] = buff[end - 1];
            end = j;
            modified = true;
            if (this.debug > 0) {
                this.log("Eliminate /../ " + orig);
            }
        }
        j = end;
        if (end > start + 3 && buff[end - 1] == '.' && buff[end - 2] == '.' && buff[end - 3] == '/') {
            end -= 4;
            while (end > 0 && buff[end] != '/') {
                --end;
            }
        }
        if (end != j) {
            modified = true;
            if (this.debug > 0) {
                this.log("Eliminate ending /.. " + orig);
            }
        }
        if (modified) {
            return new String(buff, 0, end);
        }
        return str;
    }

    private boolean isSafeURI(MessageBytes pathMB) {
        int start = pathMB.indexOf('%');
        if (start >= 0) {
            if (pathMB.indexOfIgnoreCase("%25", start) >= 0) {
                return false;
            }
            if (pathMB.indexOfIgnoreCase("%2E", start) >= 0) {
                return false;
            }
            if (pathMB.indexOfIgnoreCase("%2F", start) >= 0) {
                return false;
            }
            if (pathMB.indexOfIgnoreCase("%5C", start) >= 0) {
                return false;
            }
        }
        return true;
    }

    public int postReadRequest(Request req) {
        int idxCharset;
        MessageBytes pathMB = req.requestURI();
        if (pathMB.isNull()) {
            throw new RuntimeException("ASSERT: null path in request URI");
        }
        if (this.safe && !this.isSafeURI(pathMB)) {
            req.setAttribute("javax.servlet.error.message", (Object)"Unsafe URL");
            return 403;
        }
        if (this.normalize && (pathMB.indexOf("//") >= 0 || pathMB.indexOf("/.") >= 0)) {
            this.normalizePath(pathMB);
            if (this.debug > 0) {
                this.log("Normalized url " + pathMB);
            }
        }
        String charEncoding = null;
        MimeHeaders headers = req.getMimeHeaders();
        MessageBytes contentType = req.contentType();
        if (contentType != null) {
            String contentTypeString = contentType.toString();
            charEncoding = ContentType.getCharsetFromContentType((String)contentTypeString);
            if (this.debug > 0) {
                this.log("Got encoding from content-type " + charEncoding + " " + contentTypeString);
            }
            req.setNote(this.encodingSourceNote, (Object)"Content-Type");
        }
        if (this.debug > 99) {
            this.dumpHeaders(headers);
        }
        if (charEncoding == null && this.charsetURIAttribute != null && (idxCharset = req.requestURI().indexOf(this.charsetURIAttribute)) >= 0) {
            String uri = req.requestURI().toString();
            int nextAtt = uri.indexOf(59, idxCharset + 1);
            String next = null;
            if (nextAtt > 0) {
                next = uri.substring(nextAtt);
                charEncoding = uri.substring(idxCharset + this.charsetURIAttribute.length(), nextAtt);
                req.requestURI().setString(uri.substring(0, idxCharset) + next);
                req.setNote(this.encodingSourceNote, (Object)"Request-Attribute");
            } else {
                charEncoding = uri.substring(idxCharset + this.charsetURIAttribute.length());
                req.requestURI().setString(uri.substring(0, idxCharset));
                req.setNote(this.encodingSourceNote, (Object)"Request-Attribute");
            }
            if (this.debug > 0) {
                this.log("ReqAtt= " + charEncoding + " " + req.requestURI());
            }
        }
        if (charEncoding == null) {
            if (this.debug > 0) {
                this.log("Default encoding " + this.defaultEncoding);
            }
            if (this.defaultEncoding != null) {
                charEncoding = this.defaultEncoding;
            }
        }
        if (charEncoding != null) {
            req.setCharEncoding(charEncoding);
        }
        if (req.getNote(this.decodedNote) != null) {
            if (this.debug > 5) {
                this.log("Already decoded " + req.getNote(this.decodedNote));
            }
            return 0;
        }
        if (this.saveOriginal) {
            try {
                req.unparsedURI().duplicate(pathMB);
            }
            catch (IOException ex) {
                this.log("Error copying request ", ex);
            }
        }
        if (pathMB.indexOf('%') >= 0 || pathMB.indexOf('+') >= 0) {
            try {
                if (this.debug > 1) {
                    this.log("Before " + pathMB.toString());
                }
                req.getURLDecoder().convert(pathMB, false);
                pathMB.resetStringValue();
                if (this.debug > 1) {
                    this.log("After " + pathMB.toString());
                }
                if (pathMB.indexOf('\u0000') >= 0) {
                    return 404;
                }
                req.setNote(this.decodedNote, (Object)this);
            }
            catch (IOException ex) {
                this.log("Error decoding request ", ex);
                return 400;
            }
        }
        return 0;
    }

    public int beforeBody(Request req, Response res) {
        String charset;
        ServerSession sess;
        if (this.useSessionEncoding && (sess = req.getSession(false)) != null && (charset = res.getCharacterEncoding()) != null) {
            sess.setNote(this.sessionEncodingNote, (Object)charset);
            if (this.debug > 0) {
                this.log("Setting per session encoding " + charset);
            }
        }
        return -1;
    }

    public Object getInfo(Context ctx, Request req, int info, String k) {
        if (info == this.encodingInfoNote) {
            ServerSession sess;
            String charset = null;
            if (charset == null && this.charsetAttribute != null) {
                charset = (String)req.getAttribute(this.charsetAttribute);
                if (this.debug > 0 && charset != null) {
                    this.log("Charset from attribute " + this.charsetAttribute + " " + charset);
                }
            }
            if (charset == null && this.useSessionEncoding && (sess = req.getSession(false)) != null) {
                charset = (String)sess.getNote(this.sessionEncodingNote);
                if (this.debug > 0 && charset != null) {
                    this.log("Charset from session " + charset);
                }
            }
            if (charset != null) {
                return charset;
            }
            charset = ctx.getProperty("charset");
            if (this.debug > 0 && charset != null) {
                this.log("Default per context " + charset);
            }
            return charset;
        }
        return null;
    }

    public int setInfo(Context ctx, Request req, int info, String k, Object v) {
        return -1;
    }

    private void dumpHeaders(MimeHeaders mh) {
        int i = 0;
        while (i < mh.size()) {
            this.log(mh.getName(i) + ": " + mh.getValue(i));
            ++i;
        }
    }
}

