/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.server;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.Principal;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.util.aaa.SimplePrincipal;

class Ajp12 {
    Socket socket;
    InputStream sin;
    BufferedInputStream ajpin;
    private boolean tomcatAuthentication = true;
    boolean shutdown = false;
    boolean isPing = false;
    boolean doLog;
    String secret = null;
    static final String CHARSET = "UTF8";

    void d(String s) {
        System.out.print("Ajp12: ");
        System.out.println(s);
    }

    public int doRead() throws IOException {
        return this.ajpin.read();
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        return this.ajpin.read(b, off, len);
    }

    public void setSocket(Socket s) throws IOException {
        this.socket = s;
        this.sin = s.getInputStream();
        this.ajpin = new BufferedInputStream(this.sin);
    }

    public void setSecret(String s) {
        this.secret = s;
    }

    public void readNextRequest(Request req) throws IOException {
        try {
            boolean more = true;
            block18: while (more) {
                int marker = this.ajpin.read();
                switch (marker) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        String proto;
                        req.method().setString(Ajp12.readString(this.ajpin, null));
                        String contextPath = Ajp12.readString(this.ajpin, null);
                        if ("ROOT".equalsIgnoreCase(contextPath)) {
                            contextPath = null;
                        }
                        String dummy = Ajp12.readString(this.ajpin, null);
                        req.serverName().setString(Ajp12.readString(this.ajpin, null));
                        dummy = Ajp12.readString(this.ajpin, null);
                        req.pathInfo().setString(Ajp12.readString(this.ajpin, null));
                        dummy = Ajp12.readString(this.ajpin, null);
                        req.queryString().setString(Ajp12.readString(this.ajpin, null));
                        req.remoteAddr().setString(Ajp12.readString(this.ajpin, ""));
                        req.remoteHost().setString(Ajp12.readString(this.ajpin, ""));
                        if (this.isTomcatAuthentication()) {
                            dummy = Ajp12.readString(this.ajpin, null);
                        } else {
                            req.setRemoteUser(Ajp12.readString(this.ajpin, null));
                            req.setUserPrincipal((Principal)new SimplePrincipal(req.getRemoteUser()));
                        }
                        req.setAuthType(Ajp12.readString(this.ajpin, null));
                        dummy = Ajp12.readString(this.ajpin, null);
                        req.method().setString(Ajp12.readString(this.ajpin, null));
                        req.requestURI().setString(Ajp12.readString(this.ajpin, ""));
                        dummy = Ajp12.readString(this.ajpin, null);
                        dummy = Ajp12.readString(this.ajpin, null);
                        req.serverName().setString(Ajp12.readString(this.ajpin, ""));
                        int serverPort = 80;
                        try {
                            String p = Ajp12.readString(this.ajpin, null);
                            if (p == null) {
                                p = "80";
                            }
                            serverPort = Integer.parseInt(p);
                        }
                        catch (Exception any) {
                            any.printStackTrace();
                        }
                        req.setServerPort(serverPort);
                        if (serverPort == 443) {
                            req.scheme().setString("https");
                        }
                        if ((proto = Ajp12.readString(this.ajpin, null)) == null) {
                            proto = "HTTP/1.0";
                        }
                        req.protocol().setString(proto);
                        dummy = Ajp12.readString(this.ajpin, "");
                        dummy = Ajp12.readString(this.ajpin, "");
                        req.setJvmRoute(Ajp12.readString(this.ajpin, null));
                        dummy = Ajp12.readString(this.ajpin, "");
                        dummy = Ajp12.readString(this.ajpin, "");
                        break;
                    }
                    case 5: {
                        String token1 = Ajp12.readString(this.ajpin, null);
                        String token2 = Ajp12.readString(this.ajpin, "");
                        req.setAttribute(token1, (Object)token2);
                        if (!token1.equals("HTTPS") || !token2.equals("on")) continue block18;
                        req.scheme().setString("https");
                        break;
                    }
                    case 3: {
                        String token1 = Ajp12.readString(this.ajpin, null);
                        String token2 = Ajp12.readString(this.ajpin, "");
                        req.getMimeHeaders().addValue(token1).setString(token2);
                        break;
                    }
                    case 254: {
                        int signal = this.ajpin.read();
                        if (signal == 0) {
                            try {
                                this.socket.getOutputStream().write(0);
                                this.sin.close();
                            }
                            catch (IOException ignored) {
                                req.getContextManager().log("Exception closing, ignored", (Throwable)ignored);
                            }
                            this.isPing = true;
                            return;
                        }
                        try {
                            InetAddress serverAddr = this.socket.getLocalAddress();
                            InetAddress clientAddr = this.socket.getInetAddress();
                            if (signal == 15 && Ajp12.isSameAddress(serverAddr, clientAddr)) {
                                String stopMsg;
                                if (this.secret != null && !this.secret.equals(stopMsg = Ajp12.readString(this.ajpin, ""))) {
                                    req.getContextManager().log("Attempt to stop with the wrong secret");
                                    return;
                                }
                                ContextManager cm = req.getContextManager();
                                cm.shutdown();
                                cm.log("Exiting");
                                this.socket.setSoLinger(true, 0);
                                this.sin.close();
                                System.exit(0);
                                this.shutdown = true;
                                return;
                            }
                            this.sin.close();
                        }
                        catch (Exception ignored) {
                            req.getContextManager().log("Ignored exception processing signal " + signal, (Throwable)ignored);
                        }
                        return;
                    }
                    case 4: 
                    case 255: {
                        more = false;
                        break;
                    }
                    case -1: {
                        throw new IOException("Stream closed prematurely");
                    }
                    default: {
                        throw new IOException("Stream broken");
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            req.getContextManager().log("Uncaught exception handling request", (Throwable)e);
        }
        String requestURI = req.requestURI().toString();
        int indexQ = requestURI.indexOf("?");
        int rLen = requestURI.length();
        if (indexQ > -1 && indexQ < rLen) {
            req.queryString().setString(requestURI.substring(indexQ + 1, requestURI.length()));
            req.requestURI().setString(requestURI.substring(0, indexQ));
        }
    }

    public static boolean isSameAddress(InetAddress server, InetAddress client) {
        byte[] clientAddr;
        byte[] serverAddr = server.getAddress();
        if (serverAddr.length != (clientAddr = client.getAddress()).length) {
            return false;
        }
        boolean match = true;
        int i = 0;
        while (i < serverAddr.length) {
            if (serverAddr[i] != clientAddr[i]) {
                match = false;
                break;
            }
            ++i;
        }
        if (match) {
            return true;
        }
        int i2 = 0;
        while (i2 < serverAddr.length) {
            if (serverAddr[i2] != clientAddr[serverAddr.length - 1 - i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static int readWord(InputStream in) throws IOException {
        int b1 = in.read();
        if (b1 == -1) {
            return -1;
        }
        int b2 = in.read();
        if (b2 == -1) {
            return -1;
        }
        return (b1 << 8 | b2) & 0xFFFF;
    }

    public static String readString(InputStream in, String def) throws IOException {
        int len = Ajp12.readWord(in);
        if (len == 65535) {
            return def;
        }
        if (len == -1) {
            throw new IOException("Stream broken");
        }
        byte[] b = new byte[len];
        int p = 0;
        while (p < len) {
            int r = in.read(b, p, len - p);
            if (r < 0) {
                throw new IOException("Stream broken, couldn't demarshal string :" + len + ":" + p);
            }
            p += r;
        }
        return new String(b, CHARSET);
    }

    public boolean isTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean newTomcatAuthentication) {
        this.tomcatAuthentication = newTomcatAuthentication;
    }
}

