/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.modules.session;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.util.compat.Action;
import org.apache.tomcat.util.compat.Jdk11Compat;

public final class SessionIdGenerator
extends BaseInterceptor {
    String randomClassName = null;
    Random randomSource = null;
    DataInputStream randomIS = null;
    String devRandomSource = "/dev/urandom";
    static Jdk11Compat jdk11Compat = Jdk11Compat.getJdkCompat();
    private Object accessControlContext = null;
    private static int session_count = 0;
    private static long lastTimeVal = 0L;
    public static final long maxRandomLen = 2176782336L;
    public static final long maxSessionLifespanTics = 46656L;
    public static final long ticDifference = 2000L;

    public final void setRandomClass(String randomClass) {
        this.randomClassName = randomClass;
    }

    public void setRandomFile(String s) {
        try {
            this.devRandomSource = s;
            File f = new File(this.devRandomSource);
            if (!f.exists()) {
                return;
            }
            this.randomIS = new DataInputStream(new FileInputStream(f));
            this.randomIS.readLong();
            this.log("Opening " + this.devRandomSource);
        }
        catch (IOException ex) {
            this.randomIS = null;
        }
    }

    public int sessionState(Request req, ServerSession sess, int state) {
        if (state == 0) {
            String jsIdent = req.getJvmRoute();
            String newId = this.createNewId(jsIdent);
            if (this.debug > 0) {
                this.log("Generate new session id " + newId);
            }
            sess.getId().setString(newId);
        }
        return state;
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        try {
            this.accessControlContext = jdk11Compat.getAccessControlContext();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    String createNewId(String jsIdent) {
        String newId2;
        if (System.getSecurityManager() == null) {
            String newId2 = this.getIdentifier(jsIdent);
            return newId2;
        }
        PriviledgedIdGenerator di = new PriviledgedIdGenerator(this, jsIdent);
        try {
            newId2 = (String)jdk11Compat.doPrivileged((Action)di, this.accessControlContext);
        }
        catch (Exception ex) {
            newId2 = null;
        }
        return newId2;
    }

    private void createRandomClass() {
        if (this.randomClassName == null) {
            this.randomClassName = this.cm.getProperty("randomClass");
            if (this.randomClassName == null) {
                this.randomClassName = "java.security.SecureRandom";
            }
        }
        try {
            Class<?> randomClass = Class.forName(this.randomClassName);
            this.randomSource = (Random)randomClass.newInstance();
        }
        catch (Exception e) {
            this.log("SessionIdGenerator.createRandomClass", e);
        }
        if (this.randomSource == null) {
            this.randomSource = new SecureRandom();
        }
        this.log("Created random class " + this.randomSource.getClass().getName());
    }

    public synchronized String getIdentifier(String jsIdent) {
        StringBuffer sessionId = new StringBuffer();
        long n = 0L;
        if (this.randomIS != null) {
            try {
                n = this.randomIS.readLong();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.randomIS = null;
            }
        }
        if (this.randomIS == null) {
            if (this.randomSource == null) {
                this.createRandomClass();
            }
            n = this.randomSource.nextLong();
        }
        if (n < 0L) {
            n = -n;
        }
        n %= 2176782336L;
        sessionId.append(Long.toString(n += 2176782336L, 36).substring(1));
        long timeVal = System.currentTimeMillis() / 2000L;
        timeVal %= 46656L;
        sessionId.append(Long.toString(timeVal += 46656L, 36).substring(1));
        if (lastTimeVal != timeVal) {
            lastTimeVal = timeVal;
            session_count = 0;
        }
        sessionId.append(Long.toString(++session_count, 36));
        if (jsIdent != null && jsIdent.length() > 0) {
            return sessionId.toString() + "." + jsIdent;
        }
        return sessionId.toString();
    }

    static class PriviledgedIdGenerator
    extends Action {
        SessionIdGenerator sg;
        String jsIdent;

        public PriviledgedIdGenerator(SessionIdGenerator sg, String jsIdent) {
            this.sg = sg;
            this.jsIdent = jsIdent;
        }

        public Object run() {
            return this.sg.getIdentifier(this.jsIdent);
        }
    }
}

