/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.security.Principal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.ServerSession;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.facade.CookieFacade;
import org.apache.tomcat.facade.HttpSessionFacade;
import org.apache.tomcat.facade.ServletHandler;
import org.apache.tomcat.facade.ServletInputStreamFacade;
import org.apache.tomcat.util.buf.DateTool;
import org.apache.tomcat.util.buf.UEncoder;
import org.apache.tomcat.util.http.AcceptLanguage;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.io.FileUtil;
import org.apache.tomcat.util.res.StringManager;

public final class HttpServletRequestFacade
implements HttpServletRequest {
    private static StringManager sm = StringManager.getManager((String)"org.apache.tomcat.resources");
    private Request request;
    HttpSessionFacade sessionFacade;
    ServletInputStreamFacade isFacade = new ServletInputStreamFacade();
    boolean isFacadeInitialized = false;
    BufferedReader reader = null;
    DateFormat[] dateFormats;
    UEncoder uencoder;
    private boolean usingStream = false;
    private boolean usingReader = false;
    private boolean parametersProcessed = false;

    HttpServletRequestFacade(Request request) {
        this.request = request;
        this.isFacade.setRequest(request);
        try {
            if (this.dateFormats == null) {
                this.dateFormats = new DateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US)};
            }
            if (this.uencoder == null) {
                this.uencoder = new UEncoder();
                this.uencoder.addSafeCharacter(';');
                this.uencoder.addSafeCharacter('/');
                request.setNote("req.uencoder", (Object)this.uencoder);
            }
        }
        catch (TomcatException ex) {
            ex.printStackTrace();
        }
    }

    void recycle() {
        this.usingReader = false;
        this.usingStream = false;
        this.parametersProcessed = false;
        this.sessionFacade = null;
        if (this.isFacade != null) {
            this.isFacade.recycle();
        }
        this.isFacadeInitialized = false;
        this.reader = null;
    }

    Request getRealRequest() {
        return this.request;
    }

    void setRequest(Request req) {
        this.request = req;
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public String getCharacterEncoding() {
        String enc = this.request.getCharacterEncoding();
        try {
            Object o = this.request.getNote("req.encodingSource");
            if (o == null) {
                return null;
            }
        }
        catch (TomcatException ex) {
            ex.printStackTrace();
        }
        return enc;
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public Cookie[] getCookies() {
        Cookies cookies = this.request.getCookies();
        int count = cookies.getCookieCount();
        Cookie[] cookieArray = new Cookie[count];
        int i = 0;
        while (i < count) {
            ServerCookie sC = cookies.getCookie(i);
            cookieArray[i] = new CookieFacade(sC);
            ++i;
        }
        return cookieArray;
    }

    public long getDateHeader(String name) {
        String value = this.request.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long date = DateTool.parseDate((String)value, (DateFormat[])this.dateFormats);
        if (date == -1L) {
            String msg = sm.getString("httpDate.pe", (Object)value);
            throw new IllegalArgumentException(msg);
        }
        return date;
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            String msg = sm.getString("reqfac.getinstream.ise");
            throw new IllegalStateException(msg);
        }
        this.usingStream = true;
        if (!this.isFacadeInitialized) {
            this.isFacade.prepare();
            this.isFacadeInitialized = true;
        }
        return this.isFacade;
    }

    public int getIntHeader(String name) throws NumberFormatException {
        String value = this.request.getHeader(name);
        if (value == null) {
            return -1;
        }
        int valueInt = Integer.parseInt(value);
        return valueInt;
    }

    public String getMethod() {
        return this.request.method().toString();
    }

    public String getParameter(String name) {
        if (!this.parametersProcessed) {
            this.request.handleQueryParameters();
            if (this.request.method().equals("POST")) {
                this.request.handlePostParameters();
            }
            this.parametersProcessed = true;
        }
        return this.request.parameters().getParameter(name);
    }

    public String[] getParameterValues(String name) {
        if (!this.parametersProcessed) {
            this.request.handleQueryParameters();
            if (this.request.method().equals("POST")) {
                this.request.handlePostParameters();
            }
            this.parametersProcessed = true;
        }
        return this.request.parameters().getParameterValues(name);
    }

    public Enumeration getParameterNames() {
        if (!this.parametersProcessed) {
            this.request.handleQueryParameters();
            if (this.request.method().equals("POST")) {
                this.request.handlePostParameters();
            }
            this.parametersProcessed = true;
        }
        return this.request.parameters().getParameterNames();
    }

    public String getPathInfo() {
        return this.request.pathInfo().toString();
    }

    public String getPathTranslated() {
        String path = this.getPathInfo();
        if (path == null || "".equals(path)) {
            return null;
        }
        String pathTranslated = FileUtil.safePath((String)this.request.getContext().getAbsolutePath(), (String)path);
        return pathTranslated;
    }

    public String getProtocol() {
        return this.request.protocol().toString();
    }

    public String getQueryString() {
        String qS = this.request.queryString().toString();
        if ("".equals(qS)) {
            return null;
        }
        return qS;
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public String getScheme() {
        return this.request.scheme().toString();
    }

    public String getServerName() {
        return this.request.serverName().toString();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingStream) {
            String msg = sm.getString("reqfac.getreader.ise");
            throw new IllegalStateException(msg);
        }
        this.usingReader = true;
        if (this.reader != null) {
            return this.reader;
        }
        if (!this.isFacadeInitialized) {
            this.isFacade.prepare();
            this.isFacadeInitialized = true;
        }
        String encoding = this.request.getCharacterEncoding();
        InputStreamReader r = new InputStreamReader((InputStream)((Object)this.isFacade), encoding);
        this.reader = new BufferedReader(r);
        return this.reader;
    }

    public String getRemoteAddr() {
        return this.request.remoteAddr().toString();
    }

    public String getRemoteHost() {
        String remoteHost = this.request.remoteHost().toString();
        if (remoteHost != null && remoteHost.length() != 0) {
            return remoteHost;
        }
        try {
            remoteHost = InetAddress.getByName(this.request.remoteAddr().toString()).getHostName();
        }
        catch (Exception e) {
            remoteHost = this.request.remoteAddr().toString();
        }
        return remoteHost;
    }

    public String getRequestURI() {
        if (this.request.unparsedURI().isNull()) {
            String decoded = this.request.requestURI().toString();
            this.uencoder.setEncoding(this.request.getCharacterEncoding());
            String encoded = this.uencoder.encodeURL(decoded);
            this.request.unparsedURI().setString(encoded);
        }
        return this.request.unparsedURI().toString();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        String pI;
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/") && (path = (pI = this.request.pathInfo().toString()) == null ? FileUtil.catPath((String)this.request.servletPath().toString(), (String)path) : FileUtil.catPath((String)(this.request.servletPath().toString() + pI), (String)path)) == null) {
            return null;
        }
        Context ctx = this.request.getContext();
        return ((ServletContext)ctx.getFacade()).getRequestDispatcher(path);
    }

    public Locale getLocale() {
        return (Locale)this.getLocales().nextElement();
    }

    public Enumeration getLocales() {
        MimeHeaders headers = this.request.getMimeHeaders();
        return AcceptLanguage.getLocales((String)headers.getHeader("Accept-Language"));
    }

    public String getContextPath() {
        return this.request.getContext().getPath();
    }

    public String getServletPath() {
        return this.request.servletPath().toString();
    }

    public String getRealPath(String name) {
        Context ctx = this.request.getContext();
        return FileUtil.safePath((String)ctx.getAbsolutePath(), (String)name);
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public boolean isUserInRole(String role) {
        String mappedRole;
        ServletHandler handler = (ServletHandler)this.request.getHandler();
        String realRole = role;
        if (handler != null && (mappedRole = handler.getServletInfo().getSecurityRole(role)) != null) {
            realRole = mappedRole;
        }
        return this.request.isUserInRole(realRole);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        ServerSession realSession = this.request.getSession(create);
        if (realSession == null) {
            this.sessionFacade = null;
            return null;
        }
        this.sessionFacade = (HttpSessionFacade)realSession.getFacade();
        if (this.sessionFacade == null) {
            this.sessionFacade = new HttpSessionFacade();
            this.sessionFacade.setRealSession(realSession);
            realSession.setFacade((Object)this.sessionFacade);
        }
        return this.sessionFacade;
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        boolean isvalid = false;
        ServerSession session = this.request.getSession(false);
        if (session != null && session.getId().equals(this.getRequestedSessionId())) {
            isvalid = true;
        }
        return isvalid;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return "cookie".equals(this.request.getSessionIdSource());
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return "url".equals(this.request.getSessionIdSource());
    }
}

