/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

public final class ObjectSerializer {
    public static final Object doSerialization(ClassLoader cl, Object sessions) {
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            ObjectOutputStream o = new ObjectOutputStream(b);
            o.writeObject(sessions);
            o.flush();
            byte[] data = b.toByteArray();
            ByteArrayInputStream bIn = new ByteArrayInputStream(data);
            ACLObjectInputStream oOut = new ACLObjectInputStream(cl, bIn);
            sessions = oOut.readObject();
            return sessions;
        }
        catch (Exception e) {
            System.out.println("SessionSerializer: " + e);
            return sessions;
        }
    }

    private static final class ACLObjectInputStream
    extends ObjectInputStream {
        ClassLoader loader;

        ACLObjectInputStream(ClassLoader loader, InputStream bIn) throws IOException {
            super(bIn);
            this.loader = loader;
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            return this.loader.loadClass(v.getName());
        }
    }
}

