/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.hooks;

import java.util.Vector;

public class Hooks {
    public static final int INITIAL_HOOKS = 20;
    int hookCount = 20;
    String[] hookNames;
    Vector[] hooksV = new Vector[this.hookCount];
    Object[][] hooks;
    Vector allModulesV;
    Object[] allModules;
    private static final int dL = 0;
    static HookFinder hookFinder = null;

    public Hooks() {
        int i = 0;
        while (i < this.hookCount) {
            this.hooksV[i] = new Vector();
            ++i;
        }
        this.allModulesV = new Vector();
        this.hookNames = new String[this.hookCount];
        this.hooks = new Object[this.hookCount][];
    }

    public Vector getHooksVector(int type) {
        return this.hooksV[type];
    }

    public Vector getHooksVector() {
        return this.allModulesV;
    }

    public void resetCache() {
        int i = 0;
        while (i < this.hookCount) {
            this.hooks[i] = null;
            ++i;
        }
        this.allModules = null;
    }

    public int registerHook(String name) {
        int i = 0;
        while (i < this.hookNames.length) {
            if (this.hookNames[i] == null) {
                this.hookNames[i] = name;
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Too many hooks");
    }

    public void registerHook(String name, int id) {
        this.hookNames[id] = name;
    }

    public String getHookName(int id) {
        return this.hookNames[id];
    }

    public int getHookId(String hookName) {
        int i = 0;
        while (i < this.hookNames.length) {
            if (hookName.equals(this.hookNames[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addModule(Object bi) {
        int i = 0;
        while (i < this.hookNames.length) {
            if (this.hookNames[i] != null && Hooks.hasHook(bi, this.hookNames[i])) {
                this.hooksV[i].addElement(bi);
                this.hooks[i] = null;
            }
            ++i;
        }
        this.allModules = null;
        this.allModulesV.addElement(bi);
    }

    public void addModule(String type, Object bi) {
        int typeId = this.getHookId(type);
        this.hooksV[typeId].addElement(bi);
        this.hooks[typeId] = null;
    }

    public void removeModule(Object bi) {
        int i = 0;
        while (i < this.hookNames.length) {
            if (this.hooksV[i].contains(bi)) {
                this.hooksV[i].removeElement(bi);
                this.hooks[i] = null;
            }
            ++i;
        }
        this.allModulesV.removeElement(bi);
        this.allModules = null;
    }

    public Object[] getModules(int type) {
        if (this.hooks[type] != null) {
            return this.hooks[type];
        }
        this.hooks[type] = new Object[this.hooksV[type].size()];
        this.hooksV[type].copyInto(this.hooks[type]);
        return this.hooks[type];
    }

    public Object[] getModules() {
        if (this.allModules != null) {
            return this.allModules;
        }
        this.allModules = new Object[this.allModulesV.size()];
        this.allModulesV.copyInto(this.allModules);
        return this.allModules;
    }

    private void debug(String s) {
        System.out.println("Hooks: " + s);
    }

    private static boolean hasHook(Object obj, String methodN) {
        if (hookFinder == null) {
            return true;
        }
        return hookFinder.hasHook(obj, methodN);
    }

    public static void setHookFinder(HookFinder hf) {
        hookFinder = hf;
    }

    public static interface HookFinder {
        public boolean hasHook(Object var1, String var2);
    }
}

