/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.startup;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.apache.tomcat.util.IntrospectionUtils;

public class EnableAdmin {
    Hashtable attributes = new Hashtable();
    String[] args;
    static String[] options1 = new String[0];
    private static int dL = 10;

    public void setHome(String home) {
        this.attributes.put("home", home);
    }

    public void setInstall(String install) {
        this.attributes.put("install", install);
    }

    public void setArgs(String[] args) {
        this.attributes.put("args", args);
        this.args = args;
    }

    public void setConfig(String s) {
        this.attributes.put("config", s);
    }

    public void setAction(String s) {
        this.attributes.put("action", s);
        this.attributes.put(s, "true");
    }

    public void setSandbox(boolean b) {
        if (b) {
            this.attributes.put("sandbox", "true");
        }
    }

    public void setStop(boolean b) {
        if (b) {
            this.attributes.put("stop", "true");
        }
    }

    public void setEnableAdmin(boolean b) {
        if (b) {
            this.attributes.put("enableAdmin", "true");
        }
    }

    public void setParentClassLoader(ClassLoader cl) {
        this.attributes.put("parentClassLoader", cl);
    }

    public void setCommonClassLoader(ClassLoader cl) {
        this.attributes.put("commonClassLoader", cl);
    }

    public void setAppsClassLoader(ClassLoader cl) {
        this.attributes.put("appsClassLoader", cl);
    }

    public void setContainerClassLoader(ClassLoader cl) {
        this.attributes.put("containerClassLoader", cl);
    }

    public void execute() throws Exception {
        boolean ok;
        if (this.args != null && !(ok = this.processArgs(this.args))) {
            EnableAdmin.printUsage();
            return;
        }
        System.out.println("Overriding apps-admin settings ");
        String home = (String)this.attributes.get("home");
        if (home == null) {
            home = (String)this.attributes.get("install");
        }
        FileWriter fw = new FileWriter(home + File.separator + "conf" + File.separator + "apps-admin.xml");
        PrintWriter pw = new PrintWriter(fw);
        pw.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        pw.println("<webapps>");
        pw.println("    <!-- Special rules for the admin webapplication -->");
        pw.println("    <Context path=\"/admin\"");
        pw.println("             docBase=\"webapps/admin\"");
        pw.println("             trusted=\"true\">");
        pw.println("            <SimpleRealm filename=\"conf/users/admin-users.xml\" />");
        pw.println("    </Context>");
        pw.println("</webapps>");
        pw.close();
    }

    public static void printUsage() {
        System.out.println("Usage: java org.apache.tomcat.startup.EnableAdmin {options}");
        System.out.println("  Options are:");
        System.out.println("    -home                      Tomcat home directory");
        System.out.println();
    }

    public String[] getOptions1() {
        return options1;
    }

    public Hashtable getOptionAliases() {
        return null;
    }

    public boolean processArgs(String[] args) {
        try {
            return IntrospectionUtils.processArgs((Object)this, (String[])args, (String[])this.getOptions1(), null, (Hashtable)this.getOptionAliases());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void setProperty(String s, Object v) {
        if (dL > 0) {
            this.debug("Generic property " + s);
        }
        this.attributes.put(s, v);
    }

    public void setAttribute(String s, Object o) {
        if ("args".equals(s)) {
            String[] stringArray = (String[])o;
        }
        if (o != null) {
            this.attributes.put(s, o);
        }
    }

    public static void main(String[] args) {
        try {
            EnableAdmin task = new EnableAdmin();
            task.setArgs(args);
            task.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void debug(String s) {
        System.out.println("EnableAdmin: " + s);
    }
}

