/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;
import org.apache.tomcat.util.buf.CharChunk;

public class OutputBuffer
extends Writer
implements ByteChunk.ByteOutputChannel,
CharChunk.CharOutputChannel {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private int defaultBufferSize = 8192;
    private int defaultCharBufferSize = 4096;
    public final int INITIAL_STATE = 0;
    public final int CHAR_STATE = 1;
    public final int BYTE_STATE = 2;
    private int state = 0;
    static final int debug = 0;
    private int bytesWritten = 0;
    private int charsWritten;
    private boolean closed = false;
    private ByteChunk bb;
    private CharChunk cb;
    private String enc;
    private boolean gotEnc = false;
    private Response resp;
    private Request req;
    private ContextManager cm;
    private boolean doFlush = false;
    protected Hashtable encoders = new Hashtable();
    protected C2BConverter conv;

    public OutputBuffer() {
        this(8192);
    }

    public OutputBuffer(int size) {
        this.bb = new ByteChunk(size);
        this.bb.setLimit(size);
        this.bb.setByteOutputChannel((ByteChunk.ByteOutputChannel)this);
        this.cb = new CharChunk(size);
        this.cb.setCharOutputChannel((CharChunk.CharOutputChannel)this);
        this.cb.setLimit(size);
    }

    private OutputBuffer(Response resp) {
        this(8192);
        this.setResponse(resp);
    }

    public void setResponse(Response resp) {
        this.resp = resp;
        this.req = resp.getRequest();
        this.cm = this.req.getContextManager();
    }

    public byte[] getBuffer() {
        return this.bb.getBuffer();
    }

    public int getByteOff() {
        return this.bb.getEnd();
    }

    public void setByteOff(int c) {
        this.bb.setOffset(c);
    }

    protected void log(String s) {
        System.out.println("OutputBuffer: " + s);
    }

    public void realWriteBytes(byte[] buf, int off, int cnt) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.resp == null) {
            return;
        }
        if (!this.resp.isBufferCommitted()) {
            this.resp.endHeaders();
        }
        if (cnt > 0) {
            BaseInterceptor[] reqI = this.req.getContainer().getInterceptors(9);
            int i = 0;
            while (i < reqI.length) {
                reqI[i].beforeCommit(this.req, this.resp);
                ++i;
            }
            this.resp.doWrite(buf, off, cnt);
        }
    }

    public void recycle() {
        this.state = 0;
        this.bytesWritten = 0;
        this.charsWritten = 0;
        this.cb.recycle();
        this.bb.recycle();
        this.closed = false;
        if (this.conv != null) {
            this.conv.recycle();
        }
        this.gotEnc = false;
        this.enc = null;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.state == 1) {
            this.cb.flushBuffer();
        }
        this.state = 2;
        this.writeBytes(b, off, len);
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return;
        }
        this.bb.append(b, off, len);
        this.bytesWritten += len;
        if (this.doFlush) {
            this.bb.flushBuffer();
        }
    }

    public void writeByte(int b) throws IOException {
        if (this.state == 1) {
            this.cb.flushBuffer();
        }
        this.state = 2;
        this.bb.append((byte)b);
        ++this.bytesWritten;
    }

    public void write(int c) throws IOException {
        this.state = 1;
        this.cb.append((char)c);
        ++this.charsWritten;
    }

    public void write(char[] c) throws IOException {
        this.write(c, 0, c.length);
    }

    public void write(char[] c, int off, int len) throws IOException {
        this.state = 1;
        this.cb.append(c, off, len);
        this.charsWritten += len;
    }

    public void write(StringBuffer sb) throws IOException {
        this.state = 1;
        int len = sb.length();
        this.charsWritten += len;
        this.cb.append(sb);
    }

    public void write(String s, int off, int len) throws IOException {
        this.state = 1;
        this.charsWritten += len;
        if (s == null) {
            s = "null";
        }
        this.cb.append(s, off, len);
    }

    public void write(String s) throws IOException {
        this.state = 1;
        if (s == null) {
            s = "null";
        }
        this.write(s, 0, s.length());
    }

    public void flushChars() throws IOException {
        this.cb.flushBuffer();
        this.state = 2;
    }

    public boolean flushCharsNeeded() {
        return this.state == 1;
    }

    public void close() throws IOException {
        this.flush();
        this.closed = true;
    }

    public synchronized void flush() throws IOException {
        this.doFlush = true;
        if (this.state == 1) {
            this.cb.flushBuffer();
            this.bb.flushBuffer();
            this.state = 2;
        } else if (this.state == 2) {
            this.bb.flushBuffer();
        } else if (this.state == 0) {
            this.realWriteBytes(null, 0, 0);
        }
        this.doFlush = false;
    }

    public void setEncoding(String s) {
        this.enc = s;
    }

    public void realWriteChars(char[] c, int off, int len) throws IOException {
        if (!this.gotEnc) {
            this.setConverter();
        }
        this.conv.convert(c, off, len);
        this.conv.flushBuffer();
    }

    protected void setConverter() {
        block7: {
            if (this.resp != null) {
                this.enc = this.resp.getCharacterEncoding();
            }
            this.gotEnc = true;
            if (this.enc == null) {
                this.enc = DEFAULT_ENCODING;
            }
            this.conv = (C2BConverter)this.encoders.get(this.enc);
            if (this.conv == null) {
                try {
                    this.conv = new C2BConverter(this.bb, this.enc);
                    this.encoders.put(this.enc, this.conv);
                }
                catch (IOException ex) {
                    this.conv = (C2BConverter)this.encoders.get(DEFAULT_ENCODING);
                    if (this.conv != null) break block7;
                    try {
                        this.conv = new C2BConverter(this.bb, DEFAULT_ENCODING);
                        this.encoders.put(DEFAULT_ENCODING, this.conv);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void flushBytes() throws IOException {
        this.bb.flushBuffer();
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public int getCharsWritten() {
        return this.charsWritten;
    }

    public boolean isNew() {
        return this.bytesWritten == 0 && this.charsWritten == 0;
    }

    public void setBufferSize(int size) {
        if (size > this.bb.getLimit()) {
            this.bb.setLimit(size);
        }
    }

    public void reset() {
        this.bb.recycle();
        this.bytesWritten = 0;
        this.cb.recycle();
        this.charsWritten = 0;
        this.gotEnc = false;
        this.enc = null;
    }

    public int getBufferSize() {
        return this.bb.getLimit();
    }
}

