##############################################################################
#
# Jarl - Chat CLI Interface Code
#
#   Perl code to handle showing the Jarl Chat GUI and interfacing with it.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

##############################################################################
#
# jarlChatIF_AddMessage - function to add the <message/> to the proper chat tab.
#
##############################################################################
sub jarlChatIF_AddMessage {
  my ($tag,$type,$timestamp,$encrypted,$currentID,@message) = @_;

  $Debug->Log1("jarlChatIF_AddMessage: tag($tag) type($type) timestamp($timestamp)");
  $Debug->Log1("jarlChatIF_AddMessage: encrypted($encrypted) currentID($currentID)");
  $Debug->Log1("jarlChatIF_AddMessage: message(\"".join("\",\"",@message)."\")");

  my $line = "";
  $TabBar->Print("__jarl__:tabbar",$tag,"timestamp","[$timestamp] ");
  $TabBar->Print("__jarl__:tabbar",$tag,"secure","* ") if ($encrypted == 1);

  my $priority = "low";

  while ($#message > -1) {
    my $pieceType = shift(@message);
    my $piece = shift(@message);
    $pieceType = $type if ($pieceType eq "normal");
    $TabBar->Print("__jarl__:tabbar",$tag,$pieceType,$piece);
    $priority = "medium" if ($pieceType eq "highlight");
  }

  $TabBar->Print("__jarl__:tabbar",$tag,"normal","\n");
  $TabBar->HighlightTab($tag,$priority);
}


##############################################################################
#
# jarlChatIF_HandleCommand - take the command line for this tab and parse
#                            it according to the chat rules.
#
##############################################################################
sub jarlChatIF_HandleCommand {
  my $tag = shift;
  my $command = shift;

  return if ($command eq "");

  if ($command =~ /^\/(l|leave)/) {
    &jarlChat_Leave($tag);
    $TabBar->DeleteTab($tag);
    return;
  }
  if ($command =~ /^\/__jarl__\:up$/) {
    &jarlChatIF_CurrentSay($tag,&jarlChat_HistoryUp($tag));
    return;
  }
  if ($command =~ /^\/__jarl__\:down$/) {
    &jarlChatIF_CurrentSay($tag,&jarlChat_HistoryDown($tag));
    return;
  }
  if ($command =~ /^\/__jarl__\:tab$/) {
    &jarlChat_CompleteNick($tag);
    $GUI{inputpos} = length($GUI{input});
    $GUI{inputright} = ($GUI{inputpos} - $GUI{maxX} + 1);
    $GUI{inputright} = 0 if ($GUI{inputright} < 0);
    &jarlMainIF_DrawPrompt();
    return;
  }
  return if ($command =~ /^\/__jarl__\:/);


  &jarlChatIF_CurrentSay($tag,$command);
  &jarlChat_SendSay($tag);
}


##############################################################################
#
# jarlChatIF_ChatExists - returns 1 if the GUI for the chat exists, 0 if not.
#
##############################################################################
sub jarlChatIF_ChatExists {
  my ($tag) = @_;
  return exists($chat{compose}->{$tag});
}


##############################################################################
#
# jarlChatIF_NewChat - function to do all GUI calls needed to create a new
#                      chat.
#
##############################################################################
sub jarlChatIF_NewChat {
  my ($tag) = @_;

  $chat{compose}->{$tag} = {};
  $TabBar->AddTab(tag=>$tag,
		  text=>"Chat - ".&jarlChat_ChatID($tag));
  &jarlChatIF_NewGUI($tag);
  $TabBar->RaiseTab($tag);
}


##############################################################################
#
# jarlChatIF_NewGUI - populates a new Chat window.
#
##############################################################################
sub jarlChatIF_NewGUI {
  my ($tag) = @_;
}


##############################################################################
#
# jarlChatIF_CurrentSay - if $value is defined then the Entry contents are set
#                         to $value, otherwise the contents of the Entry are
#                         returned.
#
##############################################################################
sub jarlChatIF_CurrentSay {
  my ($tag,$value) =  @_;
  $Debug->Log3("jarlChatIF_CurrentSay: tag($tag) value($value)");
  if (defined($value)) {
    $GUI{input} = (($value eq "") ? undef : $value);
    $GUI{inputpos} = length($value);

    &jarlMainIF_DrawPrompt();
  }
  return (defined($GUI{input}) ? $GUI{input} : "");
}


##############################################################################
#
# jarlChatIF_Secure - if $value is not defined then it returns 1 if the chat
#                     is secure, and 0 if not.  Otherwise, it sets the
#                     security of the chat to the $value (0 or 1 only).
#
##############################################################################
sub jarlChatIF_Secure {
  my ($tag,$value) = @_;

  &jarlMainIF_ChangeIcon($GUI{Jabber}->{Chat}->{$tag}->{Say}->{Secure},
			 (($value == 1) ? "SecureOn" : "SecureOff"),
			 (($value == 1) ? "SecureOff" : "SecureOn"),
			);
}


1;
