##############################################################################
#
# Jarl - Error CLI Interface Code
#
#   Perl code to handle showing the Jarl Error GUI and error messages.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

##############################################################################
#
# jarlErrorIF_Popup - creates the Error GUI and displays it.
#
##############################################################################
sub jarlErrorIF_Popup {
  my ($code,$string) = @_;

  if ($TabBar->CurrentTab() ne "status") {
    $TabBar->Print("__jarl__:tabbar:transient","ERROR: $code\n")
      unless ($code eq "");
    $TabBar->Print("__jarl__:tabbar:transient","ERROR: $string\n");
  }

  &jarlMainIF_StatusAdd("ERROR: $code") unless ($code eq "");
  &jarlMainIF_StatusAdd("ERROR: $string");

  &jarlMainIF_Prompt(prompt=>"Press Enter to continue",
		     default=>"__jarl__:prompt:nodefault");
}


1;
