##############################################################################
#
# Jarl - GroupChat CLI Interface Code
#
#   Perl code to handle showing the Jarl GroupChat GUI and interfacing with
# it.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

##############################################################################
#
# jarlGroupChatIF_GUI - window to ask which groupchat the user would like to
#                    join based on server, channel, and nick.
#
##############################################################################
sub jarlGroupChatIF_GUI {

  $TabBar->Print("__jarl__:tabbar:transient","Groupchat Servers:\n");
  my $count = 0;
  foreach my $jid (sort {$a cmp $b} keys(%groupchatJIDs)) {
    $TabBar->Print("__jarl__:tabbar:transient","  $count) $jid\n");
    $count++;
  }
  $TabBar->Print("__jarl__:tabbar:transient","  e) Enter JID\n");
  my $server = &jarlMainIF_Prompt(prompt=>"Server",
				  transient=>1,
				  default=>(($count == 0) ? "e" : 0),
				  options=>[0..($count-1),"e"]);
  if ($server eq "e") {
    $server = &jarlMainIF_Prompt(prompt=>"Server",
				 transient=>1);
  } else {
    $server = (sort {$a cmp $b} keys(%groupchatJIDs))[$server];
  }
  my $channel = &jarlMainIF_Prompt(prompt=>"Channel",
				   transient=>1);
  my $nick = &jarlMainIF_Prompt(prompt=>"Nick",
				transient=>1);

  &jarlGroupChat_Join($channel."\@".$server,$nick);
}


##############################################################################
#
# jarlGroupChatIF_AddMessage - takes a <message/> and adds it to the proper
#                           channel based on the from JID.
#
##############################################################################
sub jarlGroupChatIF_AddMessage {
  my ($tag,$type,$timestamp,$history,$currentID,@message) = @_;

  $Debug->Log1("jarlGroupChatIF_AddMessage: tag($tag) type($type) timestamp($timestamp)");
  $Debug->Log1("jarlGroupChatIF_AddMessage: history($history) currentID($currentID)");
  $Debug->Log1("jarlGroupChatIF_AddMessage: message(\"".join("\",\"",@message)."\")");

  my $line = "";
  $TabBar->Print("__jarl__:tabbar",$tag,"timestamp","[$timestamp]");
  $TabBar->Print("__jarl__:tabbar",$tag,"history","@") if ($history == 1);
  $TabBar->Print("__jarl__:tabbar",$tag,$type," ");

  my $priority = "low";

  while ($#message > -1) {
    my $pieceType = shift(@message);
    my $piece = shift(@message);
    $pieceType = $type if ($pieceType eq "normal");

    $TabBar->Print("__jarl__:tabbar",$tag,$pieceType,$piece);
    $priority = "medium" if ($pieceType eq "highlight");
  }
  $TabBar->Print("__jarl__:tabbar",$tag,$type,"\n");
  $TabBar->HighlightTab($tag,$priority);
}


##############################################################################
#
# jarlGroupChatIF_ShowTopic - take a parsed topic and display it.
#
##############################################################################
sub jarlGroupChatIF_ShowTopic {
  my ($tag,@topic) = @_;

  $TabBar->Print("__jarl__:tabbar",$tag,"normal","*"x79,"\n");
  $TabBar->Print("__jarl__:tabbar",$tag,"normal","Topic: ");
  while ($#topic > -1) {
    my $pieceType = shift(@topic);
    my $piece = shift(@topic);

    $TabBar->Print("__jarl__:tabbar",$tag,$pieceType,$piece);
  }
  $TabBar->Print("__jarl__:tabbar",$tag,"normal","\n");
  $TabBar->Print("__jarl__:tabbar",$tag,"normal","*"x79,"\n");
}


##############################################################################
#
# jarlGroupChatIF_HandleCommand - take the command line for this tab and parse
#                                 it according to the groupchat rules.
#
##############################################################################
sub jarlGroupChatIF_HandleCommand {
  my $tag = shift;
  my $command = shift;

  return if ($command eq "");

  if ($command =~ /^\/(r|roster)/) {
    $groupchatRosters{$tag}->DrawMode(1);
    $groupchatRosters{$tag}->Draw();
    $groupchatRosters{$tag}->DrawMode(0);
    return;
  }
  if ($command =~ /^\/(l|leave)/) {
    &jarlGroupChat_Leave($tag);
    $TabBar->DeleteTab($tag);
    return;
  }
  if ($command =~ /^\/__jarl__\:up$/) {
    &jarlGroupChatIF_CurrentSay($tag,&jarlGroupChat_HistoryUp($tag));
    return;
  }
  if ($command =~ /^\/__jarl__\:down$/) {
    &jarlGroupChatIF_CurrentSay($tag,&jarlGroupChat_HistoryDown($tag));
    return;
  }
  if ($command =~ /^\/__jarl__\:tab$/) {
    &jarlGroupChat_CompleteNick($tag);
    if (&jarlGroupChatIF_CurrentSay($tag) =~ /^\/(c|chat)/) {
      my $say = &jarlGroupChatIF_CurrentSay($tag);
      $say =~ s/ $//;
      &jarlGroupChatIF_CurrentSay($tag,$say);
    }
    $GUI{inputpos} = length($GUI{input});
    $GUI{inputright} = ($GUI{inputpos} - $GUI{maxX} + 1);
    $GUI{inputright} = 0 if ($GUI{inputright} < 0);
    &jarlMainIF_DrawPrompt();
    return;
  }
  return if ($command =~ /^\/__jarl__\:/);

  &jarlGroupChatIF_CurrentSay($tag,$command);
  &jarlGroupChat_SendSay($tag);
}


##############################################################################
#
# jarlGroupChatIF_GroupChatExists - returns 1 if the GUI for the groupchat 
#                                   exists, 0 if not.
#
##############################################################################
sub jarlGroupChatIF_GroupChatExists {
  my ($tag) = @_;
  return exists($groupchat{tags}->{$tag});
}


##############################################################################
#
# jarlGroupChatIF_NewGroupChat - function to do all GUI calls needed to create #                                a new groupchat.
#
##############################################################################
sub jarlGroupChatIF_NewGroupChat {
  my ($tag) = @_;

  $groupchat{tags}->{$tag}->{say} = "";
  $TabBar->AddTab(tag=>$tag,
		  text=>"GroupChat - ".&jarlGroupChat_ChannelName($tag));
  &jarlGroupChatIF_NewGUI($tag);
  $TabBar->RaiseTab($tag);
}


##############################################################################
#
# jarlGroupChatIF_NewGUI - populates the new tab with a groupchat GUI.
#
##############################################################################
sub jarlGroupChatIF_NewGUI {
  my ($tag) = @_;

  $groupchatRosters{$tag} = new CLI::Roster(-updatemode=>"presence");
  $groupchatRosters{$tag}->DrawMode(0);
}


##############################################################################
#
# jarlGroupChatIF_CurrentSay - if $value is defined then the Entry contents
#                              are set to $value, otherwise the contents of
#                              the Entry are returned.
#
##############################################################################
sub jarlGroupChatIF_CurrentSay {
  my ($tag,$value) =  @_;
  $Debug->Log3("jarlGroupChatIF_CurrentSay: tag($tag) value($value)");
  if (defined($value)) {
    $GUI{input} = (($value eq "") ? undef : $value);
    $GUI{inputpos} = length($value);

    &jarlMainIF_DrawPrompt();
  }
  return (defined($GUI{input}) ? $GUI{input} : "");
}


1;
