##############################################################################
#
# Jarl - Search Tk Interface Code
#
#   Perl code to handle showing the Jarl Search GUI and interfacing with the
# search results.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################


##############################################################################
#
# jarlSearchIF_GUI - creates the Search GUI.
#
##############################################################################
sub jarlSearchIF_GUI {

  if (Exists($GUI{Search}->{window}) && $GUI{Search}->{window}->ismapped()) {
    $GUI{Search}->{window}->raise();
    return;
  }

  $GUI{Search}->{window} = $GUI{top}->Toplevel();
  $GUI{Search}->{window}->title("Search");
  $GUI{Search}->{window}->geometry("500x400");

  $GUI{Search}->{top} =
    $GUI{Search}->{window}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -padx=>5,
		   -pady=>5,
		   -expand=>1);
  
  $GUI{Search}->{JIDPullDown}->{top} =
    $GUI{Search}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"x",
		   -pady=>5);


  $GUI{Search}->{JIDPullDown}->{Label} =
    $GUI{Search}->{JIDPullDown}->{top}->
      Label(-text=>"Server:",
	    -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	    -width=>$GUI{width}->{jarl}->{config}->{label},
	    -anchor=>"e"
	   )->pack(-side=>'left',
		   -anchor=>'e');

  $GUI{Search}->{JIDPullDown}->{Option} =
    $GUI{Search}->{JIDPullDown}->{top}->
      Optionmenu(-options=>["Please choose an Agent to search with...", sort {$a cmp $b} keys(%searchJIDs)],
		 -variable=>\$GUI{Search}->{vars}->{to},
		 -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
		 -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
		 -font=>$GUI{fonts}->{normal},
		 -command=>sub{
		   return if ($GUI{Search}->{vars}->{to} eq "Please choose an Agent to search with...");

		   &jarlSearchIF_RemoveInterface($GUI{Search});

		   my %fields = $jabber{client}->SearchRequest(to=>$GUI{Search}->{vars}->{to});
		   if (!defined(%fields) || (scalar(keys(%fields)) == 0)) {
		     print STDERR $jabber{client}->GetErrorCode(),"\n";
		     return;
		   }

		   $GUI{Search}->{Results}->{MulColListbox}->
		     AddColumn(-header=>"JID",
			       -key=>"jid",
			       -width=>40);

		   my $field;
		   my $width = 180;
		   foreach $field (sort {$a cmp $b} keys(%fields)) {
		     next if ($field eq "instructions");
		     next if ($field eq "key");

		     &jarlMainIF_AddField(widget=>$GUI{Search},
					  type=>"entry",
					  var=>$field,
					  value=>$fields{$field});

		     $GUI{Search}->{Results}->{MulColListbox}->
		       AddColumn(-header=>ucfirst($field),
				 -key=>$field,
				 -width=>$width);
		     $width -= 30;
		   }
		 }
		)->pack(-side=>'left',
			-anchor=>'w');


  $GUI{Search}->{Buttons}->{top} = 
    $GUI{Search}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"bottom",
		   -fill=>"x");

  $GUI{Search}->{Buttons}->{Close} =
    $GUI{Search}->{Buttons}->{top}->
      Button(-text=>"Close",
	     -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlSearchIF_CloseCB();
	     }
	    )->pack(-side=>"right",
		    -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		    -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});  
  $GUI{Search}->{Buttons}->{Search} =
    $GUI{Search}->{Buttons}->{top}->
      Button(-text=>"Search",
	     -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       my %fields = $jabber{client}->SearchRequest(to=>$GUI{Search}->{vars}->{to});
	       if (!defined(%fields) || (scalar(keys(%fields)) == 0)) {
		 print STDERR $jabber{client}->GetErrorCode(),"\n";
		 return;
	       }

	       delete($fields{instructions});
	       
	       my $field;
	       foreach $field (keys(%{$GUI{Search}->{vars}})) {
		 $fields{$field} = $GUI{Search}->{vars}->{$field};
	       }
		 
	       %results = ();
	       $resultsWidget = $GUI{Search}->{Results};
	       
	       $jabber{client}->SearchSend(%fields);
	     }
	    )->pack(-side=>"right",
		    -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		    -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});
  $GUI{Search}->{Buttons}->{Add} =
    $GUI{Search}->{Buttons}->{top}->
      Button(-text=>"Add To Roster",
	     -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       return if ($GUI{Search}->{Results}->{MulColListbox}->curselection eq "");
	       my $newID = $GUI{Search}->{Results}->{MulColListbox}->get("jid",$GUI{Search}->{Results}->{MulColListbox}->curselection);
	       $newID =~ s/\s*$//;
	       my $newJID = new Net::Jabber::JID($newID);
	       &jarlRosterIF_EditItemGUI($newJID);
	     }
	    )->pack(-side=>"right",
		    -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		    -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});

  $GUI{Search}->{Results}->{top} = 
    $GUI{Search}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"bottom",
		   -fill=>"both",
		   -expand=>1,
		   -pady=>5,
		   -padx=>5);

  $GUI{Search}->{Results}->{MulColListbox} =
    $GUI{Search}->{Results}->{top}->
      MulColListbox(-headerbackground=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
		    -headerforeground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
		    -headerborderwidth=>1,
		    -background=>$GUI{color}->{bg}->{light},
		    -foreground=>$GUI{color}->{fg}->{dark},
		    -relief=>"sunken",
		    -borderwidth=>2,
		    -height=>0,
		    -width=>0,
		    -sortby=>"last",
		    -sortorder=>"descending",
		    -selectmode=>"multiple",
		    -font=>$GUI{fonts}->{normal},
		    -selectbackground=>$GUI{color}->{bg}->{list},
		    -selectforeground=>$GUI{color}->{fg}->{list},
		    -scrollbarborderwidth=>1,
		    -scrollbarrelief=>"flat",
		   )->pack(-side=>"top",
			   -fill=>"both",
			   -expand=>1,
			   -padx=>5,
			   -pady=>5);
}


sub jarlSearchIF_CloseCB {
  $GUI{Search}->{window}->destroy;
  delete($GUI{Search});
}


sub jarlSearchIF_RemoveInterface {
  my ($widget) = @_;

  $widget->{Results}->{MulColListbox}->DeleteColumn("jid");

  my $field;
  foreach $field (keys(%{$widget->{Fields}})) {
    $widget->{Results}->{MulColListbox}->DeleteColumn($field);
    $widget->{Fields}->{$field}->{top}->destroy();
    delete($widget->{Fields}->{$field});
  }
}


sub jarlSearchIF_ListResults {
  my ($widget) = @_;

  return unless Exists($widget->{MulColListbox});

  $widget->{MulColListbox}->clear();

  my $jid;
  my %entry;
  $widget->{MulColListbox}->draw(0);
  foreach $jid (sort {$a cmp $b} keys(%results)) {
    $entry{jid} = $jid;
    my $field;
    foreach $field (keys(%{$results{$jid}})) {
      $entry{$field} = $results{$jid}->{$field};
    }
    $widget->{MulColListbox}->insert(\%entry);
  }
  $widget->{MulColListbox}->draw(1);
}


1;
