##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

package Jarl::Profile::Connection;

use strict;
use vars qw($VERSION);

$VERSION = "0.1";

sub new {
  my $proto = shift;
  my $self = { };

  bless($self, $proto);

  $self->{CONNECTION} = {};

  return $self;
}


sub Name {
  my $self = shift;
  my ($name) = @_;
  $self->{CONNECTION}->{name} = $name if defined($name);
  return $self->{CONNECTION}->{name};
}

sub Type {
  my $self = shift;
  my ($type) = @_;
  $self->{CONNECTION}->{type} = $type if defined($type);
  return $self->{CONNECTION}->{type};
}

sub Port {
  my $self = shift;
  my ($port) = @_;
  $self->{CONNECTION}->{port} = $port if defined($port);
  return $self->{CONNECTION}->{port};
}

sub XML {
  my $self = shift;
  my $string;
  $string .= "<connection";
  $string .= " name='".&XML::Stream::EscapeXML($self->{CONNECTION}->{name})."'";
  $string .= " type='".&XML::Stream::EscapeXML($self->{CONNECTION}->{type})."'";
  $string .= " port='".&XML::Stream::EscapeXML($self->{CONNECTION}->{port})."'";
  $string .= "/>";
  return $string;
}

1;
