##############################################################################
#
# Jarl - Agent Tk Interface Code
#
#   Perl code to handle showing the Jarl Agent GUI and interfacing with the
# agents.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################


##############################################################################
#
# jarlAgentIF_GUI - creates an Agent GUI.
#
##############################################################################
sub jarlAgentIF_GUI {
  my ($agentJID,%agent) = @_;

  if (Exists($GUI{Agent}->{$agentJID}->{window}) && $GUI{Agent}->{$agentJID}->{window}->ismapped()) {
    $GUI{Agent}->{$agentJID}->{window}->raise();
    return;
  }

  $GUI{Agent}->{vars}->{status} = "Running";

  $GUI{Agent}->{$agentJID}->{window} = $GUI{top}->Toplevel();
  $GUI{Agent}->{$agentJID}->{window}->title("Agent: $agent{name}");

  $GUI{Agent}->{$agentJID}->{top} =
    $GUI{Agent}->{$agentJID}->{window}->
      Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);

  $GUI{Agent}->{$agentJID}->{TabBar} =
    $GUI{Agent}->{$agentJID}->{top}->
      TabBar(-background=>$GUI{color}->{jarl}->{config}->{bg}->{dark},
	     -tabthickness=>$GUI{width}->{jarl}->{config}->{tabs}->{thickness},
	     -tabfill=>$GUI{color}->{jarl}->{config}->{bg}->{light},
	     -tabbackground=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
	     -tabforeground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
	     -tabfont=>$GUI{fonts}->{normal},
	     -tabpadx=>$GUI{width}->{jarl}->{config}->{pad},
	     -tabpady=>$GUI{height}->{jarl}->{config}->{pad},
	    )->pack(-side=>'top',
		    -fill=>'both',
		    -expand=>1);

  #---------------------------------------------------------------------------
  # General Agent information
  #---------------------------------------------------------------------------
  $GUI{Agent}->{$agentJID}->{General}->{top} =
    $GUI{Agent}->{$agentJID}->{TabBar}->AddTab(-tag=>"general",
					       -text=>"General");

  $GUI{Agent}->{$agentJID}->{General}->{Name}->{top} =
    $GUI{Agent}->{$agentJID}->{General}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);
  $GUI{Agent}->{$agentJID}->{General}->{Name}->{Label} =
    $GUI{Agent}->{$agentJID}->{General}->{Name}->{top}->
      Label(-text=>"Name:",
	    -width=>$GUI{width}->{jarl}->{rosteritem}->{label},
	    -anchor=>"ne",
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal}
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -anchor=>"e");
  $GUI{Agent}->{$agentJID}->{General}->{Name}->{Label} =
    $GUI{Agent}->{$agentJID}->{General}->{Name}->{top}->
      Label(-textvariable=>\$agent{name},
	    -wraplength=>250,
	    -justify=>"left",
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');

  $GUI{Agent}->{$agentJID}->{General}->{Description}->{top} =
    $GUI{Agent}->{$agentJID}->{General}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);
  $GUI{Agent}->{$agentJID}->{General}->{Description}->{Label} =
    $GUI{Agent}->{$agentJID}->{General}->{Description}->{top}->
      Label(-text=>"Description:",
	    -width=>$GUI{width}->{jarl}->{rosteritem}->{label},
	    -anchor=>"ne",
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal}
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -anchor=>"e");
  $GUI{Agent}->{$agentJID}->{General}->{Description}->{Label} =
    $GUI{Agent}->{$agentJID}->{General}->{Description}->{top}->
      Label(-textvariable=>\$agent{description},
	    -wraplength=>250,
	    -justify=>"left",
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');

  $GUI{Agent}->{$agentJID}->{General}->{Status}->{top} =
    $GUI{Agent}->{$agentJID}->{General}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);
  $GUI{Agent}->{$agentJID}->{General}->{Status}->{Label} =
    $GUI{Agent}->{$agentJID}->{General}->{Status}->{top}->
      Label(-text=>"Status:",
	    -width=>$GUI{width}->{jarl}->{rosteritem}->{label},
	    -anchor=>"ne",
	    -font=>$GUI{fonts}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal}
	   )->pack(-side=>"left",
		   -fill=>"y",
		   -anchor=>"e");
  $GUI{Agent}->{$agentJID}->{General}->{Status}->{Label} =
    $GUI{Agent}->{$agentJID}->{General}->{Status}->{top}->
      Label(-textvariable=>\$GUI{Agent}->{vars}->{status},
	    -wraplength=>250,
	    -justify=>"left",
	    -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	    -font=>$GUI{fonts}->{normal},
	   )->pack(-side=>'left',
		   -anchor=>'w');

  $GUI{Agent}->{$agentJID}->{General}->{Buttons}->{top} =
    $GUI{Agent}->{$agentJID}->{General}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	   )->pack(-side=>"bottom",
		   -fill=>"both",
		   -expand=>1);
  $GUI{Agent}->{$agentJID}->{General}->{Buttons}->{Cancel} =
    $GUI{Agent}->{$agentJID}->{General}->{Buttons}->{top}->
      Button(-text=>"Close Agent",
	     -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	     -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	     -disabledforeground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{light},
	     -font=>$GUI{fonts}->{normal},
	     -command=>sub{
	       &jarlAgentIF_CloseCB($agentJID);
	     }
	    )->pack(-side=>"right",
		    -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		    -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});


  #---------------------------------------------------------------------------
  # Register fields
  #---------------------------------------------------------------------------
  if (($agent{register} == 1) && ($GUI{Agent}->{vars}->{status} eq "Running")) {

    my %register = $jabber{client}->RegisterRequest(to=>$agentJID);

    if (!defined(%register)) {

      $GUI{Agent}->{vars}->{status} = "Not running\n(".$jabber{client}->GetErrorCode().")";

    } else {

      $GUI{Agent}->{$agentJID}->{Register}->{top} =
	$GUI{Agent}->{$agentJID}->{TabBar}->AddTab(-tag=>"register",
						   -text=>"Register");

      $GUI{Agent}->{$agentJID}->{Register}->{top}->
	bind("<Visibility>",
	     sub {
	       $GUI{Agent}->{$agentJID}->{Register}->{top}->
		 bind("<Visibility>",
		      sub {});

	       if (exists($register{form})) {
		 &jarlMainIF_BuildForm(widget=>$GUI{Agent}->{$agentJID}->{Register},
				       instructions=>$register{instructions},
				       form=>$register{form});
	       } else {
		 if (exists($register{fields}->{instructions})) {
		   while($register{fields}->{instructions} =~ s/\n/\ /) { }
		   while($register{fields}->{instructions} =~ s/\ \ /\ /) { }
		   while($register{fields}->{instructions} =~ s/^\ //) { }
		   $GUI{Agent}->{$agentJID}->{Register}->{instructions}->{top} =
		     $GUI{Agent}->{$agentJID}->{Register}->{top}->
		       Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
			     -foreground=>$GUI{color}->{window}->{fg}->{dark},
			    )->pack(-side=>'top',
				    -fill=>'both',
				    -expand=>1);
		   $GUI{Agent}->{$agentJID}->{Register}->{instructions}->{Label} =
		     $GUI{Agent}->{$agentJID}->{Register}->{instructions}->{top}->
		       Label(-text=>"Instructions:",
			     -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
			     -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
			     -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
			     -font=>$GUI{fonts}->{normal},
			     -anchor=>'ne'
			    )->pack(-side=>'left',
				    -fill=>'y',
				    -anchor=>'e');
		   $GUI{Agent}->{$agentJID}->{Register}->{instructions}->{Data} =
		     $GUI{Agent}->{$agentJID}->{Register}->{instructions}->{top}->
		       Label(-text=>$register{fields}->{instructions},
			     -wraplength=>250,
			     -justify=>"left",
			     -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
			     -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
			     -font=>$GUI{fonts}->{normal},
			     -anchor=>'w'
			    )->pack(-side=>'left',
				    -anchor=>'w');
		 }

		 my $field;
		 foreach $field (sort {$a cmp $b} keys(%{$register{fields}})) {
		   next if ($field eq "instructions");
		   next if ($field eq "key");
		   if ($field eq "password") {
		     &jarlMainIF_AddField(widget=>$GUI{Agent}->{$agentJID}->{Register},
					  type=>"password",
					  var=>$field,
					  value=>$register{fields}->{$field});
		   } else {
		     &jarlMainIF_AddField(widget=>$GUI{Agent}->{$agentJID}->{Register},
					  type=>"entry",
					  var=>$field,
					  value=>$register{fields}->{$field});
		   }
		 }
	       }

	       $GUI{Agent}->{$agentJID}->{Register}->{Buttons}->{top} =
		 $GUI{Agent}->{$agentJID}->{Register}->{top}->
		   Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
			 -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
			)->pack(-side=>"bottom",
				-fill=>"both",
				-expand=>1);
	       $GUI{Agent}->{$agentJID}->{Register}->{Buttons}->{Register} =
		 $GUI{Agent}->{$agentJID}->{Register}->{Buttons}->{top}->
		   Button(-text=>"Register",
			  -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
			  -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
			  -disabledforeground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{light},
			  -font=>$GUI{fonts}->{normal},
			  -command=>sub{

			    my %register = $jabber{client}->RegisterRequest(to=>$agentJID);
			    delete($register{fields}->{instructions});

			    my $field;
			    foreach $field (keys(%{$GUI{Agent}->{$agentJID}->{Register}->{vars}})) {
			      $register{fields}->{$field} = $GUI{Agent}->{$agentJID}->{Register}->{vars}->{$field};
			    }

			    my @result = $jabber{client}->RegisterSend(to=>$agentJID,
								       %{$register{fields}});

			    if ($result[0] ne "ok") {
			      print "ERROR: Failed registration.\n";
			      print "       ($result[1])\n";
			      return;
			    }
			  }
			 )->pack(-side=>"right",
				 -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
				 -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});
	     });
    }
  }


  #---------------------------------------------------------------------------
  # Search fields
  #---------------------------------------------------------------------------
  if (($agent{search} == 1) && ($GUI{Agent}->{vars}->{status} eq "Running")) {

    my %fields = $jabber{client}->SearchRequest(to=>$agentJID);

    if (!defined(%fields)) {

      $GUI{Agent}->{vars}->{status} = "Not running\n(".$jabber{client}->GetErrorCode().")";

    } else {
      $GUI{Agent}->{$agentJID}->{Search}->{top} =
	$GUI{Agent}->{$agentJID}->{TabBar}->AddTab(-tag=>"search",
						   -text=>"Search");

      $GUI{Agent}->{$agentJID}->{Search}->{top}->
	bind("<Visibility>",
	     sub {
	       $GUI{Agent}->{$agentJID}->{Search}->{top}->
		 bind("<Visibility>",
		      sub {});

	       if (!defined(%fields) || (scalar(keys(%fields)) == 0)) {
		 print STDERR $jabber{client}->GetErrorCode(),"\n";
		 return;
	       }

	       if (exists($fields{instructions})) {
		 while($fields{instructions} =~ s/\n/\ /) { }
		 while($fields{instructions} =~ s/\ \ /\ /) { }
		 while($fields{instructions} =~ s/^\ //) { }
		 $GUI{Agent}->{$agentJID}->{Search}->{instructions}->{top} =
		   $GUI{Agent}->{$agentJID}->{Search}->{top}->
		     Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
			   -foreground=>$GUI{color}->{window}->{fg}->{dark},
			  )->pack(-side=>'top',
				  -fill=>'x');
		 $GUI{Agent}->{$agentJID}->{Search}->{instructions}->{Label} =
		   $GUI{Agent}->{$agentJID}->{Search}->{instructions}->{top}->
		     Label(-text=>"Instructions:",
			   -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
			   -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
			   -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
			   -font=>$GUI{fonts}->{normal},
			   -anchor=>'ne'
			  )->pack(-side=>'left',
				  -fill=>'y',
				  -anchor=>'e');
		 $GUI{Agent}->{$agentJID}->{Search}->{instructions}->{Data} =
		   $GUI{Agent}->{$agentJID}->{Search}->{instructions}->{top}->
		     Label(-text=>$fields{instructions},
			   -wraplength=>250,
			   -justify=>"left",
			   -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
			   -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
			   -font=>$GUI{fonts}->{normal},
			   -anchor=>'w'
			  )->pack(-side=>'left',
				  -anchor=>'w');

	       }

	       $GUI{Agent}->{$agentJID}->{Search}->{Buttons}->{top} =
		 $GUI{Agent}->{$agentJID}->{Search}->{top}->
		   Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
			 -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
			)->pack(-side=>"bottom",
				-fill=>"x");

	       $GUI{Agent}->{$agentJID}->{Search}->{Results}->{top} =
		 $GUI{Agent}->{$agentJID}->{Search}->{top}->
		   Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
			 -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
			)->pack(-side=>"bottom",
				-fill=>"both",
				-expand=>1,
				-pady=>5);


	       $GUI{Agent}->{$agentJID}->{Search}->{Results}->{MulColListbox} =
		 $GUI{Agent}->{$agentJID}->{Search}->{Results}->{top}->
		   MulColListbox(-headerbackground=>$GUI{color}->{bg}->{normal},
				 -headerforeground=>$GUI{color}->{fg}->{dark},
				 -headerborderwidth=>1,
				 -background=>$GUI{color}->{bg}->{light},
				 -foreground=>$GUI{color}->{fg}->{dark},
				 -relief=>"sunken",
				 -borderwidth=>2,
				 -height=>0,
				 -width=>0,
				 -sortby=>"last",
				 -sortorder=>"descending",
				 -font=>$GUI{fonts}->{normal},
				 -selectbackground=>$GUI{color}->{bg}->{list},
				 -selectforeground=>$GUI{color}->{fg}->{list},
				 -scrollbarborderwidth=>1,
				 -scrollbarrelief=>"flat",
				)->pack(-side=>"top",
					-fill=>"both",
					-expand=>1,
					-padx=>5,
					-pady=>5);

	       $GUI{Agent}->{$agentJID}->{Search}->{Results}->{MulColListbox}->
		 AddColumn(-header=>"JID",
			   -key=>"jid",
			   -width=>30);

	       my $field;
	       foreach $field (sort {$a cmp $b} keys(%fields)) {
		 next if ($field eq "instructions");
		 next if ($field eq "key");

	       &jarlMainIF_AddField(widget=>$GUI{Agent}->{$agentJID}->{Search},
				    type=>"entry",
				    var=>$field,
				    value=>$fields{$field});
		 $GUI{Agent}->{$agentJID}->{Search}->{Results}->{MulColListbox}->
		   AddColumn(-header=>ucfirst($field),
			     -key=>$field,
			     -width=>30);
	       }


	       $GUI{Agent}->{$agentJID}->{Search}->{Buttons}->{Search} =
		 $GUI{Agent}->{$agentJID}->{Search}->{Buttons}->{top}->
		   Button(-text=>"Search",
			  -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
			  -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
			  -disabledforeground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{light},
			  -font=>$GUI{fonts}->{normal},
			  -command=>sub{

			    my %fields = $jabber{client}->SearchRequest(to=>$agentJID);
			    if (!defined(%fields) || (scalar(keys(%fields)) == 0)) {
			      print STDERR $jabber{client}->GetErrorCode(),"\n";
			      return;
			  }
			    delete($fields{instructions});

			    my $field;
			    foreach $field (keys(%{$GUI{Agent}->{$agentJID}->{Search}->{vars}})) {
			      $fields{$field} = $GUI{Agent}->{$agentJID}->{Search}->{vars}->{$field};
			    }

			    %results = ();
			    $resultsWidget = $GUI{Agent}->{$agentJID}->{Search}->{Results};

			    $jabber{client}->SearchSend(to=>$agentJID,
							%fields);

			  }
			 )->pack(-side=>"right",
				 -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
				 -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});

	       $GUI{Agent}->{$agentJID}->{Search}->{Buttons}->{Add} =
		 $GUI{Agent}->{$agentJID}->{Search}->{Buttons}->{top}->
		   Button(-text=>"Add To Roster",
			  -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
			  -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
			  -disabledforeground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{light},
			  -font=>$GUI{fonts}->{normal},
			  -command=>sub{
			    return if ($GUI{Agent}->{$agentJID}->{Search}->{Results}->{MulColListbox}->curselection eq "");
			    my $newID = $GUI{Agent}->{$agentJID}->{Search}->{Results}->{MulColListbox}->get("jid",$GUI{Agent}->{$agentJID}->{Search}->{Results}->{MulColListbox}->curselection);
			    $newID =~ s/\s*$//;
			    my $newJID = new Net::Jabber::JID($newID);
			    &jarlRosterIF_EditItemGUI($newJID);
			  }
			 )->pack(-side=>"right",
				 -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
				 -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});
	     });
    }
  }


  #---------------------------------------------------------------------------
  # GroupChat fields
  #---------------------------------------------------------------------------
  if (($agent{groupchat} == 1) && ($GUI{Agent}->{vars}->{status} eq "Running")) {

    $GUI{Agent}->{$agentJID}->{GroupChat}->{top} =
      $GUI{Agent}->{$agentJID}->{TabBar}->AddTab(-tag=>"groupchat",
						 -text=>"Group Chat");

    $GUI{Agent}->{$agentJID}->{GroupChat}->{instructions}->{top} =
      $GUI{Agent}->{$agentJID}->{GroupChat}->{top}->
	Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	      -foreground=>$GUI{color}->{window}->{fg}->{dark},
	     )->pack(-side=>'top',
		     -fill=>'both',
		     -expand=>1);
    $GUI{Agent}->{$agentJID}->{GroupChat}->{instructions}->{Label} =
      $GUI{Agent}->{$agentJID}->{GroupChat}->{instructions}->{top}->
	Label(-text=>"Instructions:",
	      -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
	      -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
	      -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
	      -font=>$GUI{fonts}->{normal},
	      -anchor=>'ne'
	     )->pack(-side=>'left',
		     -fill=>'y',
		     -anchor=>'e');
    $GUI{Agent}->{$agentJID}->{GroupChat}->{instructions}->{Data} =
      $GUI{Agent}->{$agentJID}->{GroupChat}->{instructions}->{top}->
	Label(-text=>"Specify a channel and nick then hit the Join button to join the groupchat channel.",
	      -wraplength=>250,
	      -justify=>"left",
	      -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
	      -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
	      -font=>$GUI{fonts}->{normal},
	      -anchor=>'w'
	     )->pack(-side=>'left',
		     -anchor=>'w');

    &jarlMainIF_AddField(widget=>$GUI{Agent}->{$agentJID}->{GroupChat},
			 type=>"entry",
			 var=>"channel");
    &jarlMainIF_AddField(widget=>$GUI{Agent}->{$agentJID}->{GroupChat},
			 type=>"entry",
			 var=>"nick");

    $GUI{Agent}->{$agentJID}->{GroupChat}->{Buttons}->{top} =
      $GUI{Agent}->{$agentJID}->{GroupChat}->{top}->
	Frame(-background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	      -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	     )->pack(-side=>"bottom",
		     -fill=>"both",
		     -expand=>1);
    $GUI{Agent}->{$agentJID}->{GroupChat}->{Buttons}->{Join} =
      $GUI{Agent}->{$agentJID}->{GroupChat}->{Buttons}->{top}->
	Button(-text=>"Join",
	       -background=>$GUI{color}->{jarl}->{rosteritem}->{bg}->{normal},
	       -foreground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{dark},
	       -disabledforeground=>$GUI{color}->{jarl}->{rosteritem}->{fg}->{light},
	       -font=>$GUI{fonts}->{normal},
	       -command=>sub{
		 &jarlGroupChat_Join($GUI{Agent}->{$agentJID}->{GroupChat}->{vars}->{channel}."\@".$agentJID,$GUI{Agent}->{$agentJID}->{GroupChat}->{vars}->{nick});
	       }
	      )->pack(-side=>"right",
		      -pady=>$GUI{height}->{jarl}->{rosteritem}->{pad},
		      -padx=>$GUI{width}->{jarl}->{rosteritem}->{pad});
  }


  #---------------------------------------------------------------------------
  # Sub-Agents
  #---------------------------------------------------------------------------
  if (($agent{agents} == 1) && ($GUI{Agent}->{vars}->{status} eq "Running")) {

    my %subAgents = $jabber{client}->AgentsGet(to=>$agentJID);

    if (!defined(%subAgents)) {

      $GUI{Agent}->{vars}->{status} = "Not running\n(".$jabber{client}->GetErrorCode().")";

    } else {

      $GUI{Agent}->{$agentJID}->{Agents}->{top} =
	$GUI{Agent}->{$agentJID}->{TabBar}->AddTab(-tag=>"agents",
						   -text=>"Agents");

      $GUI{Agent}->{$agentJID}->{Agents}->{top}->
	bind("<Visibility>",
	     sub {
	       $GUI{Agent}->{$agentJID}->{Agents}->{top}->
		 bind("<Visibility>",
		      sub {});

	       $GUI{Agent}->{$agentJID}->{Agents}->{instructions}->{top} =
		 $GUI{Agent}->{$agentJID}->{Agents}->{top}->
		   Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
			 -foreground=>$GUI{color}->{window}->{fg}->{dark},
			)->pack(-side=>'top',
				-fill=>'both',
				-expand=>1);
	       $GUI{Agent}->{$agentJID}->{Agents}->{instructions}->{Label} =
		 $GUI{Agent}->{$agentJID}->{Agents}->{instructions}->{top}->
		   Label(-text=>"Instructions:",
			 -width=>$GUI{width}->{jarl}->{profileeditor}->{label},
			 -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
			 -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
			 -font=>$GUI{fonts}->{normal},
			 -anchor=>'ne'
			)->pack(-side=>'left',
				-fill=>'y',
				-anchor=>'e');
	       $GUI{Agent}->{$agentJID}->{Agents}->{instructions}->{Data} =
		 $GUI{Agent}->{$agentJID}->{Agents}->{instructions}->{top}->
		   Label(-text=>"Select the Sub-Agent from the pull down menu to open an Agent Dialog what that Sub-Agent.",
			 -wraplength=>250,
			 -justify=>"left",
			 -background=>$GUI{color}->{jarl}->{profileeditor}->{bg}->{normal},
			 -foreground=>$GUI{color}->{jarl}->{profileeditor}->{fg}->{dark},
			 -font=>$GUI{fonts}->{normal},
			 -anchor=>'w'
			)->pack(-side=>'left',
				-anchor=>'w');


	       $GUI{Agent}->{$agentJID}->{Agents}->{PullDown}->{top} =
		 $GUI{Agent}->{$agentJID}->{Agents}->{top}->
		   Frame(-background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
			 -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark}
			)->pack(-side=>"top",
				-fill=>"both",
				-expand=>1);

	       $GUI{Agent}->{$agentJID}->{Agents}->{PullDown}->{Label} =
		 $GUI{Agent}->{$agentJID}->{Agents}->{PullDown}->{top}->
		   Label(-text=>"Sub-Agent:",
			 -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
			 -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
			 -font=>$GUI{fonts}->{normal},
			 -width=>$GUI{width}->{jarl}->{config}->{label},
			 -anchor=>"e"
			)->pack(-side=>'left',
				-anchor=>'e');

	       my @subAgentsList = ();

	       push(@subAgentsList,
		    [ "Choose a Sub-Agent from the list..." , "" ]);
	       my $subAgentJID;
	       for $subAgentJID (sort( {$subAgents{$a}->{name} cmp $subAgents{$b}->{name}} keys(%subAgents))) {
		 push(@subAgentsList,
		      [ $subAgents{$subAgentJID}->{name} , $subAgentJID ]);
	       }

	       $GUI{Agent}->{$agentJID}->{Agents}->{PullDown}->{Option} =
		 $GUI{Agent}->{$agentJID}->{Agents}->{PullDown}->{top}->
		   Optionmenu(-options=>\@subAgentsList,
			      -variable=>\$GUI{Agent}->{$agentJID}->{Agents}->{vars}->{subagent},
			      -textvariable=>\$GUI{Agent}->{$agentJID}->{Agents}->{vars}->{subagentDisplay},
			      -background=>$GUI{color}->{jarl}->{config}->{bg}->{normal},
			      -foreground=>$GUI{color}->{jarl}->{config}->{fg}->{dark},
			      -font=>$GUI{fonts}->{normal},
			      -command=>sub{
				return if ($GUI{Agent}->{$agentJID}->{Agents}->{vars}->{subagent} eq "");
				&jarlAgentIF_GUI($GUI{Agent}->{$agentJID}->{Agents}->{vars}->{subagent},%{$subAgents{$GUI{Agent}->{$agentJID}->{Agents}->{vars}->{subagent}}});
			      }
			     )->pack(-side=>'left',
				     -anchor=>'w');
	     });
    }
  }

  $GUI{Agent}->{$agentJID}->{TabBar}->RaiseTab("general");
}


##############################################################################
#
# jarlAgentIF_CloseGUI - closes the Agent GUI.
#
##############################################################################
sub jarlAgentIF_CloseCB {
  my ($agentJID) = @_;
  $GUI{Agent}->{$agentJID}->{window}->destroy;
  delete($GUI{Agent}->{$agentJID});
}


1;
