##############################################################################
#
# Jarl - Normal CLI Interface Code
#
#   Perl code to handle interfacing with the user and dealing with
# display received normals and editting outgoing ones.
#
##############################################################################

##############################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#  Jabber
#  Copyright (C) 1998-1999 The Jabber Team http://jabber.org/
#
##############################################################################

sub jarlNormalIF_NewGUI {
  my ($widget) = @_;

  my $upperFrame =
    $widget->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'x');

  my $middleFrame =
    $widget->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);

  my $lowerFrame =
    $widget->
      Frame(-background=>$GUI{color}->{window}->{bg}->{normal},
	    -foreground=>$GUI{color}->{window}->{fg}->{dark},
	   )->pack(-side=>'top',
		   -fill=>'both',
		   -expand=>1);

  &jarlNormalIF_ToolBarGUI($upperFrame);
  &jarlNormalIF_ListGUI($middleFrame);
  &jarlNormalIF_BodyGUI($lowerFrame);
}


##############################################################################
#
# jarlNormalIF_ToolBarGUI - creates the normal toolbar GUI.
#
##############################################################################
sub jarlNormalIF_ToolBarGUI {
  my ($frame) = @_;

  my $toolbar =
    $frame->
      Frame(-borderwidth=>0,
	    -relief=>"flat",
	    -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -anchor=>"w",
		   -fill=>"x");

  $GUI{Jabber}->{Normal}->{ToolBar}->{Reply} =
    $toolbar->
      Button(-image=>$GUI{Icons}->{Reply},
	     -relief=>"flat",
	     -borderwidth=>1,
	     -state=>"disabled",
	     -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	     -command=>sub {
	       my @cur = $GUI{Jabber}->{MessageList}->{MulColListbox}->curselection();
	       return if ($#cur != 0);
	       &jarlNormal_Compose("reply",$GUI{Jabber}->{MessageList}->{MulColListbox}->get("mid",$GUI{Jabber}->{MessageList}->{MulColListbox}->curselection));
	     })->pack(-side=>"left",
		      -pady=>2,
		      -padx=>5);
  &jarlMainIF_RegisterIcon($GUI{Jabber}->{Normal}->{ToolBar}->{Reply},$GUI{Icons}->{Reply});
  $GUI{ToolBar}->{Balloon}->
    attach($GUI{Jabber}->{Normal}->{ToolBar}->{Reply},
	   -balloonmsg=>"Reply to message ");
  $GUI{Jabber}->{Normal}->{ToolBar}->{Reply}->
    bind("<Enter>",
	 sub {
	       $GUI{Jabber}->{Normal}->{ToolBar}->{Reply}->configure(-relief=>"raised");
	 });
  $GUI{Jabber}->{Normal}->{ToolBar}->{Reply}->
    bind("<Leave>",
	 sub {
	   $GUI{Jabber}->{Normal}->{ToolBar}->{Reply}->configure(-relief=>"flat");
	 });

  my $trashCan =
    $toolbar->
      Button(-image=>$GUI{Icons}->{Trash},
	     -relief=>"flat",
	     -borderwidth=>1,
	     -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	     -command=>sub {
	       my @mids = $GUI{Jabber}->{MessageList}->{MulColListbox}->get("mid",$GUI{Jabber}->{MessageList}->{MulColListbox}->curselection());
	       &jarlNormal_DeleteMessage(@mids);
	       &jarlNormalIF_ShowMessage();
	     })->pack(-side=>"left",
		      -pady=>2,
		      -padx=>5);
  &jarlMainIF_RegisterIcon($trashCan,$GUI{Icons}->{Trash});
  $GUI{ToolBar}->{Balloon}->
    attach($trashCan,
	   -balloonmsg=>"Delete Selected Messages ");
  $trashCan->
    bind("<Enter>",
	 sub {
	       $trashCan->configure(-relief=>"raised");
	 });
  $trashCan->
    bind("<Leave>",
	 sub {
	   $trashCan->configure(-relief=>"flat");
	 });
}


##############################################################################
#
# jarlNormalIF_ListGUI - creates the normal list GUI.
#
##############################################################################
sub jarlNormalIF_ListGUI {
  my ($frame) = @_;

  $GUI{Jabber}->{MessageList}->{top} =
    $frame->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);

#  $GUI{Jabber}->{MessageList}->{Header} =
#    $GUI{Jabber}->{MessageList}->{top}->
#      Label(-text=>"Messages",
#	    -anchor=>"w",
#	    -font=>$GUI{fonts}->{header},
#	    -background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
#	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
#	   )->pack(-side=>"top",
#		   -fill=>"x");

  $GUI{Jabber}->{MessageList}->{MulColListbox} =
    $GUI{Jabber}->{MessageList}->{top}->
      MulColListbox(-headerbackground=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
		    -headerforeground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
		    -headerborderwidth=>1,
		    -marker=>1,
		    -markerstyle=>"diamond",
		    -background=>$GUI{color}->{bg}->{light},
		    -foreground=>$GUI{color}->{fg}->{dark},
		    -relief=>"sunken",
		    -borderwidth=>2,
		    -height=>0,
		    -width=>0,
		    -font=>$GUI{fonts}->{normal},
		    -selectmode=>"multiple",
		    -selectbackground=>$GUI{color}->{bg}->{list},
		    -selectforeground=>$GUI{color}->{fg}->{list},
		    -scrollbarborderwidth=>1,
		    -scrollbarrelief=>"flat",
		    -sortby=>"time"
		   )->pack(-side=>"top",
			   -fill=>"both",
			   -expand=>1,
			   -padx=>5,
			   -pady=>5);

  $GUI{Jabber}->{MessageList}->{MulColListbox}->
    AddColumn(-header=>"Sender",
	      -key=>"sender");
  $GUI{Jabber}->{MessageList}->{MulColListbox}->
    AddColumn(-header=>"Subject",
	      -key=>"subject");
  $GUI{Jabber}->{MessageList}->{MulColListbox}->
    AddColumn(-header=>"Date",
	      -key=>"date",
	      -sortby=>"time");

  $GUI{Jabber}->{MessageList}->{MulColListbox}->
    bind("<Button-1>",
	 sub {
	   return
	     if ($GUI{Jabber}->{MessageList}->{MulColListbox}->curselection eq "");
	   $GUI{Jabber}->{Normal}->{ToolBar}->{Reply}->configure(-state=>"normal") if ($GUI{Jabber}->{MessageList}->{MulColListbox}->get("encrypted",$GUI{Jabber}->{MessageList}->{MulColListbox}->curselection()) eq "normal")
	   &jarlNormalIF_ShowMessage($GUI{Jabber}->{MessageList}->{MulColListbox}->get("encrypted",$GUI{Jabber}->{MessageList}->{MulColListbox}->curselection),@{$GUI{Jabber}->{MessageList}->{MulColListbox}->get("body",$GUI{Jabber}->{MessageList}->{MulColListbox}->curselection)});
	 }
	);

  $GUI{Jabber}->{MessageList}->{MulColListbox}->
    bind("<Shift-Button-1>",
	 sub {
	   my @cur = $GUI{Jabber}->{MessageList}->{MulColListbox}->curselection();
	   $GUI{Jabber}->{Normal}->{ToolBar}->{Reply}->configure(-state=>"disabled") if ($#cur != 0);
	 }
	);
  $GUI{Jabber}->{MessageList}->{MulColListbox}->
    bind("<Control-Button-1>",
	 sub {
	   my @cur = $GUI{Jabber}->{MessageList}->{MulColListbox}->curselection();
	   $GUI{Jabber}->{Normal}->{ToolBar}->{Reply}->configure(-state=>"disabled") if ($#cur != 0);
	 }
	);

  $GUI{Jabber}->{MessageList}->{MulColListbox}->
    bind("<Button-3>",
         [ sub{
             my ($mcl,$y) = @_;
	     my $nearest = $mcl->nearest($y);
	     return if ($nearest == -1);
	     if (!$mcl->selected($nearest)) {
	       $mcl->selectionClear(0,"end");
	       $mcl->selectionSet($nearest);
	       $mcl->viewed($nearest);
	       &jarlNormalIF_ShowMessage($GUI{Jabber}->{MessageList}->{MulColListbox}->get("encrypted",$nearest),@{$GUI{Jabber}->{MessageList}->{MulColListbox}->get("body",$nearest)});
	     }
	     my @mids = $mcl->get("mid",$mcl->curselection);
	     &jarlNormalIF_PopupGUI(@mids);
             $GUI{NormalPopup}->Popup(-popover=>"cursor",
				      -popanchor=>"nw");
           },
           Ev('y')
         ]
        );
}


##############################################################################
#
# jarlNormalIF_ShowMessage - shows the selected message.
#
##############################################################################
sub jarlNormalIF_ShowMessage {
  my ($encrypted,@body) = @_;

  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->configure(-state=>"normal");
  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->delete("1.0","end");
  if (defined($encrypted) && ($encrypted == 1)) {
    my $secureIcon =
      $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
	Label(-image=>$GUI{Icons}->{SecureMessage},
	      -background=>$GUI{color}->{bg}->{light});
    &jarlMainIF_RegisterIcon($secureIcon,"SecureMessage");
    $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
      windowCreate("end",
		   -window=>$secureIcon);
    $GUI{Jabber}->{MessageBody}->{Body}->{Text}->insert("end","\n");
  }

  while ($#body > -1) {
    my $pieceType = shift(@body);
    my $piece = shift(@body);

    my @tagList = ( $pieceType, $type, $type."$currentID");
    if ($pieceType eq "link") {
      push(@tagList, "link-$piece");
      $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
	tagBind("link-$piece",
		"<Button-1>",
		sub{
		  &jarlFetchURL($piece);
		});
    }

    $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
      insert("end", $piece, \@tagList);

    $priority = "medium" if ($pieceType eq "highlight");
  }

  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->configure(-state=>"disabled");
}


##############################################################################
#
# jarlNormalIF_BodyGUI - creates the message body GUI.
#
##############################################################################
sub jarlNormalIF_BodyGUI {
  my ($frame) = @_;

  $GUI{Jabber}->{MessageBody}->{top} =
    $frame->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1);

  $GUI{Jabber}->{MessageBody}->{Body}->{top} =
    $GUI{Jabber}->{MessageBody}->{top}->
      Frame(-background=>$GUI{color}->{jarl}->{main}->{bg}->{normal},
	    -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	    -relief=>"sunken",
	    -borderwidth=>2
	   )->pack(-side=>"top",
		   -fill=>"both",
		   -expand=>1,
		   -padx=>5,
		   -pady=>5);

  $GUI{Jabber}->{MessageBody}->{Body}->{Scrolled} =
    $GUI{Jabber}->{MessageBody}->{Body}->{top}->
      Scrolled("Text",
	       -scrollbars=>"oe",
	       -background=>$GUI{color}->{jarl}->{main}->{bg}->{light},
	       -foreground=>$GUI{color}->{jarl}->{main}->{fg}->{dark},
	       -font=>$GUI{fonts}->{normal},
	       -height=>5,
	       -width=>0,
	       -borderwidth=>0,
	       -highlightthickness=>0,
	       -selectborderwidth=>0,
	       -exportselection=>1,
	       -takefocus=>0,
	       -wrap=>"word",
	       -state=>"disabled"
	      )->pack(-side=>"left",
		      -fill=>"both",
		      -expand=>1,
		      -padx=>0,
		      -pady=>0);

  $GUI{Jabber}->{MessageBody}->{Body}->{Scrollbar} =
    $GUI{Jabber}->{MessageBody}->{Body}->{Scrolled}->Subwidget("yscrollbar");
  $GUI{Jabber}->{MessageBody}->{Body}->{Scrollbar}->
    configure(-width=>10,
	      -borderwidth=>1,
	      -relief=>"flat");
  $GUI{Jabber}->{MessageBody}->{Body}->{Text} =
    $GUI{Jabber}->{MessageBody}->{Body}->{Scrolled}->Subwidget("text");

  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
    tagConfigure("server",
		 -foreground=>"green4");
  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
    tagConfigure("me",
		 -foreground=>"red");
  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
    tagConfigure("notme",
		 -foreground=>"blue");
  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
    tagConfigure("highlight",
		 -foreground=>"red");
  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
    tagConfigure("timestamp",
		 -foreground=>"gray30");
  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
    tagConfigure("action",
		 -foreground=>"purple");
  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
    tagConfigure("link",
		 -foreground=>"blue",
		 -font=>$GUI{fonts}->{link});

  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
    tagBind("link",
	    "<Enter>",
	    sub{
	      $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
		configure(-cursor=>"hand2");
	    });
  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
    tagBind("link",
	    "<Leave>",
	    sub{
	      $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
		configure(-cursor=>"xterm");
	    });

  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
    bind("<Button-4>",
	 sub{
	   $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
	     yviewScroll(-1,"units");
	 });
  $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
    bind("<Button-5>",
	 sub{
	   $GUI{Jabber}->{MessageBody}->{Body}->{Text}->
	     yviewScroll(1,"units");
	 });
}


##############################################################################
#
# jarlNormalIF_NewNormal - function to do all GUI calls needed to create a
#                          new compose.
#
##############################################################################
sub jarlNormalIF_NewNormal {
  my ($tag) = @_;

  &jarlNormalIF_ComposeGUI($tag);
  &jarlNormalIF_Send($tag);
}


##############################################################################
#
# jarlNormalIF_ComposeGUI - creates a new message window.
#
##############################################################################
sub jarlNormalIF_ComposeGUI {
  my ($tag) = @_;

  &jarlNormalIF_CurrentTo($tag,&jarlMainIF_Prompt(prompt=>"To",
						  default=>&jarlNormal_JID($tag)->GetJID("full")));
  &jarlNormalIF_CurrentSubject($tag,&jarlMainIF_Prompt(prompt=>"Subject",
						       default=>&jarlNormal_Message($tag)->GetSubject()));
  &jarlNormalIF_CurrentBody($tag,&jarlMainIF_Prompt(prompt=>"Body"));
}


##############################################################################
#
# jarlNormalIF_Send - do everything needed to send this message and close it.
#
##############################################################################
sub jarlNormalIF_Send {
  my ($tag) = @_;

  &jarlNormal_Send($tag);
  &jarlNormalIF_Close($tag);
}


##############################################################################
#
# jarlNormalIF_Close - do everything needed to close down the fort.
#
##############################################################################
sub jarlNormalIF_Close {
  my ($tag) = @_;

  delete($normal{compose}->{$tag});
}


##############################################################################
#
# jarlNormalIF_CurrentTo - if $value is defined then the Entry contents are
#                          set to $value, otherwise the contents of the Entry
#                          are returned.
#
##############################################################################
sub jarlNormalIF_CurrentTo {
  my ($tag,$value) =  @_;
  $normal{compose}->{$tag}->{to} = $value if (defined($value));
  return new Net::Jabber::JID($normal{compose}->{$tag}->{to});
}


##############################################################################
#
# jarlNormalIF_CurrentSubject - if $value is defined then the Entry contents
#                               are set to $value, otherwise the contents of
#                               the Entry are returned.
#
##############################################################################
sub jarlNormalIF_CurrentSubject {
  my ($tag,$value) =  @_;
  $normal{compose}->{$tag}->{subject} = $value if (defined($value));
  return $normal{compose}->{$tag}->{subject};
}


##############################################################################
#
# jarlNormalIF_CurrentBody - if $value is defined then the Text contents are
#                            set to $value, otherwise the contents of the Text
#                            are returned.
#
##############################################################################
sub jarlNormalIF_CurrentBody {
  my ($tag,$value) =  @_;
  $normal{compose}->{$tag}->{body} = $value if (defined($value));
  return $normal{compose}->{$tag}->{body};
}


##############################################################################
#
# jarlNormalIF_Secure - make the message with the specified JID secure
#                             (if possible)
#
##############################################################################
sub jarlNormalIF_Secure {
  my ($tag,$value) = @_;

  &jarlMainIF_ChangeIcon($GUI{Jabber}->{Normal}->{$tag}->{ButtonsTop}->{Secure},
			 (($value == 1) ? "SecureOn" : "SecureOff"),
			 (($value == 1) ? "SecureOff" : "SecureOn"),
			);
}


##############################################################################
#
# jarlNormalIF_AddMessage - add the specified message into memory and the GUI.
#
##############################################################################
sub jarlNormalIF_AddMessage {
  my ($mid,%args) = @_;

  $TabBar->Print("__jarl__:tabbar","normal","normal","--Normal","-"x40,"\n");
  $TabBar->Print("__jarl__:tabbar","normal","normal","From: $args{sender}\n");
  $TabBar->Print("__jarl__:tabbar","normal","normal","Date: $args{date}\n");
  $TabBar->Print("__jarl__:tabbar","normal","normal","Subject: $args{subject}\n") if ($args{subject} ne "");
  $TabBar->Print("__jarl__:tabbar","normal","normal","\n");

  my @body = @{$args{body}};
  while ($#body > -1) {
    my $pieceType = shift(@body);
    my $piece = shift(@body);

    $TabBar->Print("__jarl__:tabbar","normal","normal","$piece");
  }
  $TabBar->Print("__jarl__:tabbar","normal","normal","\n");
  $TabBar->Print("__jarl__:tabbar","normal","normal","--------","-"x40,"\n");

#  $args{mid} = $mid;
#  $args{mcl_style} = delete($args{type}) unless ($args{type} eq "normal");
#  $GUI{Jabber}->{MessageList}->{MulColListbox}->insert(\%args);
  $TabBar->HighlightTab("normal");
}


##############################################################################
#
# jarlNormalIF_DeleteMessage - add the specified message into memory and the GUI.
#
##############################################################################
sub jarlNormalIF_DeleteMessage {
  my (@mid) = @_;

  $GUI{Jabber}->{MessageList}->{MulColListbox}->delete($GUI{Jabber}->{MessageList}->{MulColListbox}->search("mid",@mid));
}



1;
