<html>
<head><title>JDBC Query Page</title></head>

<body bgcolor="#ffffff">

<h1>JDBC Query Page</h1>

<form method="post" action="query.gsp">

Enter your SQL query:<br>
<input type="text" name="query" size="60">
<input type="submit">
</form>

<java type="import">java.sql.*</java>
<java type="import">com.bitmechanic.sql.*</java>
<java>
   Form form = request.getForm();
   String query = form.getValue("query");
   if(query != null && !query.equals("")) {
      out.println("<p><hr><p>");

      Connection conn = null;
      Statement stmt = null;
      try {
        //
        // Get a connection from the pool - username and password are left null
        conn = DriverManager.getConnection(ConnectionPoolManager.URL_PREFIX + "jdbcalias", null, null);
        stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        ResultSetMetaData metaData = rs.getMetaData();
        out.println("<table border=0 cellpadding=4 cellspacing=0>");
	out.println("<tr bgcolor=#99ccff>");
        int columnCount = metaData.getColumnCount();
	for(int i = 1; i <= columnCount; i++) {
          out.println(" <th align=left>"+ metaData.getColumnName(i) + "</th>");
        }
        out.println("</tr>");
        String bgcolor[] = { "#ffffff", "#cccccc" };
        int x = 0;
        while(rs.next()) {
          out.println("<tr bgcolor=" + bgcolor[++x % 2] + ">");
          for(int i = 1; i <= columnCount; i++) {
            out.println("  <td>" + rs.getString(i) + "</td>");
          }
          out.println("</tr>");
        }
        out.println("</table>");
        rs.close(); 
        stmt.close();

        // this doesn't actually close the connection; it returns it back to
        // the pool for another thread to use
        conn.close();
      }
      catch(SQLException e) {
        out.println("<h3>Error executing Query:</h3>");
        out.println("<pre>" + Logger.exceptionToString(e) + "</pre>");
	try {
           //
           // return conn to pool -- this prevents a cursor leak
           if(stmt != null) stmt.close();
           if(conn != null) conn.close();
        }
        catch(SQLException e) {  }
      }
   }
</java>

</body>
</html>