/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary.pluginstuff;

import info.jdictionary.JDictionary;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PluginInfoSheet
implements Serializable {
    String name;
    String url;
    String version;
    String minJdictionaryVersion;
    String author;
    String fileName;
    String size;
    String description;

    public static PluginInfoSheet CreateInfoSheet(ZipFile pluginFile) {
        PluginInfoSheet s = PluginInfoSheet.CreateInfoSheet(pluginFile, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("PluginInfoSheetFileName")))).append("_").append(JDictionary.getLanguage()))));
        if (s != null) {
            return s;
        }
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("InfoSheetCreator: Local specific info sheet is not found in plugin named: ").append(pluginFile.getName()).append(" Trying to load the default sheet"))));
        return PluginInfoSheet.CreateInfoSheet(pluginFile, JDictionary.getString("PluginInfoSheetFileName"));
    }

    public static PluginInfoSheet CreateInfoSheet(ZipFile pluginFile, String fileName) {
        ZipEntry entry = pluginFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        byte[] b = new byte[(int)entry.getSize()];
        try {
            InputStream in = pluginFile.getInputStream(entry);
            in.read(b);
        }
        catch (IOException ex) {
            PluginInfoSheet pluginInfoSheet = null;
            return pluginInfoSheet;
        }
        PluginInfoSheet sheet = PluginInfoSheet.createInfoSheet(b);
        File f = new File(pluginFile.getName());
        sheet.setSize(Long.toString(f.length()));
        sheet.setFileName(f.getName());
        return sheet;
    }

    public static Object[] CreateInfoSheets(ZipFile pluginFile) {
        Object[] s = PluginInfoSheet.CreateInfoSheets(pluginFile, "InfoSheets_".concat(String.valueOf(String.valueOf(JDictionary.getLanguage()))));
        if (s != null) {
            return s;
        }
        return PluginInfoSheet.CreateInfoSheets(pluginFile, "InfoSheets");
    }

    public static Object[] CreateInfoSheets(ZipFile pluginFile, String fileName) {
        ZipEntry entry = pluginFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        byte[] b = new byte[(int)entry.getSize()];
        try {
            InputStream in = pluginFile.getInputStream(entry);
            in.read(b);
        }
        catch (IOException ex) {
            Object[] objectArray = null;
            return objectArray;
        }
        return PluginInfoSheet.createInfoSheets(b);
    }

    public static PluginInfoSheet CreateInfoSheet(URL url) {
        Object temp = null;
        DataInputStream din = null;
        byte[] b = new byte[4096];
        try {
            din = new DataInputStream(url.openStream());
            din.read(b);
        }
        catch (IOException e) {
            PluginInfoSheet pluginInfoSheet = null;
            return pluginInfoSheet;
        }
        return PluginInfoSheet.createInfoSheet(b);
    }

    public static Object[] CreateInfoSheets(URL url) {
        byte[] b = null;
        try {
            int offset = 0;
            int loadedBytesCount = 0;
            int length = url.openConnection().getContentLength();
            if (length == -1) {
                Object[] objectArray = null;
                return objectArray;
            }
            b = new byte[length];
            DataInputStream din = new DataInputStream(url.openStream());
            while (loadedBytesCount < length) {
                if ((loadedBytesCount = din.read(b, offset += loadedBytesCount, length -= loadedBytesCount)) != -1) continue;
                System.err.println("CreateInfoSheet(): Wrong thing happened when I attempted to download the information about the new plugins");
                Object[] objectArray = null;
                return objectArray;
            }
        }
        catch (IOException e) {
            System.out.println("CreateInfoSheet(): Wrong thing happened when I attempted to download the information about the new plugins");
            Object[] objectArray = null;
            return objectArray;
        }
        return PluginInfoSheet.createInfoSheets(b);
    }

    public static PluginInfoSheet createInfoSheet(byte[] infoSheetData) {
        int offset = 0;
        PluginInfoSheet sheet = new PluginInfoSheet();
        for (int n = 0; n < infoSheetData.length; ++n) {
            if (infoSheetData[n] != 10) continue;
            String temp = new String(infoSheetData, offset, n - offset - 1);
            offset = n + 1;
            if (temp.charAt(0) == 'E') break;
            PluginInfoSheet.determineLine(temp, sheet);
        }
        return sheet;
    }

    public static Object[] createInfoSheets(byte[] infoSheetDatas) {
        int offset = 0;
        PluginInfoSheet sheet = new PluginInfoSheet();
        ArrayList<PluginInfoSheet> sheets = new ArrayList<PluginInfoSheet>();
        for (int n = 0; n < infoSheetDatas.length; ++n) {
            if (infoSheetDatas[n] != 10) continue;
            String temp = new String(infoSheetDatas, offset, n - offset - 1);
            offset = n + 1;
            if (temp.charAt(0) == 'E') {
                sheets.add(sheet);
                sheet = new PluginInfoSheet();
            }
            PluginInfoSheet.determineLine(temp, sheet);
        }
        sheets.add(sheet);
        return sheets.toArray();
    }

    static void determineLine(String line, PluginInfoSheet sheet) {
        switch (line.charAt(0)) {
            case 'N': {
                sheet.name = line.substring(2, line.length());
                break;
            }
            case 'V': {
                sheet.version = line.substring(2, line.length());
                break;
            }
            case 'S': {
                sheet.size = line.substring(2, line.length());
                break;
            }
            case 'A': {
                sheet.author = line.substring(2, line.length());
                break;
            }
            case 'D': {
                sheet.description = line.substring(2, line.length());
                break;
            }
            case 'F': {
                sheet.fileName = line.substring(2, line.length());
                if (sheet.fileName.indexOf("http://") == -1) break;
                sheet.url = sheet.fileName;
                sheet.fileName = PluginInfoSheet.urlToFileName(sheet.fileName);
                break;
            }
            case 'J': {
                sheet.minJdictionaryVersion = line.substring(2, line.length());
                break;
            }
        }
    }

    static String urlToFileName(String url) {
        int s = url.lastIndexOf("/");
        if (s > -1) {
            return url.substring(s + 1, url.length());
        }
        return null;
    }

    public PluginInfoSheet() {
    }

    public PluginInfoSheet(String name, String version, String Author, String fileName, String size, String Description, String minJDictionaryVersion) {
        this.name = name;
        this.version = version;
        this.author = this.author;
        this.fileName = fileName;
        this.size = size;
        this.description = this.description;
        this.minJdictionaryVersion = this.minJdictionaryVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSize() {
        return this.size;
    }

    public String getSizeInKB() {
        if (this.getSize() != null) {
            return new Integer(Integer.parseInt(this.getSize()) / 1024).toString();
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMinJDictionaryVersion() {
        if (this.minJdictionaryVersion == null) {
            return "0";
        }
        return this.minJdictionaryVersion;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getURL() {
        return this.url;
    }

    public void setSize(String size) {
        this.size = size;
    }
}

