/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;
import java.util.Vector;

final class RETokenRepeated
extends REToken {
    private REToken token;
    private int min;
    private int max;
    private boolean stingy;

    RETokenRepeated(int subIndex, REToken token, int min, int max) {
        super(subIndex);
        this.token = token;
        this.min = min;
        this.max = max;
    }

    void makeStingy() {
        this.stingy = true;
    }

    boolean isStingy() {
        return this.stingy;
    }

    int getMinimumLength() {
        return this.min * this.token.getMinimumLength();
    }

    boolean match(CharIndexed input, REMatch mymatch) {
        int numRepeats = 0;
        REMatch newMatch = mymatch;
        Object last = null;
        Vector<REMatch> positions = new Vector<REMatch>();
        positions.addElement(newMatch);
        do {
            REMatch result;
            if (this.stingy && numRepeats >= this.min && (result = this.matchRest(input, newMatch)) != null) {
                mymatch.assignFrom(result);
                return true;
            }
            REMatch doables = null;
            REMatch doablesLast = null;
            REMatch current = newMatch;
            while (current != null) {
                REMatch recurrent = (REMatch)current.clone();
                if (this.token.match(input, recurrent)) {
                    if (doables == null) {
                        doables = recurrent;
                        doablesLast = recurrent;
                    } else {
                        doablesLast.next = recurrent;
                    }
                    while (doablesLast.next != null) {
                        doablesLast = doablesLast.next;
                    }
                }
                current = current.next;
            }
            if (doables == null) break;
            newMatch = doables;
            positions.addElement(newMatch);
        } while (++numRepeats < this.max);
        if (numRepeats < this.min) {
            return false;
        }
        int posIndex = positions.size();
        REMatch allResults = null;
        REMatch allResultsLast = null;
        REMatch results = null;
        while (--posIndex >= this.min) {
            newMatch = (REMatch)positions.elementAt(posIndex);
            results = this.matchRest(input, newMatch);
            if (results == null) continue;
            if (allResults == null) {
                allResults = results;
                allResultsLast = results;
            } else {
                allResultsLast.next = results;
            }
            while (allResultsLast.next != null) {
                allResultsLast = allResultsLast.next;
            }
        }
        if (allResults != null) {
            mymatch.assignFrom(allResults);
            return true;
        }
        return false;
    }

    private REMatch matchRest(CharIndexed input, REMatch newMatch) {
        REMatch doneIndex = null;
        REMatch doneIndexLast = null;
        REMatch current = newMatch;
        while (current != null) {
            REMatch single = (REMatch)current.clone();
            if (this.next(input, single)) {
                if (doneIndex == null) {
                    doneIndex = single;
                    doneIndexLast = single;
                } else {
                    doneIndexLast.next = single;
                }
                while (doneIndexLast.next != null) {
                    doneIndexLast = doneIndexLast.next;
                }
            }
            current = current.next;
        }
        return doneIndex;
    }

    void dump(StringBuffer os) {
        os.append("(?:");
        this.token.dumpAll(os);
        os.append(')');
        if (this.max == Integer.MAX_VALUE && this.min <= 1) {
            os.append(this.min == 0 ? (char)'*' : '+');
        } else if (this.min == 0 && this.max == 1) {
            os.append('?');
        } else {
            os.append('{').append(this.min);
            if (this.max > this.min) {
                os.append(',');
                if (this.max != Integer.MAX_VALUE) {
                    os.append(this.max);
                }
            }
            os.append('}');
        }
        if (this.stingy) {
            os.append('?');
        }
    }
}

