/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.RubyBugException;
import org.jruby.runtime.CallbackFactory;

public class RubyBignum
extends RubyInteger {
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private BigInteger value;
    static /* synthetic */ Class class$org$jruby$RubyBignum;
    static /* synthetic */ Class class$org$jruby$RubyObject;

    public RubyBignum(Ruby ruby) {
        this(ruby, BigInteger.ZERO);
    }

    public RubyBignum(Ruby ruby, BigInteger value) {
        super(ruby, ruby.getClasses().getBignumClass());
        this.value = value;
    }

    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    public long getLongValue() {
        return this.value.longValue();
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public static RubyClass createBignumClass(Ruby ruby) {
        RubyClass bignumClass = ruby.defineClass("Bignum", ruby.getClasses().getIntegerClass());
        bignumClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "to_s"));
        bignumClass.defineMethod("hash", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "hash"));
        bignumClass.defineMethod("+", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_plus", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("-", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_minus", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("*", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_mul", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("/", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_div", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("%", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_mod", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("**", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_pow", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("<=>", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_cmp", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod(">", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_gt", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod(">=", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_ge", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("<", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_lt", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("<=", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_le", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        return bignumClass;
    }

    private static RubyInteger bigNorm(Ruby ruby, BigInteger bi) {
        if (bi.compareTo(LONG_MIN) < 0 || bi.compareTo(LONG_MAX) > 0) {
            return RubyBignum.newBignum(ruby, bi);
        }
        return RubyFixnum.newFixnum(ruby, bi.longValue());
    }

    private BigInteger bigIntValue(RubyNumeric other) {
        if (other instanceof RubyFloat) {
            throw new RubyBugException("argument must be an integer");
        }
        return other instanceof RubyBignum ? ((RubyBignum)other).getValue() : BigInteger.valueOf(other.getLongValue());
    }

    protected int compareValue(RubyNumeric other) {
        if (other instanceof RubyFloat) {
            double otherVal = other.getDoubleValue();
            double thisVal = this.getDoubleValue();
            return thisVal > otherVal ? 1 : (thisVal < otherVal ? -1 : 0);
        }
        return this.getValue().compareTo(this.bigIntValue(other));
    }

    public static RubyBignum newBignum(Ruby ruby, long value) {
        return RubyBignum.newBignum(ruby, BigInteger.valueOf(value));
    }

    public static RubyBignum newBignum(Ruby ruby, double value) {
        return RubyBignum.newBignum(ruby, new BigDecimal(value).toBigInteger());
    }

    public static RubyBignum newBignum(Ruby ruby, BigInteger value) {
        return new RubyBignum(ruby, value);
    }

    public RubyFixnum hash() {
        return new RubyFixnum(this.getRuby(), this.value.hashCode());
    }

    public RubyNumeric op_plus(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_plus(other);
        }
        return RubyBignum.bigNorm(this.getRuby(), this.getValue().add(this.bigIntValue(other)));
    }

    public RubyNumeric op_minus(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_minus(other);
        }
        return RubyBignum.bigNorm(this.getRuby(), this.getValue().subtract(this.bigIntValue(other)));
    }

    public RubyNumeric op_mul(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_mul(other);
        }
        return RubyBignum.bigNorm(this.getRuby(), this.getValue().multiply(this.bigIntValue(other)));
    }

    public RubyNumeric op_div(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_div(other);
        }
        return RubyBignum.bigNorm(this.getRuby(), this.getValue().divide(this.bigIntValue(other)));
    }

    public RubyNumeric op_mod(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_mod(other);
        }
        return RubyBignum.bigNorm(this.getRuby(), this.getValue().mod(this.bigIntValue(other)));
    }

    public RubyNumeric op_pow(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_pow(other);
        }
        return RubyBignum.bigNorm(this.getRuby(), this.getValue().pow((int)other.getLongValue()));
    }

    public RubyBoolean op_equal(RubyObject other) {
        if (!(other instanceof RubyNumeric)) {
            return this.getRuby().getFalse();
        }
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue((RubyNumeric)other) == 0);
    }

    public RubyNumeric op_cmp(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFixnum.newFixnum(this.getRuby(), this.compareValue(other));
    }

    public RubyBoolean op_gt(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) > 0);
    }

    public RubyBoolean op_ge(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) >= 0);
    }

    public RubyBoolean op_lt(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) < 0);
    }

    public RubyBoolean op_le(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) <= 0);
    }

    public RubyString to_s() {
        return RubyString.newString(this.getRuby(), this.getValue().toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

