/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.EOFError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RubyArgumentException;
import org.jruby.exceptions.ThrowJump;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.RubyFrame;
import org.jruby.runtime.RubyGlobalEntry;
import org.jruby.runtime.RubyVarmap;

public class RubyGlobal {
    static /* synthetic */ Class class$org$jruby$RubyGlobal;
    static /* synthetic */ Class class$org$jruby$RubyObject;
    static /* synthetic */ Class class$org$jruby$RubyString;

    public static void createGlobals(Ruby ruby) {
        StringSetter stringSetter = new StringSetter();
        LastlineAccessor lastlineAccessor = new LastlineAccessor();
        SafeAccessor safeAccessor = new SafeAccessor();
        ruby.defineHookedVariable("$/", RubyString.newString(ruby, "\n"), null, stringSetter);
        ruby.defineHookedVariable("$\\", ruby.getNil(), null, stringSetter);
        ruby.defineHookedVariable("$,", ruby.getNil(), null, stringSetter);
        ruby.defineHookedVariable("$.", RubyFixnum.one(ruby), null, new LineNumberSetter());
        ruby.defineVirtualVariable("$_", lastlineAccessor, lastlineAccessor);
        ruby.defineHookedVariable("$!", ruby.getNil(), null, new ErrorInfoSetter());
        ruby.defineVirtualVariable("$SAFE", safeAccessor, safeAccessor);
        RubyObject stdin = RubyIO.stdin(ruby, ruby.getClasses().getIoClass());
        RubyObject stdout = RubyIO.stdout(ruby, ruby.getClasses().getIoClass());
        RubyObject stderr = RubyIO.stderr(ruby, ruby.getClasses().getIoClass());
        ruby.defineHookedVariable("$stdin", stdin, null, new StdInSetter());
        ruby.defineHookedVariable("$stdout", stdout, null, new StdOutSetter());
        ruby.defineHookedVariable("$stderr", stderr, null, new StdErrSetter());
        ruby.defineHookedVariable("$>", stdout, null, new DefSetter());
        ruby.defineHookedVariable("$defout", stdout, null, new DefSetter());
        ruby.defineGlobalConstant("STDIN", stdin);
        ruby.defineGlobalConstant("STDOUT", stdout);
        ruby.defineGlobalConstant("STDERR", stderr);
        RubyArgsFile argsFile = new RubyArgsFile(ruby);
        argsFile.initArgsFile();
        ruby.defineGlobalFunction("open", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "open"));
        ruby.defineGlobalFunction("format", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "sprintf"));
        ruby.defineGlobalFunction("gets", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "gets"));
        ruby.defineGlobalFunction("p", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "p"));
        ruby.defineGlobalFunction("print", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "print"));
        ruby.defineGlobalFunction("printf", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "printf"));
        ruby.defineGlobalFunction("puts", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "puts"));
        ruby.defineGlobalFunction("readline", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "readline"));
        ruby.defineGlobalFunction("readlines", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "readlines"));
        ruby.defineGlobalFunction("sprintf", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "sprintf"));
        ruby.defineGlobalFunction("gsub!", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "gsub_bang"));
        ruby.defineGlobalFunction("gsub", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "gsub"));
        ruby.defineGlobalFunction("sub!", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "sub_bang"));
        ruby.defineGlobalFunction("sub", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "sub"));
        ruby.defineGlobalFunction("chop!", CallbackFactory.getSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "chop_bang"));
        ruby.defineGlobalFunction("chop", CallbackFactory.getSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "chop"));
        ruby.defineGlobalFunction("chomp!", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "chomp_bang"));
        ruby.defineGlobalFunction("chomp", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "chomp"));
        ruby.defineGlobalFunction("split", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "split"));
        ruby.defineGlobalFunction("scan", CallbackFactory.getSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "scan", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyGlobal.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        ruby.defineGlobalFunction("load", CallbackFactory.getSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "load", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyGlobal.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        ruby.defineGlobalFunction("raise", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "raise"));
        ruby.defineGlobalFunction("require", CallbackFactory.getSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "require", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyGlobal.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        ruby.defineGlobalFunction("global_variables", CallbackFactory.getSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "global_variables"));
        ruby.defineGlobalFunction("local_variables", CallbackFactory.getSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "local_variables"));
        ruby.defineGlobalFunction("block_given?", CallbackFactory.getSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "block_given"));
        ruby.defineGlobalFunction("iterator?", CallbackFactory.getSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "block_given"));
        ruby.defineGlobalFunction("lambda", CallbackFactory.getSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "lambda"));
        ruby.defineGlobalFunction("proc", CallbackFactory.getSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "proc"));
        ruby.defineGlobalFunction("loop", CallbackFactory.getSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "loop"));
        ruby.defineGlobalFunction("eval", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "eval", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyGlobal.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        ruby.defineGlobalFunction("caller", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "caller"));
        ruby.defineGlobalFunction("catch", CallbackFactory.getSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "rbCatch", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyGlobal.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        ruby.defineGlobalFunction("throw", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyGlobal == null ? (class$org$jruby$RubyGlobal = RubyGlobal.class$("org.jruby.RubyGlobal")) : class$org$jruby$RubyGlobal, "rbThrow", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyGlobal.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        ruby.defineGlobalFunction("singleton_method_added", CallbackFactory.getNilMethod());
    }

    public static RubyObject open(Ruby ruby, RubyObject recv, RubyObject[] args) {
        if (args[0].toString().startsWith("|")) {
            return ruby.getNil();
        }
        return RubyFile.open(ruby, ruby.getClasses().getFileClass(), args);
    }

    public static RubyString gets(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyArgsFile argsFile = (RubyArgsFile)ruby.getGlobalVar("$<");
        RubyString line = argsFile.internalGets(args);
        ruby.getParserHelper().setLastline(line);
        return line;
    }

    public static RubyObject p(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyObject defout = ruby.getGlobalVar("$>");
        int i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                defout.funcall("write", args[i].funcall("inspect"));
                defout.funcall("write", RubyString.newString(ruby, "\n"));
            }
            ++i;
        }
        return ruby.getNil();
    }

    public static RubyObject puts(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyObject defout = ruby.getGlobalVar("$>");
        RubyIO.puts(ruby, defout, args);
        return ruby.getNil();
    }

    public static RubyObject print(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyObject defout = ruby.getGlobalVar("$>");
        RubyIO.print(ruby, defout, args);
        return ruby.getNil();
    }

    public static RubyObject printf(Ruby ruby, RubyObject recv, RubyObject[] args) {
        if (args.length != 0) {
            RubyObject defout = ruby.getGlobalVar("$>");
            if (!(args[0] instanceof RubyString)) {
                defout = args[0];
                RubyObject[] newArgs = new RubyObject[args.length - 1];
                System.arraycopy(args, 1, newArgs, 0, args.length - 1);
                args = newArgs;
            }
            RubyIO.printf(ruby, defout, args);
        }
        return ruby.getNil();
    }

    public static RubyString readline(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyString line = RubyGlobal.gets(ruby, recv, args);
        if (line.isNil()) {
            throw new EOFError(ruby);
        }
        return line;
    }

    public static RubyArray readlines(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyArgsFile argsFile = (RubyArgsFile)ruby.getGlobalVar("$<");
        RubyArray lines = RubyArray.newArray(ruby);
        RubyString line = argsFile.internalGets(args);
        while (!line.isNil()) {
            lines.push(line);
            line = argsFile.internalGets(args);
        }
        return lines;
    }

    public static RubyArray global_variables(Ruby ruby, RubyObject recv) {
        RubyArray globalVariables = RubyArray.newArray(ruby);
        Iterator iter = ruby.getGlobalMap().keySet().iterator();
        while (iter.hasNext()) {
            String globalVariableName = (String)iter.next();
            globalVariables.push(RubyString.newString(ruby, globalVariableName));
        }
        return globalVariables;
    }

    public static RubyArray local_variables(Ruby ruby, RubyObject recv) {
        RubyArray localVariables = RubyArray.newArray(ruby);
        if (ruby.getScope().getLocalNames() != null) {
            int i = 2;
            while (i < ruby.getScope().getLocalNames().size()) {
                if (ruby.getScope().getLocalNames().get(i) != null) {
                    localVariables.push(RubyString.newString(ruby, (String)ruby.getScope().getLocalNames().get(i)));
                }
                ++i;
            }
        }
        RubyVarmap dynamicVars = ruby.getDynamicVars();
        while (dynamicVars != null) {
            if (dynamicVars.getId() != null) {
                localVariables.push(RubyString.newString(ruby, dynamicVars.getId()));
            }
            dynamicVars = dynamicVars.getNext();
        }
        return localVariables;
    }

    public static RubyBoolean block_given(Ruby ruby, RubyObject recv) {
        return RubyBoolean.newBoolean(ruby, ruby.isFBlockGiven());
    }

    public static RubyObject sprintf(Ruby ruby, RubyObject recv, RubyObject[] args) {
        if (args.length == 0) {
            throw new RubyArgumentException(ruby, "sprintf must have at least one argument");
        }
        RubyString str = RubyString.stringValue(args[0]);
        RubyArray newArgs = RubyArray.create(ruby, null, args);
        newArgs.shift();
        return str.format(newArgs);
    }

    public static RubyObject raise(Ruby ruby, RubyObject recv, RubyObject[] args) {
        switch (args.length) {
            case 0: 
            case 1: {
                throw new RaiseException(RubyException.newInstance(ruby, ruby.getExceptions().getRuntimeError(), args));
            }
            case 2: {
                RubyException excptn = (RubyException)args[0].funcall("exception", args[1]);
                throw new RaiseException(excptn);
            }
        }
        throw new RubyArgumentException(ruby, "wrong # of arguments");
    }

    public static RubyObject require(Ruby ruby, RubyObject recv, RubyString i2Load) {
        RubyArray lFeatures = (RubyArray)ruby.getGlobalVar("$\"");
        if (lFeatures.index(i2Load).isNil()) {
            RubyGlobal.load(ruby, recv, i2Load);
            lFeatures.push(i2Load);
            return ruby.getTrue();
        }
        return ruby.getFalse();
    }

    public static RubyObject load(Ruby ruby, RubyObject recv, RubyString i2Load) {
        if (i2Load.getValue().endsWith(".jar")) {
            File jarFile = ruby.findFile(new File(i2Load.getValue()));
            if (!jarFile.exists()) {
                ruby.getRuntime().getErrorStream().println("[Error] Jarfile + \"" + jarFile.getAbsolutePath() + "\"not found.");
            }
        } else {
            if (!i2Load.getValue().endsWith(".rb")) {
                i2Load = RubyString.newString(ruby, i2Load.getValue() + ".rb");
            }
            File rbFile = ruby.findFile(new File(i2Load.getValue()));
            ruby.getRuntime().loadFile(rbFile, false);
        }
        return ruby.getTrue();
    }

    private static RubyString getLastlineString(Ruby ruby) {
        RubyObject line = ruby.getParserHelper().getLastline();
        if (line.isNil()) {
            throw new TypeError(ruby, "$_ value need to be String (nil given).");
        }
        if (!(line instanceof RubyString)) {
            throw new TypeError(ruby, "$_ value need to be String (" + line.getRubyClass().toName() + " given).");
        }
        return (RubyString)line;
    }

    public static RubyObject sub_bang(Ruby ruby, RubyObject recv, RubyObject[] args) {
        return RubyGlobal.getLastlineString(ruby).sub_bang(args);
    }

    public static RubyObject sub(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyString str = (RubyString)RubyGlobal.getLastlineString(ruby).dup();
        if (!str.sub_bang(args).isNil()) {
            ruby.getParserHelper().setLastline(str);
        }
        return str;
    }

    public static RubyObject gsub_bang(Ruby ruby, RubyObject recv, RubyObject[] args) {
        return RubyGlobal.getLastlineString(ruby).gsub_bang(args);
    }

    public static RubyObject gsub(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyString str = (RubyString)RubyGlobal.getLastlineString(ruby).dup();
        if (!str.gsub_bang(args).isNil()) {
            ruby.getParserHelper().setLastline(str);
        }
        return str;
    }

    public static RubyObject chop_bang(Ruby ruby, RubyObject recv) {
        return RubyGlobal.getLastlineString(ruby).chop_bang();
    }

    public static RubyObject chop(Ruby ruby, RubyObject recv) {
        RubyString str = RubyGlobal.getLastlineString(ruby);
        if (str.getValue().length() > 0) {
            str = (RubyString)str.dup();
            str.chop_bang();
            ruby.getParserHelper().setLastline(str);
        }
        return str;
    }

    public static RubyObject chomp_bang(Ruby ruby, RubyObject recv, RubyObject[] args) {
        return RubyGlobal.getLastlineString(ruby).chomp_bang(args);
    }

    public static RubyObject chomp(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyString str = RubyGlobal.getLastlineString(ruby);
        RubyString dup = (RubyString)str.dup();
        if (dup.chomp_bang(args).isNil()) {
            return str;
        }
        ruby.getParserHelper().setLastline(dup);
        return str;
    }

    public static RubyObject split(Ruby ruby, RubyObject recv, RubyObject[] args) {
        return RubyGlobal.getLastlineString(ruby).split(args);
    }

    public static RubyObject scan(Ruby ruby, RubyObject recv, RubyObject pattern) {
        return RubyGlobal.getLastlineString(ruby).scan(pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyObject eval(Ruby ruby, RubyObject recv, RubyString src, RubyObject[] args) {
        RubyObject scope = args.length > 0 ? args[0] : ruby.getNil();
        String file = "(eval)";
        int line = 1;
        if (args.length > 1) {
            file = args[1].toString();
        }
        if (args.length > 2) {
            line = RubyFixnum.fix2int(args[2]);
        }
        src.checkSafeString();
        if (scope.isNil() && ruby.getRubyFrame().getPrev() != null) {
            try {
                RubyFrame prev = new RubyFrame(ruby.getRubyFrame());
                ruby.getRubyFrame().push();
                ruby.setRubyFrame(prev.getPrev());
                ruby.getRubyFrame().setPrev(prev);
                RubyObject rubyObject = recv.eval(src, scope, file, line);
                Object var10_9 = null;
                ruby.getRubyFrame().pop();
                return rubyObject;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                ruby.getRubyFrame().pop();
                throw throwable;
            }
        }
        return recv.eval(src, scope, file, line);
    }

    public static RubyObject caller(Ruby ruby, RubyObject recv, RubyObject[] args) {
        int level;
        int n = level = args.length > 0 ? RubyFixnum.fix2int(args[0]) : 1;
        if (level < 0) {
            throw new RubyArgumentException(ruby, "negative level(" + level + ')');
        }
        return RaiseException.createBacktrace(ruby, level);
    }

    public static RubyObject rbCatch(Ruby ruby, RubyObject recv, RubyObject tag) {
        try {
            return ruby.yield(tag);
        }
        catch (ThrowJump throwJump) {
            if (throwJump.getTag().equals(tag.toId())) {
                return throwJump.getValue();
            }
            throw throwJump;
        }
    }

    public static RubyObject rbThrow(Ruby ruby, RubyObject recv, RubyObject tag, RubyObject[] args) {
        throw new ThrowJump(tag.toId(), args.length > 0 ? args[0] : ruby.getNil());
    }

    public static RubyObject lambda(Ruby ruby, RubyObject recv) {
        return RubyProc.newProc(ruby, ruby.getClasses().getProcClass());
    }

    public static RubyObject loop(Ruby ruby, RubyObject recv) {
        while (true) {
            ruby.yield(ruby.getNil());
            Thread.yield();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DefSetter
    implements RubyGlobalEntry.SetterMethod {
        private DefSetter() {
        }

        public void set(RubyObject value, String id, RubyObject data, RubyGlobalEntry entry) {
            if (value.respond_to(RubySymbol.newSymbol(entry.getRuby(), "write")).isFalse()) {
                throw new TypeError(entry.getRuby(), "$> must have write method, " + value.type().toName() + " given");
            }
            entry.setData(value);
        }
    }

    private static class StdErrSetter
    implements RubyGlobalEntry.SetterMethod {
        private StdErrSetter() {
        }

        public void set(RubyObject value, String id, RubyObject data, RubyGlobalEntry entry) {
            if (value == data) {
                return;
            }
            if (!(value instanceof RubyIO)) {
                entry.setData(value);
                return;
            }
            ((RubyIO)value).checkWriteable();
            entry.setData(value);
            ((RubyIO)value).setAsRubyErrorStream();
        }
    }

    private static class StdOutSetter
    implements RubyGlobalEntry.SetterMethod {
        private StdOutSetter() {
        }

        public void set(RubyObject value, String id, RubyObject data, RubyGlobalEntry entry) {
            if (value == data) {
                return;
            }
            if (!(value instanceof RubyIO)) {
                entry.setData(value);
                return;
            }
            ((RubyIO)value).checkWriteable();
            entry.setData(value);
            ((RubyIO)value).setAsRubyOutputStream();
        }
    }

    private static class StdInSetter
    implements RubyGlobalEntry.SetterMethod {
        private StdInSetter() {
        }

        public void set(RubyObject value, String id, RubyObject data, RubyGlobalEntry entry) {
            if (value == data) {
                return;
            }
            if (!(value instanceof RubyIO)) {
                entry.setData(value);
                return;
            }
            ((RubyIO)value).checkReadable();
            entry.setData(value);
            ((RubyIO)value).setAsRubyInputStream();
        }
    }

    private static class LastlineAccessor
    implements RubyGlobalEntry.GetterMethod,
    RubyGlobalEntry.SetterMethod {
        private LastlineAccessor() {
        }

        public RubyObject get(String id, RubyObject value, RubyGlobalEntry entry) {
            return entry.getRuby().getParserHelper().getLastline();
        }

        public void set(RubyObject value, String id, RubyObject data, RubyGlobalEntry entry) {
            entry.getRuby().getParserHelper().setLastline(value);
        }
    }

    private static class SafeAccessor
    implements RubyGlobalEntry.GetterMethod,
    RubyGlobalEntry.SetterMethod {
        private SafeAccessor() {
        }

        public RubyObject get(String id, RubyObject value, RubyGlobalEntry entry) {
            return RubyFixnum.newFixnum(entry.getRuby(), entry.getRuby().getSafeLevel());
        }

        public void set(RubyObject value, String id, RubyObject data, RubyGlobalEntry entry) {
            Ruby ruby = entry.getRuby();
            int level = RubyFixnum.fix2int(value);
            if (level < ruby.getSafeLevel()) {
                throw new SecurityException("tried to downgrade level from " + ruby.getSafeLevel() + " to " + level);
            }
            ruby.setSafeLevel(level);
        }
    }

    private static class StringSetter
    implements RubyGlobalEntry.SetterMethod {
        private StringSetter() {
        }

        public void set(RubyObject value, String id, RubyObject data, RubyGlobalEntry entry) {
            if (!(value instanceof RubyString)) {
                throw new TypeError(entry.getRuby(), "value of " + id + " must be a String");
            }
            entry.setData(value);
        }
    }

    private static class ErrorInfoSetter
    implements RubyGlobalEntry.SetterMethod {
        private ErrorInfoSetter() {
        }

        public void set(RubyObject value, String id, RubyObject data, RubyGlobalEntry entry) {
            if (!value.isNil() && value.kind_of(entry.getRuby().getClasses().getExceptionClass()).isFalse()) {
                throw new TypeError(entry.getRuby(), "assigning non-exception to $!");
            }
            entry.setData(value);
        }
    }

    private static class LineNumberSetter
    implements RubyGlobalEntry.SetterMethod {
        private LineNumberSetter() {
        }

        public void set(RubyObject value, String id, RubyObject data, RubyGlobalEntry entry) {
            ((RubyArgsFile)entry.getRuby().getGlobalVar("$<")).setCurrentLineNumber(RubyFixnum.fix2int(value));
            entry.setData(value);
        }
    }
}

