/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.ref.SoftReference;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIncludedClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RubyArgumentException;
import org.jruby.exceptions.RubyBugException;
import org.jruby.exceptions.RubyFrozenException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.TypeError;
import org.jruby.nodes.MethodNode;
import org.jruby.nodes.Node;
import org.jruby.nodes.ZSuperNode;
import org.jruby.runtime.CacheEntry;
import org.jruby.runtime.Callback;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ReflectionCallbackMethod;
import org.jruby.runtime.RubyBlock;
import org.jruby.util.RubyHashMap;
import org.jruby.util.RubyMap;
import org.jruby.util.RubyMapMethod;
import org.jruby.util.RubyPointer;

public class RubyObject {
    protected transient Ruby ruby;
    private RubyClass rubyClass;
    private RubyMap instanceVariables;
    private boolean frozen;
    private boolean taint;
    static /* synthetic */ Class class$org$jruby$RubyObject;
    static /* synthetic */ Class class$org$jruby$RubySymbol;
    static /* synthetic */ Class array$Lorg$jruby$RubyObject;
    static /* synthetic */ Class class$org$jruby$RubyModule;
    static /* synthetic */ Class class$org$jruby$RubyString;

    public RubyObject(Ruby ruby) {
        this(ruby, null, false);
    }

    public RubyObject(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, true);
    }

    public RubyObject(Ruby ruby, RubyClass rubyClass, boolean objectSpace) {
        this.ruby = ruby;
        this.rubyClass = rubyClass;
        this.instanceVariables = new RubyHashMap();
        this.frozen = false;
        this.taint = false;
        if (objectSpace) {
            ruby.objectSpace.add(new SoftReference<RubyObject>(this));
        }
    }

    public static RubyObject nilObject(Ruby ruby) {
        if (ruby.getNil() != null) {
            return ruby.getNil();
        }
        return new RubyObject(ruby){

            public boolean isNil() {
                return true;
            }
        };
    }

    public Class getJavaClass() {
        return class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject;
    }

    public int hashCode() {
        return RubyNumeric.fix2int(this.funcall("hash"));
    }

    public boolean equals(Object other) {
        return other == this || other instanceof RubyObject && this.funcall("==", (RubyObject)other).isTrue();
    }

    public String toString() {
        return this.to_s().getValue();
    }

    public Ruby getRuby() {
        return this.ruby;
    }

    public RubyMap getInstanceVariables() {
        return this.instanceVariables;
    }

    public void setInstanceVariables(RubyMap instanceVariables) {
        this.instanceVariables = instanceVariables;
    }

    public RubyClass getRubyClass() {
        if (this.isNil()) {
            return this.getRuby().getClasses().getNilClass();
        }
        return this.rubyClass;
    }

    public void setRubyClass(RubyClass rubyClass) {
        this.rubyClass = rubyClass;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public boolean isTaint() {
        return this.taint;
    }

    public void setTaint(boolean taint) {
        this.taint = taint;
    }

    public boolean isNil() {
        return false;
    }

    public boolean isTrue() {
        return !this.isNil();
    }

    public boolean isFalse() {
        return this.isNil();
    }

    public static void createObjectClass(RubyModule kernelModule) {
        ReflectionCallbackMethod clone = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "rbClone");
        ReflectionCallbackMethod dup = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "dup");
        ReflectionCallbackMethod equal = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod respond_to = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "respond_to", class$org$jruby$RubySymbol == null ? (class$org$jruby$RubySymbol = RubyObject.class$("org.jruby.RubySymbol")) : class$org$jruby$RubySymbol);
        ReflectionCallbackMethod extend = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "extend", array$Lorg$jruby$RubyObject == null ? (array$Lorg$jruby$RubyObject = RubyObject.class$("[Lorg.jruby.RubyObject;")) : array$Lorg$jruby$RubyObject, true);
        ReflectionCallbackMethod freeze = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "freeze");
        ReflectionCallbackMethod frozen = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "frozen");
        ReflectionCallbackMethod id = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "id");
        ReflectionCallbackMethod inspect = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "inspect");
        ReflectionCallbackMethod instance_eval = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "instance_eval", array$Lorg$jruby$RubyObject == null ? (array$Lorg$jruby$RubyObject = RubyObject.class$("[Lorg.jruby.RubyObject;")) : array$Lorg$jruby$RubyObject, true);
        ReflectionCallbackMethod instance_of = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "instance_of", class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyObject.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule);
        ReflectionCallbackMethod kind_of = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "kind_of", class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyObject.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule);
        ReflectionCallbackMethod method = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "method", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod methods = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "methods");
        ReflectionCallbackMethod private_methods = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "private_methods");
        ReflectionCallbackMethod protected_methods = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "protected_methods");
        ReflectionCallbackMethod taint = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "taint");
        ReflectionCallbackMethod tainted = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "tainted");
        ReflectionCallbackMethod to_a = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "to_a");
        ReflectionCallbackMethod to_s = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "to_s");
        ReflectionCallbackMethod type = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "type");
        ReflectionCallbackMethod untaint = new ReflectionCallbackMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "untaint");
        kernelModule.defineMethod("=~", CallbackFactory.getFalseMethod());
        kernelModule.defineMethod("==", equal);
        kernelModule.defineMethod("respond_to?", respond_to);
        kernelModule.defineMethod("class", type);
        kernelModule.defineMethod("clone", clone);
        kernelModule.defineMethod("dup", dup);
        kernelModule.defineMethod("eql?", equal);
        kernelModule.defineMethod("extend", extend);
        kernelModule.defineMethod("freeze", freeze);
        kernelModule.defineMethod("frozen?", frozen);
        kernelModule.defineMethod("hash", id);
        kernelModule.defineMethod("id", id);
        kernelModule.defineMethod("__id__", id);
        kernelModule.defineMethod("inspect", inspect);
        kernelModule.defineMethod("instance_eval", instance_eval);
        kernelModule.defineMethod("instance_of?", instance_of);
        kernelModule.defineMethod("is_a?", kind_of);
        kernelModule.defineMethod("kind_of?", kind_of);
        kernelModule.defineMethod("method", method);
        kernelModule.defineMethod("methods", methods);
        kernelModule.defineMethod("private_methods", private_methods);
        kernelModule.defineMethod("protected_methods", protected_methods);
        kernelModule.defineMethod("public_methods", methods);
        kernelModule.defineMethod("nil?", CallbackFactory.getFalseMethod());
        kernelModule.defineMethod("send", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "send", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyObject.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        kernelModule.defineMethod("__send__", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "send", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyObject.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        kernelModule.defineMethod("taint", taint);
        kernelModule.defineMethod("tainted?", tainted);
        kernelModule.defineMethod("to_a", to_a);
        kernelModule.defineMethod("to_s", to_s);
        kernelModule.defineMethod("type", type);
        kernelModule.defineMethod("untaint", untaint);
        kernelModule.defineAlias("===", "==");
        kernelModule.defineAlias("equal?", "==");
        Ruby ruby = kernelModule.getRuby();
        ruby.defineGlobalFunction("method_missing", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "method_missing", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
    }

    protected int argCount(RubyObject[] args, int min, int max) {
        int len = args.length;
        if (len < min || max > -1 && len > max) {
            throw new RubyArgumentException(this.getRuby(), "Wrong # of arguments for method. " + args.length + " is not in Range " + min + ".." + max);
        }
        return len;
    }

    protected RubyBoolean toBoolean(boolean value) {
        return value ? this.ruby.getTrue() : this.ruby.getFalse();
    }

    public boolean isSpecialConst() {
        return this.isNil();
    }

    private RubyClass getSpecialSingleton() {
        RubyClass rubyClass = this.getRubyClass();
        if (!rubyClass.isSingleton()) {
            rubyClass = rubyClass.newSingletonClass();
            rubyClass.attachSingletonClass(this);
        }
        return rubyClass;
    }

    public RubyClass getSingletonClass() {
        if (this.isSpecialConst()) {
            if (this.isNil() || this.isTrue() || this.isFalse()) {
                return this.getSpecialSingleton();
            }
            throw new RubyBugException("unknown immediate " + this.toString());
        }
        RubyClass type = null;
        if (this.getRubyClass().isSingleton()) {
            type = this.getRubyClass();
        } else {
            type = this.getRubyClass().newSingletonClass();
            this.setRubyClass(type);
            type.attachSingletonClass(this);
        }
        type.setTaint(this.isTaint());
        type.setFrozen(this.isFrozen());
        return type;
    }

    public void defineSingletonMethod(String name, Callback method) {
        this.getSingletonClass().defineMethod(name, method);
    }

    protected void setupObject(RubyClass rubyClass) {
        this.setRubyClass(rubyClass);
    }

    protected void setupClone(RubyObject obj) {
        this.setRubyClass(obj.getRubyClass().getSingletonClassClone());
        this.getRubyClass().attachSingletonClass(this);
    }

    protected void infectObject(RubyObject obj) {
        if (obj.isTaint()) {
            this.setTaint(true);
        }
    }

    public RubyObject funcall(String name, RubyObject[] args) {
        return this.funcall(name, new RubyPointer(args));
    }

    public RubyObject funcall(String name, RubyPointer args) {
        return this.getRubyClass().call(this, name, args, 1);
    }

    public RubyObject funcall(String name) {
        return this.funcall(name, (RubyPointer)null);
    }

    public RubyObject funcall3(String name, RubyPointer args) {
        return this.getRubyClass().call(this, name, args, 0);
    }

    public RubyObject funcall3(String name, RubyObject[] args) {
        return this.funcall3(name, new RubyPointer(args));
    }

    public RubyObject funcall(String name, RubyObject arg) {
        return this.funcall(name, new RubyPointer(new RubyObject[]{arg}));
    }

    public RubyObject getInstanceVar(String name) {
        RubyObject value;
        if (this.getInstanceVariables() != null && (value = (RubyObject)this.getInstanceVariables().get(name)) != null) {
            return value;
        }
        return this.getRuby().getNil();
    }

    public RubyObject setInstanceVar(String name, RubyObject value) {
        if (this.isTaint() && this.getRuby().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't modify instance variable");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuby(), "");
        }
        if (this.getInstanceVariables() == null) {
            this.setInstanceVariables(new RubyHashMap());
        }
        this.getInstanceVariables().put(name, value);
        return value;
    }

    public boolean isInstanceVarDefined(String name) {
        return this.getInstanceVariables() != null && this.getInstanceVariables().get(name) != null;
    }

    public RubyModule getClassVarSingleton() {
        return this.getRubyClass();
    }

    public RubyObject eval(Node n) {
        return n == null ? this.getRuby().getNil() : n.eval(this.getRuby(), this);
    }

    public RubyObject evalNode(Node n) {
        Node beginTree = this.ruby.getParserHelper().getEvalTreeBegin();
        this.ruby.getParserHelper().setEvalTreeBegin(null);
        if (beginTree != null) {
            this.eval(beginTree);
        }
        if (n == null) {
            return this.getRuby().getNil();
        }
        return this.eval(n);
    }

    public void callInit(RubyObject[] args) {
        this.ruby.getIter().push(this.ruby.isBlockGiven() ? 1 : 0);
        this.funcall("initialize", args);
        this.ruby.getIter().pop();
    }

    public void extendObject(RubyModule module) {
        this.getSingletonClass().includeModule(module);
    }

    public String toId() {
        throw new TypeError(this.getRuby(), this.inspect().getValue() + " is not a symbol");
    }

    public RubyObject convertType(Class type, String className, String method) {
        if (type.isAssignableFrom(this.getClass())) {
            return this;
        }
        RubyObject result = null;
        try {
            result = this.funcall(method);
        }
        catch (NameError rnExcptn) {
            throw new TypeError(this.getRuby(), "failed to convert " + this.getRubyClass().toName() + " into " + className);
        }
        if (!type.isAssignableFrom(result.getClass())) {
            throw new TypeError(this.getRuby(), this.getRubyClass().toName() + "#" + method + " should return " + className);
        }
        return result;
    }

    public void checkSafeString() {
        if (this.getRuby().getSafeLevel() > 0 && this.isTaint()) {
            if (this.getRuby().getRubyFrame().getLastFunc() != null) {
                throw new RubySecurityException(this.getRuby(), "Insecure operation - " + this.getRuby().getRubyFrame().getLastFunc());
            }
            throw new RubySecurityException(this.getRuby(), "Insecure operation: -r");
        }
        this.getRuby().secure(4);
        if (!(this instanceof RubyString)) {
            throw new TypeError(this.getRuby(), "wrong argument type " + this.getRubyClass().toName() + " (expected String)");
        }
    }

    public RubyObject specificEval(RubyModule mod, RubyObject[] args) {
        if (this.getRuby().isBlockGiven()) {
            if (args.length > 0) {
                throw new RubyArgumentException(this.getRuby(), "wrong # of arguments (" + args.length + " for 0)");
            }
            return this.yieldUnder(mod);
        }
        if (args.length == 0) {
            throw new RubyArgumentException(this.getRuby(), "block not supplied");
        }
        if (args.length > 3) {
            String lastFuncName = this.ruby.getRubyFrame().getLastFunc();
            throw new RubyArgumentException(this.getRuby(), "wrong # of arguments: " + lastFuncName + "(src) or " + lastFuncName + "{..}");
        }
        RubyObject file = args.length > 1 ? args[1] : RubyString.newString(this.getRuby(), "(eval)");
        RubyObject line = args.length > 2 ? args[2] : RubyFixnum.one(this.getRuby());
        return this.evalUnder(mod, args[0], file, line);
    }

    public RubyObject evalUnder(RubyModule under, RubyObject src, RubyObject file, RubyObject line) {
        return under.executeUnder(new Callback(){

            public RubyObject execute(RubyObject self, RubyObject[] args, Ruby ruby) {
                return args[0].eval(args[1], ruby.getNil(), ((RubyString)args[2]).getValue(), RubyNumeric.fix2int(args[3]));
            }
        }, new RubyObject[]{this, src, file, line});
    }

    public RubyObject yieldUnder(RubyModule under) {
        return under.executeUnder(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RubyObject execute(RubyObject self, RubyObject[] args, Ruby ruby) {
                if ((ruby.getBlock().flags & 2) != 0) {
                    RubyBlock oldBlock = ruby.getBlock();
                    RubyBlock block = ruby.getBlock();
                    block.frame.setCbase(ruby.getRubyFrame().getCbase());
                    ruby.setBlock(block);
                    RubyObject result = null;
                    try {
                        result = ruby.yield0(args[0], args[0], ruby.getRubyClass(), false);
                        Object var8_7 = null;
                        ruby.setBlock(oldBlock);
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        ruby.setBlock(oldBlock);
                        throw throwable;
                    }
                    return result;
                }
                ruby.getBlock().frame.setCbase(ruby.getRubyFrame().getCbase());
                return ruby.yield0(args[0], args[0], ruby.getRubyClass(), false);
            }
        }, new RubyObject[]{this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyObject eval(RubyObject src, RubyObject scope, String file, int line) {
        String fileSave = this.ruby.getSourceFile();
        int lineSave = this.ruby.getSourceLine();
        int iter = this.ruby.getRubyFrame().getIter();
        if (file == null) {
            file = this.ruby.getSourceFile();
            line = this.ruby.getSourceLine();
        }
        if (scope.isNil() && this.ruby.getRubyFrame().getPrev() != null) {
            this.ruby.getRubyFrame().setIter(this.ruby.getRubyFrame().getPrev().getIter());
        }
        this.getRuby().pushClass();
        this.ruby.setRubyClass(this.ruby.getCBase());
        this.ruby.setInEval(this.ruby.getInEval() + 1);
        if (this.ruby.getRubyClass().isIncluded()) {
            this.ruby.setRubyClass(((RubyIncludedClass)this.ruby.getRubyClass()).getDelegate());
        }
        RubyObject result = this.getRuby().getNil();
        try {
            try {
                Node node = this.getRuby().getRubyParser().compileString(file, src, line);
                result = this.evalNode(node);
            }
            catch (RaiseException rExcptn) {
                Object var11_12 = null;
                this.ruby.popClass();
                this.ruby.setInEval(this.ruby.getInEval());
                if (scope.isNil()) {
                    this.ruby.getRubyFrame().setIter(iter);
                }
                this.ruby.setSourceFile(fileSave);
                this.ruby.setSourceLine(lineSave);
            }
            Object var11_11 = null;
            this.ruby.popClass();
            this.ruby.setInEval(this.ruby.getInEval());
            if (scope.isNil()) {
                this.ruby.getRubyFrame().setIter(iter);
            }
            this.ruby.setSourceFile(fileSave);
            this.ruby.setSourceLine(lineSave);
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.ruby.popClass();
            this.ruby.setInEval(this.ruby.getInEval());
            if (scope.isNil()) {
                this.ruby.getRubyFrame().setIter(iter);
            }
            this.ruby.setSourceFile(fileSave);
            this.ruby.setSourceLine(lineSave);
            throw throwable;
        }
        return result;
    }

    public RubyBoolean equal(RubyObject obj) {
        return RubyBoolean.newBoolean(this.getRuby(), this == obj);
    }

    public RubyBoolean respond_to(RubySymbol sym) {
        CacheEntry ent = this.getRuby().getMethodCache().getEntry(this.getRubyClass(), sym.toId());
        if (ent != null) {
            return this.ruby.getTrue();
        }
        MethodNode meth = this.getRubyClass().searchMethod(sym.toId());
        if (meth != null && !meth.equals(this.ruby.getNil())) {
            return this.ruby.getTrue();
        }
        return this.ruby.getFalse();
    }

    public RubyObject id() {
        return RubyFixnum.newFixnum(this.getRuby(), System.identityHashCode(this));
    }

    public RubyClass type() {
        return this.getRubyClass().getRealClass();
    }

    public RubyObject rbClone() {
        RubyObject clone = new RubyObject(this.getRuby(), this.getRubyClass());
        clone.setupClone(this);
        clone.setInstanceVariables(this.getInstanceVariables().cloneRubyMap());
        return clone;
    }

    public RubyObject dup() {
        RubyObject dup = this.funcall("clone");
        if (!dup.getClass().equals(this.getClass())) {
            throw new TypeError(this.getRuby(), "duplicated object must be same type");
        }
        if (!dup.isSpecialConst()) {
            dup.setRubyClass(this.type());
            dup.infectObject(this);
        }
        return dup;
    }

    public RubyBoolean tainted() {
        if (this.isTaint()) {
            return this.getRuby().getTrue();
        }
        return this.getRuby().getFalse();
    }

    public RubyObject taint() {
        this.getRuby().secure(4);
        if (!this.isTaint()) {
            if (this.isFrozen()) {
                throw new RubyFrozenException(this.getRuby(), "object");
            }
            this.setTaint(true);
        }
        return this;
    }

    public RubyObject untaint() {
        this.getRuby().secure(3);
        if (this.isTaint()) {
            if (this.isFrozen()) {
                throw new RubyFrozenException(this.getRuby(), "object");
            }
            this.setTaint(false);
        }
        return this;
    }

    public RubyObject freeze() {
        if (this.getRuby().getSafeLevel() >= 4 && this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't freeze object");
        }
        this.setFrozen(true);
        return this;
    }

    public RubyBoolean frozen() {
        return RubyBoolean.newBoolean(this.getRuby(), this.isFrozen());
    }

    public RubyString inspect() {
        return (RubyString)this.funcall("to_s");
    }

    public RubyBoolean instance_of(RubyModule type) {
        return RubyBoolean.newBoolean(this.getRuby(), this.type() == type);
    }

    public RubyBoolean kind_of(RubyModule type) {
        RubyClass currType = this.getRubyClass();
        while (currType != null) {
            if (currType == type || currType.getMethods().keySet().retainAll(type.getMethods().keySet())) {
                return this.getRuby().getTrue();
            }
            currType = currType.getSuperClass();
        }
        return this.getRuby().getFalse();
    }

    public RubyObject methods() {
        return this.getRubyClass().instance_methods(new RubyObject[]{this.getRuby().getTrue()});
    }

    public RubyObject protected_methods() {
        return this.getRubyClass().protected_instance_methods(new RubyObject[]{this.getRuby().getTrue()});
    }

    public RubyObject private_methods() {
        return this.getRubyClass().private_instance_methods(new RubyObject[]{this.getRuby().getTrue()});
    }

    public RubyArray singleton_methods() {
        RubyArray ary = RubyArray.newArray(this.getRuby());
        RubyClass type = this.getRubyClass();
        while (type != null && type.isSingleton()) {
            type.getMethods().foreach(new RubyMapMethod(){

                public int execute(Object key, Object value, Object arg) {
                    RubyString name = RubyString.newString(RubyObject.this.getRuby(), (String)key);
                    if ((((MethodNode)value).getNoex() & 6) == 0) {
                        if (((RubyArray)arg).includes(name).isFalse()) {
                            if (((MethodNode)value).getBodyNode() == null) {
                                ((RubyArray)arg).push(RubyObject.this.getRuby().getNil());
                            }
                            ((RubyArray)arg).push(name);
                        }
                    } else if (((MethodNode)value).getBodyNode() instanceof ZSuperNode) {
                        ((RubyArray)arg).push(RubyObject.this.getRuby().getNil());
                        ((RubyArray)arg).push(name);
                    }
                    return 0;
                }
            }, ary);
            type = type.getSuperClass();
        }
        ary.compact_bang();
        return ary;
    }

    public RubyObject method(RubyObject symbol) {
        return this.getRubyClass().newMethod(this, symbol.toId(), this.getRuby().getClasses().getMethodClass());
    }

    public RubyArray to_a() {
        return RubyArray.newArray(this.getRuby(), this);
    }

    public RubyString to_s() {
        String cname = this.getRubyClass().toName();
        RubyString str = RubyString.newString(this.getRuby(), "");
        str.setValue("#<" + cname + ":0x" + Integer.toHexString(System.identityHashCode(this)) + ">");
        str.setTaint(this.isTaint());
        return str;
    }

    public RubyObject instance_eval(RubyObject[] args) {
        return this.specificEval(this.getSingletonClass(), args);
    }

    public RubyObject extend(RubyObject[] args) {
        if (args.length == 0) {
            throw new RubyArgumentException(this.ruby, "wrong # of arguments");
        }
        int i = 0;
        while (i < args.length) {
            args[i].funcall("extend_object", this);
            ++i;
        }
        return this;
    }

    public RubyObject method_missing(RubyObject symbol, RubyObject[] args) {
        Ruby ruby = this.getRuby();
        throw new NameError(ruby, ruby.getSourceFile() + ":" + ruby.getSourceLine() + " undefined method '" + symbol.toId() + "' for " + this.type().toName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyObject send(RubyString method, RubyObject[] args) {
        try {
            this.getRuby().getIter().push(this.getRuby().isBlockGiven() ? 1 : 0);
            RubyObject rubyObject = this.getRubyClass().call(this, method.getValue(), new RubyPointer(args), 1);
            Object var5_4 = null;
            this.getRuby().getIter().pop();
            return rubyObject;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getRuby().getIter().pop();
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

