/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyJavaObject;
import org.jruby.RubyObject;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RubyArgumentException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Callback;

public class JavaConstructor
implements Callback {
    private Constructor[] constructors = null;

    public JavaConstructor(Constructor[] constructors) {
        this.constructors = constructors;
    }

    public RubyObject execute(RubyObject recv, RubyObject[] args, Ruby ruby) {
        Constructor constructor;
        LinkedList<Constructor> executeConstructors = new LinkedList<Constructor>(Arrays.asList(this.constructors));
        int argsLength = args != null ? args.length : 0;
        Iterator iter = executeConstructors.iterator();
        while (iter.hasNext()) {
            constructor = (Constructor)iter.next();
            if (constructor.getParameterTypes().length == argsLength) continue;
            iter.remove();
        }
        iter = executeConstructors.iterator();
        block6: while (iter.hasNext()) {
            constructor = (Constructor)iter.next();
            int i = 0;
            while (i < constructor.getParameterTypes().length) {
                if (!JavaUtil.isCompatible(args[i], constructor.getParameterTypes()[i])) {
                    iter.remove();
                    continue block6;
                }
                ++i;
            }
        }
        if (executeConstructors.isEmpty()) {
            throw new RubyArgumentException(ruby, "wrong arguments.");
        }
        constructor = executeConstructors.getFirst();
        Object[] newArgs = new Object[argsLength];
        int i = 0;
        while (i < argsLength) {
            newArgs[i] = JavaUtil.convertRubyToJava(ruby, args[i], constructor.getParameterTypes()[i]);
            ++i;
        }
        try {
            Object javaValue = constructor.newInstance(newArgs);
            RubyJavaObject javaObject = new RubyJavaObject(ruby, (RubyClass)recv, javaValue);
            javaObject.callInit(args);
            return javaObject;
        }
        catch (IllegalAccessException ex) {
            throw new RaiseException(ruby, "RuntimeError", ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new RaiseException(ruby, "RuntimeError", ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RaiseException(ruby, "RuntimeError", ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            throw new RaiseException(ruby, "RuntimeError", ex.getMessage());
        }
    }
}

