/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;

public class ArrayNode
extends Node {
    public ArrayNode(Node headNode, int aLength, Node nextNode) {
        super(42, (Object)headNode, aLength, (Object)nextNode);
    }

    public RubyObject eval(Ruby ruby, RubyObject self) {
        return this.getRubyArray(ruby, self);
    }

    public RubyArray getRubyArray(Ruby ruby, RubyObject self) {
        return new RubyArray(ruby, this.getArrayList(ruby, self), true);
    }

    public ArrayList getArrayList(Ruby ruby, RubyObject self) {
        ArrayList<RubyObject> ary = new ArrayList<RubyObject>(this.getALength());
        Node node = this;
        while (node != null) {
            ary.add(node.getHeadNode().eval(ruby, self));
            node = node.getNextNode();
        }
        return ary;
    }

    public RubyObject[] getArray(Ruby ruby, RubyObject self) {
        ArrayList ary = this.getArrayList(ruby, self);
        return ary.toArray(new RubyObject[ary.size()]);
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitArrayNode(this);
    }
}

