/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.TypeError;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;
import org.jruby.nodes.ScopeNode;

public class ClassNode
extends Node {
    public ClassNode(String classNameId, Node bodyNode, Node superNode) {
        super(80, (Object)classNameId, (Object)bodyNode, (Object)superNode);
    }

    public RubyObject eval(Ruby ruby, RubyObject self) {
        if (ruby.getRubyClass() == null) {
            throw new TypeError(ruby, "no outer class/module");
        }
        RubyClass superClass = null;
        if (this.getSuperNode() != null) {
            superClass = this.getSuperClass(ruby, self, this.getSuperNode());
        }
        RubyClass rubyClass = null;
        if (ruby.getRubyClass().isConstantDefined(this.getClassNameId())) {
            rubyClass = (RubyClass)ruby.getRubyClass().getConstant(this.getClassNameId());
        }
        if (rubyClass != null) {
            if (!rubyClass.isClass()) {
                throw new TypeError(ruby, this.getClassNameId() + " is not a class");
            }
            if (superClass != null) {
                RubyClass tmp = rubyClass.getSuperClass();
                if (((RubyModule)tmp).isSingleton()) {
                    tmp = tmp.getSuperClass();
                }
                while (tmp.isIncluded()) {
                    tmp = tmp.getSuperClass();
                }
                if (tmp != superClass) {
                    superClass = tmp;
                    if (superClass == null) {
                        superClass = ruby.getClasses().getObjectClass();
                    }
                    rubyClass = ruby.defineClass(this.getClassNameId(), superClass);
                    ruby.getRubyClass().setConstant(this.getClassNameId(), rubyClass);
                    rubyClass.setClassPath(ruby.getRubyClass(), this.getClassNameId());
                }
            }
            if (ruby.getSafeLevel() >= 4) {
                throw new RubySecurityException(ruby, "extending class prohibited");
            }
        } else {
            if (superClass == null) {
                superClass = ruby.getClasses().getObjectClass();
            }
            rubyClass = ruby.defineClass(this.getClassNameId(), superClass);
            ruby.getRubyClass().setConstant(this.getClassNameId(), rubyClass);
            rubyClass.setClassPath(ruby.getRubyClass(), this.getClassNameId());
        }
        if (ruby.getWrapper() != null) {
            rubyClass.getSingletonClass().includeModule(ruby.getWrapper());
            rubyClass.includeModule(ruby.getWrapper());
        }
        return ((ScopeNode)this.getBodyNode()).setupModule(ruby, rubyClass);
    }

    public RubyClass getSuperClass(Ruby ruby, RubyObject self, Node node) {
        RubyObject obj = node.eval(ruby, self);
        if (!(obj instanceof RubyClass)) {
            throw new RuntimeException();
        }
        if (((RubyClass)obj).isSingleton()) {
            throw new TypeError(ruby, "can't make subclass of virtual class");
        }
        return (RubyClass)obj;
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitClassNode(this);
    }
}

