/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;
import org.jruby.nodes.types.AssignableNode;

public class MAsgnNode
extends Node
implements AssignableNode {
    public MAsgnNode(Node headNode, Node argsNode) {
        super(24, (Object)headNode, null, (Object)argsNode);
    }

    public RubyObject eval(Ruby ruby, RubyObject self) {
        return this.massign(ruby, self, MAsgnNode.toArray(ruby, self.eval(this.getValueNode())), false);
    }

    private static RubyArray toArray(Ruby ruby, RubyObject value) {
        if (value == null) {
            return RubyArray.newArray(ruby);
        }
        if (!(value instanceof RubyArray)) {
            if (value.respond_to(RubySymbol.newSymbol(ruby, "to_ary")).isTrue()) {
                return (RubyArray)value.funcall("to_ary");
            }
            return RubyArray.newArray(ruby, value);
        }
        return (RubyArray)value;
    }

    public RubyObject massign(Ruby ruby, RubyObject self, RubyArray value, boolean check) {
        Node list = this.getHeadNode();
        int i = 0;
        while (list != null && i < value.getLength()) {
            ((AssignableNode)((Object)list.getHeadNode())).assign(ruby, self, value.entry(i), check);
            list = list.getNextNode();
            ++i;
        }
        if (!check || list != null) {
            // empty if block
        }
        if (this.getArgsNode() != null) {
            if (this.getArgsNode() != Node.MINUS_ONE) {
                if (list == null && i < value.getLength()) {
                    ((AssignableNode)((Object)this.getArgsNode())).assign(ruby, self, value.subseq(i, value.getLength() - i), check);
                } else {
                    ((AssignableNode)((Object)this.getArgsNode())).assign(ruby, self, RubyArray.newArray(ruby), check);
                }
            }
        } else if (check && i < value.getLength()) {
            // empty if block
        }
        while (list != null) {
            ++i;
            ((AssignableNode)((Object)list.getHeadNode())).assign(ruby, self, ruby.getNil(), check);
            list = list.getNextNode();
        }
        return value;
    }

    public void assign(Ruby ruby, RubyObject self, RubyObject value, boolean check) {
        this.massign(ruby, self, MAsgnNode.toArray(ruby, value), check);
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitMAsgnNode(this);
    }
}

