/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;

public class WhenNode
extends Node {
    public WhenNode(Node headNode, Node bodyNode, Node nextNode) {
        super(7, (Object)headNode, (Object)bodyNode, (Object)nextNode);
    }

    public RubyObject eval(Ruby ruby, RubyObject self) {
        for (WhenNode node = this; node != null; node = (WhenNode)node.getNextNode()) {
            Node tag = node.getHeadNode();
            while (tag != null) {
                ruby.setSourceFile(tag.getFile());
                ruby.setSourceLine(tag.getLine());
                if (tag.getHeadNode() instanceof WhenNode) {
                    RubyObject obj = tag.getHeadNode().getHeadNode().eval(ruby, self);
                    if (!(obj instanceof RubyArray)) {
                        obj = RubyArray.newArray(ruby, obj);
                    }
                    int i = 0;
                    while (i < ((RubyArray)obj).getLength()) {
                        if (((RubyArray)obj).entry(i).isTrue()) {
                            return node.getBodyNode().eval(ruby, self);
                        }
                        ++i;
                    }
                } else if (tag.getHeadNode().eval(ruby, self).isTrue()) {
                    return node.getBodyNode().eval(ruby, self);
                }
                tag = tag.getNextNode();
            }
            if (node.getNextNode() instanceof WhenNode) {
                continue;
            }
            return node.getNextNode().eval(ruby, self);
        }
        return ruby.getNil();
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitWhenNode(this);
    }
}

