/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.regexp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jruby.Ruby;
import org.jruby.RubyMatchData;
import org.jruby.RubyObject;
import org.jruby.exceptions.RubyRegexpException;
import org.jruby.regexp.IRegexpAdapter;

public class JDKRegexpAdapter
extends IRegexpAdapter {
    private Pattern pattern;
    private Matcher matcher;
    private int cflags = 8;

    public void compile(Ruby ruby, String regex) throws RubyRegexpException {
        try {
            this.pattern = Pattern.compile(regex, this.cflags);
        }
        catch (PatternSyntaxException e) {
            throw new RubyRegexpException(ruby, e.getMessage());
        }
    }

    public void setCasefold(boolean set) {
        this.cflags = set ? (this.cflags |= 2) : (this.cflags &= 0xFFFFFFFD);
    }

    public boolean getCasefold() {
        return (this.cflags & 2) > 0;
    }

    public void setExtended(boolean set) {
        this.cflags = set ? (this.cflags |= 4) : (this.cflags &= 0xFFFFFFFB);
    }

    public void setMultiline(boolean set) {
        this.cflags = set ? (this.cflags |= 0x20) : (this.cflags &= 0xFFFFFFDF);
    }

    public RubyObject search(Ruby ruby, String target, int startPos) {
        if (this.matcher == null) {
            this.matcher = this.pattern.matcher(target);
        } else {
            this.matcher.reset(target);
        }
        if (this.matcher.find(startPos)) {
            int count = this.matcher.groupCount() + 1;
            int[] begin = new int[count];
            int[] end = new int[count];
            int i = 0;
            while (i < count) {
                begin[i] = this.matcher.start(i);
                end[i] = this.matcher.end(i);
                ++i;
            }
            return new RubyMatchData(ruby, target, begin, end);
        }
        return ruby.getNil();
    }
}

