/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.RubyString;

public class TestRubyBase
extends TestCase {
    private PipedInputStream pipeIn;
    private PipedOutputStream pos;
    private BufferedReader in;
    protected Ruby ruby;
    private PrintStream out;

    public TestRubyBase(String name) {
        super(name);
    }

    protected String eval(String script) {
        this.pipeIn = new PipedInputStream();
        this.in = new BufferedReader(new InputStreamReader(this.pipeIn));
        String output = null;
        StringBuffer result = new StringBuffer();
        try {
            this.out = new PrintStream(new PipedOutputStream(this.pipeIn), true);
            RubyIO lStream = new RubyIO(this.ruby);
            lStream.initIO(null, this.out, null);
            this.ruby.setGlobalVar("$stdout", lStream);
            this.ruby.setGlobalVar("$>", lStream);
            lStream = (RubyIO)this.ruby.getGlobalVar("$stderr");
            lStream.initIO(null, this.out, null);
            this.ruby.setGlobalVar("$stderr", lStream);
            new EvalThread("test", script).start();
            while ((output = this.in.readLine()) != null) {
                result.append(output);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return result.toString();
    }

    public void tearDown() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class EvalThread
    extends Thread {
        private RubyString name;
        private RubyString script;

        EvalThread(String name, String script) {
            this.name = RubyString.newString(TestRubyBase.this.ruby, name);
            this.script = RubyString.newString(TestRubyBase.this.ruby, script);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                TestRubyBase.this.ruby.getRuntime().loadScript(this.name, this.script, false);
                Object var2_1 = null;
                TestRubyBase.this.out.close();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                TestRubyBase.this.out.close();
                throw throwable;
            }
        }
    }
}

