/*
 * Decompiled with CFR 0.152.
 */
package org.ablaf.internal.lexer;

import org.ablaf.common.ISourcePosition;
import org.ablaf.internal.lexer.DefaultLexerPosition;
import org.ablaf.lexer.ILexerSource;
import org.ablaf.lexer.ILexerSupport;

public class DefaultLexerSupport
implements ILexerSupport {
    private ILexerSource source;
    private int line = 0;
    private int[] lineOffset = new int[100];

    public DefaultLexerSupport(ILexerSource source) {
        this.source = source;
    }

    public char read() {
        char c = this.source.read();
        if (c == '\n') {
            if (this.line >= this.lineOffset.length) {
                int[] _lineOffset = new int[this.lineOffset.length + 100];
                System.arraycopy(this.lineOffset, 0, _lineOffset, 0, this.lineOffset.length);
                this.lineOffset = _lineOffset;
            }
            this.lineOffset[this.line] = this.source.getOffset();
            ++this.line;
        }
        return c;
    }

    public char unread() {
        char c = this.source.unread();
        if (c == '\n') {
            --this.line;
        }
        return c;
    }

    public char getNext() {
        this.read();
        return this.unread();
    }

    public boolean isEOF() {
        return this.getNext() == '\u0000';
    }

    public boolean isEOL() {
        return this.getNext() == '\n';
    }

    public boolean isNext(char c) {
        return this.getNext() == c;
    }

    public String readHex(int maxLen) {
        StringBuffer buffer = new StringBuffer(maxLen);
        int i = 0;
        while (i < maxLen) {
            char c = this.read();
            if (DefaultLexerSupport.isHex(c)) {
                buffer.append(c);
            } else {
                if (c == '\u0000') {
                    return null;
                }
                this.unread();
            }
            ++i;
        }
        return buffer.toString();
    }

    public String readOct(int maxLen) {
        StringBuffer buffer = new StringBuffer(maxLen);
        int i = 0;
        while (i < maxLen) {
            char c = this.read();
            if (DefaultLexerSupport.isOct(c)) {
                buffer.append(c);
            } else {
                if (c == '\u0000') {
                    return null;
                }
                this.unread();
            }
            ++i;
        }
        return buffer.toString();
    }

    public char getCharAt(int idx) {
        char c = '\u0000';
        int i = 0;
        while (i < idx) {
            c = this.read();
            ++i;
        }
        int i2 = 0;
        while (i2 < idx) {
            this.unread();
            ++i2;
        }
        return c;
    }

    public ISourcePosition getPosition() {
        int col = this.source.getOffset();
        if (this.line > 0) {
            col -= this.lineOffset[this.line - 1];
        }
        return new DefaultLexerPosition(this.source.getSourceName(), this.line + 1, col);
    }

    public boolean isNext(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != this.read()) {
                while (i >= 0) {
                    this.unread();
                    --i;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public String readLine() {
        StringBuffer sb = new StringBuffer();
        char c = this.read();
        while (c != '\n') {
            sb.append(c);
            c = this.read();
        }
        return sb.toString();
    }

    public char getLastRead() {
        char last = this.unread();
        this.read();
        return last;
    }

    public void unread(int n) {
        int i = 0;
        while (i < n) {
            this.unread();
            ++i;
        }
    }

    private static final boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    private static final boolean isOct(char c) {
        return '0' <= c && c <= '7';
    }
}

