/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.ablaf.ast.INode;
import org.ablaf.common.ISourcePosition;
import org.ablaf.internal.lexer.DefaultLexerPosition;
import org.ablaf.lexer.LexerFactory;
import org.ablaf.parser.IParser;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyClasses;
import org.jruby.RubyFixnum;
import org.jruby.RubyGlobal;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.ZeroArgNode;
import org.jruby.common.RubyErrorHandler;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.BreakJump;
import org.jruby.exceptions.LoadError;
import org.jruby.exceptions.NextJump;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RedoJump;
import org.jruby.exceptions.RetryException;
import org.jruby.exceptions.ReturnException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.ThrowJump;
import org.jruby.internal.runtime.methods.IterateMethod;
import org.jruby.internal.runtime.methods.RubyMethodCache;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.IRubyParserResult;
import org.jruby.parser.RubyParserConfiguration;
import org.jruby.runtime.AliasGlobalVariable;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockStack;
import org.jruby.runtime.Callback;
import org.jruby.runtime.Frame;
import org.jruby.runtime.FrameStack;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Namespace;
import org.jruby.runtime.ReadonlyGlobalVariable;
import org.jruby.runtime.RubyExceptions;
import org.jruby.runtime.RubyRuntime;
import org.jruby.runtime.RubyVarmap;
import org.jruby.runtime.Scope;
import org.jruby.runtime.ScopeStack;
import org.jruby.runtime.methods.IMethod;
import org.jruby.util.RubyHashMap;
import org.jruby.util.RubyMap;
import org.jruby.util.RubyStack;
import org.jruby.util.collections.CollectionFactory;
import org.jruby.util.collections.IStack;

public final class Ruby {
    public static final String RUBY_MAJOR_VERSION = "1.6";
    public static final String RUBY_VERSION = "1.6.7";
    private static final String[] REGEXP_ADAPTER;
    private RubyMethodCache methodCache;
    public int stackTraces = 0;
    private RubyMap globalMap;
    public LinkedList objectSpace = new LinkedList();
    public final RubyFixnum[] fixnumCache = new RubyFixnum[256];
    public long randomSeed = 0L;
    public Random random = new Random();
    private int safeLevel = 0;
    private RubyObject nilObject;
    private RubyBoolean trueObject;
    private RubyBoolean falseObject;
    private RubyClasses classes;
    private RubyExceptions exceptions;
    private RubyRuntime runtime = new RubyRuntime(this);
    private RubyObject rubyTopSelf;
    private ScopeStack scope = new ScopeStack(this);
    private Scope topScope = null;
    private RubyVarmap dynamicVars = null;
    private RubyModule rubyClass = null;
    private FrameStack frameStack = new FrameStack(this);
    private Frame topFrame;
    private Namespace namespace;
    private Namespace topNamespace;
    private String sourceFile;
    private int sourceLine;
    private int inEval;
    private boolean verbose;
    private IStack iterStack = CollectionFactory.getInstance().newStack();
    private BlockStack block = new BlockStack(this);
    private RubyModule cBase;
    private int actMethodScope;
    private RubyModule wrapper;
    private RubyStack classStack = new RubyStack(new LinkedList());
    public RubyStack varMapStack = new RubyStack(new LinkedList());
    private boolean initialized = false;
    private JavaSupport javaSupport;
    private Class regexpAdapterClass;
    private IParser parser;

    public ISourcePosition getPosition() {
        return new DefaultLexerPosition(this.getSourceFile(), this.getSourceLine(), 0);
    }

    public Ruby() {
        this.globalMap = new RubyHashMap();
        this.nilObject = RubyObject.nilObject(this);
        this.trueObject = new RubyBoolean(this, true);
        this.falseObject = new RubyBoolean(this, false);
        this.javaSupport = new JavaSupport(this);
        this.methodCache = new RubyMethodCache(this);
    }

    public static Ruby getDefaultInstance(Class regexpAdapterClass) {
        int i = 0;
        while (regexpAdapterClass == null && i < REGEXP_ADAPTER.length) {
            try {
                regexpAdapterClass = Class.forName(REGEXP_ADAPTER[i]);
            }
            catch (ClassNotFoundException cnfExcptn) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            ++i;
        }
        Ruby ruby = new Ruby();
        ruby.setRegexpAdapterClass(regexpAdapterClass);
        ruby.init();
        return ruby;
    }

    public Object evalScript(String script, Class returnClass) {
        RubyObject result = this.evalScript(script);
        return JavaUtil.convertRubyToJava(this, result, returnClass);
    }

    public RubyObject evalScript(String script) {
        return this.getRubyTopSelf().eval(this.compile(script, "<script>", 1));
    }

    public void printException(Exception exception) {
        if (exception instanceof RaiseException) {
            this.getRuntime().printError(((RaiseException)exception).getActException());
        } else if (exception instanceof ThrowJump) {
            this.getRuntime().printError(((ThrowJump)exception).getNameError());
        } else if (exception instanceof BreakJump) {
            this.getRuntime().getErrorStream().println("break without block.");
        } else if (exception instanceof ReturnException) {
            this.getRuntime().getErrorStream().println("return without block.");
        }
    }

    public Class getRegexpAdapterClass() {
        return this.regexpAdapterClass;
    }

    public void setRegexpAdapterClass(Class iRegexpAdapterClass) {
        this.regexpAdapterClass = iRegexpAdapterClass;
    }

    public RubyClasses getClasses() {
        return this.classes;
    }

    public RubyBoolean getTrue() {
        return this.trueObject;
    }

    public RubyBoolean getFalse() {
        return this.falseObject;
    }

    public RubyObject getNil() {
        return this.nilObject;
    }

    public RubyModule getRubyModule(String name) {
        return this.classes.getClass(name);
    }

    public RubyClass getRubyClass(String name) {
        return (RubyClass)this.classes.getClass(name);
    }

    public RubyClass defineClass(String name, RubyClass superClass) {
        if (superClass == null) {
            superClass = this.getClasses().getObjectClass();
        }
        RubyClass newClass = RubyClass.newClass(this, superClass);
        newClass.setName(name);
        newClass.makeMetaClass(superClass.getRubyClass());
        newClass.inheritedBy(superClass);
        this.classes.putClass(name, newClass);
        return newClass;
    }

    public RubyModule defineModule(String name) {
        RubyModule newModule = RubyModule.newModule(this);
        newModule.setName(name);
        this.getClasses().putClass(name, newModule);
        return newModule;
    }

    public void defineGlobalFunction(String name, Callback method) {
        this.getClasses().getKernelModule().defineModuleFunction(name, method);
    }

    public int getSafeLevel() {
        return this.safeLevel;
    }

    public void setSafeLevel(int safeLevel) {
        this.safeLevel = safeLevel;
    }

    public void secure(int level) {
        if (level <= this.safeLevel) {
            throw new RubySecurityException(this, "Insecure operation '" + this.getActFrame().getLastFunc() + "' at level " + this.safeLevel);
        }
    }

    public RubyFixnum getFixnumInstance(long value) {
        return new RubyFixnum(this, value);
    }

    public void defineGlobalConstant(String name, RubyObject value) {
        this.getClasses().getObjectClass().defineConstant(name, value);
    }

    public RubyObject getTopConstant(String id) {
        if (this.getClasses().getClass(id) != null) {
            return this.getClasses().getClass(id);
        }
        return null;
    }

    public boolean isAutoloadDefined(String name) {
        return false;
    }

    public boolean isClassDefined(String name) {
        return this.classes.getClass(name) != null;
    }

    public Iterator globalVariableNames() {
        return this.globalMap.keySet().iterator();
    }

    public boolean isGlobalVarDefined(String name) {
        return this.globalMap.containsKey(name);
    }

    public void undefineGlobalVar(String name) {
        this.globalMap.remove(name);
    }

    public RubyObject setGlobalVar(String name, RubyObject value) {
        GlobalVariable global = (GlobalVariable)this.globalMap.get(name);
        if (global == null) {
            this.globalMap.put(name, new GlobalVariable(this, name, value));
            return value;
        }
        global.set(value);
        return value;
    }

    public RubyObject getGlobalVar(String name) {
        GlobalVariable global = (GlobalVariable)this.globalMap.get(name);
        if (global == null) {
            this.globalMap.put(name, new GlobalVariable(this, name, this.getNil()));
            return this.getNil();
        }
        return global.get();
    }

    public void aliasGlobalVar(String oldName, String newName) {
        if (this.getSafeLevel() >= 4) {
            throw new RubySecurityException(this, "Insecure: can't alias global variable");
        }
        if (!this.globalMap.containsKey(oldName)) {
            this.globalMap.put(oldName, new GlobalVariable(this, oldName, this.getNil()));
        }
        GlobalVariable oldEntry = (GlobalVariable)this.globalMap.get(oldName);
        this.globalMap.put(newName, new AliasGlobalVariable(this, newName, oldEntry));
    }

    public RubyObject yield(RubyObject value) {
        return this.yield0(value, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RubyObject yield0(RubyObject value, RubyObject self, RubyModule klass, boolean acheck) {
        IMethod method;
        if (!this.isBlockGiven()) {
            throw new RaiseException(this, this.getExceptions().getLocalJumpError(), "yield called out of block");
        }
        RubyVarmap.push(this);
        Block actBlock = this.block.getAct();
        this.getFrameStack().push(actBlock.getFrame());
        Namespace oldNamespace = this.getNamespace();
        this.setNamespace(this.getActFrame().getNamespace());
        Scope oldScope = (Scope)this.getScope().getTop();
        this.getScope().setTop(actBlock.getScope());
        this.block.pop();
        this.setDynamicVars(actBlock.getDynamicVars());
        this.pushClass(klass != null ? klass : actBlock.getKlass());
        if (klass == null) {
            self = actBlock.getSelf();
        }
        if (value == null) {
            value = RubyArray.newArray(this, 0L);
        }
        if ((method = actBlock.getMethod()) == null) {
            return this.getNil();
        }
        INode blockVar = actBlock.getVar();
        if (blockVar != null) {
            if (blockVar instanceof ZeroArgNode) {
                if (acheck && value instanceof RubyArray && ((RubyArray)value).getLength() != 0) {
                    throw new ArgumentError(this, "wrong # of arguments (" + ((RubyArray)value).getLength() + " for 0)");
                }
            } else {
                if (!(blockVar instanceof MultipleAsgnNode) && acheck && value instanceof RubyArray && ((RubyArray)value).getLength() == 1) {
                    value = ((RubyArray)value).entry(0L);
                }
                new AssignmentVisitor(this, self).assign(blockVar, value, acheck);
            }
        } else if (acheck && value instanceof RubyArray && ((RubyArray)value).getLength() == 1) {
            value = ((RubyArray)value).entry(0L);
        }
        this.getIterStack().push(actBlock.getIter());
        RubyObject[] args = value instanceof RubyArray ? ((RubyArray)value).toJavaArray() : new RubyObject[]{value};
        try {
            RubyObject rubyObject;
            try {
                while (true) {
                    try {
                        rubyObject = method.execute(this, self, null, args, false);
                        Object var15_14 = null;
                    }
                    catch (RedoJump rExcptn) {
                        continue;
                    }
                    break;
                }
            }
            catch (NextJump nExcptn) {
                RubyObject rubyObject2 = this.getNil();
                Object var15_15 = null;
                this.getIterStack().pop();
                this.popClass();
                RubyVarmap.pop(this);
                this.block.setAct(actBlock);
                this.getFrameStack().pop();
                this.setNamespace(oldNamespace);
                this.getScope().setTop(oldScope);
                return rubyObject2;
            }
            catch (ReturnException rExcptn) {
                RubyObject rubyObject3 = rExcptn.getReturnValue();
                Object var15_16 = null;
                this.getIterStack().pop();
                this.popClass();
                RubyVarmap.pop(this);
                this.block.setAct(actBlock);
                this.getFrameStack().pop();
                this.setNamespace(oldNamespace);
                this.getScope().setTop(oldScope);
                return rubyObject3;
            }
            this.getIterStack().pop();
            this.popClass();
            RubyVarmap.pop(this);
            this.block.setAct(actBlock);
            this.getFrameStack().pop();
            this.setNamespace(oldNamespace);
            this.getScope().setTop(oldScope);
            return rubyObject;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.getIterStack().pop();
            this.popClass();
            RubyVarmap.pop(this);
            this.block.setAct(actBlock);
            this.getFrameStack().pop();
            this.setNamespace(oldNamespace);
            this.getScope().setTop(oldScope);
            throw throwable;
        }
    }

    public RubyObject getRubyTopSelf() {
        return this.rubyTopSelf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RubyObject iterate(Callback iterateMethod, RubyObject data1, Callback blockMethod, RubyObject data2) {
        RubyObject rubyObject;
        this.getIterStack().push(Iter.ITER_PRE);
        this.getBlock().push(null, new IterateMethod(blockMethod, data2), this.getRubyTopSelf());
        try {
            while (true) {
                try {
                    rubyObject = iterateMethod.execute(data1, null, this);
                    Object var9_7 = null;
                }
                catch (BreakJump bExcptn) {
                    RubyObject rubyObject2 = this.getNil();
                    Object var9_8 = null;
                    this.getIterStack().pop();
                    this.getBlock().pop();
                    return rubyObject2;
                }
                catch (ReturnException rExcptn) {
                    RubyObject rubyObject3 = rExcptn.getReturnValue();
                    Object var9_9 = null;
                    this.getIterStack().pop();
                    this.getBlock().pop();
                    return rubyObject3;
                }
                catch (RetryException rExcptn) {
                    continue;
                }
                break;
            }
            this.getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.getIterStack().pop();
            this.getBlock().pop();
            throw throwable;
        }
        this.getBlock().pop();
        return rubyObject;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.getIterStack().push(Iter.ITER_NOT);
        this.getFrameStack().push();
        this.topFrame = this.getActFrame();
        this.getScope().push();
        this.topScope = (Scope)this.getScope().getTop();
        this.setActMethodScope(1);
        try {
            this.classes = new RubyClasses(this);
            this.classes.initCoreClasses();
            RubyGlobal.createGlobals(this);
            this.exceptions = new RubyExceptions(this);
            this.exceptions.initDefaultExceptionClasses();
            this.rubyTopSelf = new RubyObject(this, this.classes.getObjectClass());
            this.rubyClass = this.getClasses().getObjectClass();
            this.getActFrame().setSelf(this.rubyTopSelf);
            this.namespace = this.topNamespace = new Namespace(this.getClasses().getObjectClass());
            this.getActFrame().setNamespace(this.namespace);
        }
        catch (Exception excptn) {
            excptn.printStackTrace();
        }
        this.getScope().pop();
        this.getScope().push(this.topScope);
    }

    public ScopeStack getScope() {
        return this.scope;
    }

    public RubyMethodCache getMethodCache() {
        return this.methodCache;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public int getSourceLine() {
        return this.sourceLine;
    }

    public void setSourceLine(int sourceLine) {
        this.sourceLine = sourceLine;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isBlockGiven() {
        return !this.getActFrame().getIter().isNot();
    }

    public boolean isFBlockGiven() {
        return this.getFrameStack().getPrevious() != null && !this.getFrameStack().getPrevious().getIter().isNot();
    }

    public void pushClass(RubyModule newClass) {
        this.classStack.push(this.getRubyClass());
        this.setRubyClass(newClass);
    }

    public void popClass() {
        this.setRubyClass((RubyModule)this.classStack.pop());
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public RubyVarmap getDynamicVars() {
        return this.dynamicVars;
    }

    public void setDynamicVars(RubyVarmap dynamicVars) {
        this.dynamicVars = dynamicVars;
    }

    public RubyModule getRubyClass() {
        return this.rubyClass;
    }

    public void setRubyClass(RubyModule rubyClass) {
        this.rubyClass = rubyClass;
    }

    public int getInEval() {
        return this.inEval;
    }

    public void setInEval(int inEval) {
        this.inEval = inEval;
    }

    public FrameStack getFrameStack() {
        return this.frameStack;
    }

    public Frame getActFrame() {
        return (Frame)this.getFrameStack().peek();
    }

    public Frame getTopFrame() {
        return this.topFrame;
    }

    public void setTopFrame(Frame topFrame) {
        this.topFrame = topFrame;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Namespace newNamespace) {
        this.namespace = newNamespace;
    }

    public Namespace getTopNamespace() {
        return this.topNamespace;
    }

    public JavaSupport getJavaSupport() {
        return this.javaSupport;
    }

    public IStack getIterStack() {
        return this.iterStack;
    }

    public Iter getActIter() {
        return (Iter)this.getIterStack().peek();
    }

    public BlockStack getBlock() {
        return this.block;
    }

    public RubyModule getCBase() {
        return this.getActFrame().getNamespace().getNamespaceModule();
    }

    public void setCBase(RubyModule cBase) {
        this.getActFrame().getNamespace().setNamespaceModule(cBase);
    }

    public boolean isScope(int scope) {
        return (this.getActMethodScope() & scope) != 0;
    }

    public int getActMethodScope() {
        return this.actMethodScope;
    }

    public void setActMethodScope(int actMethodScope) {
        this.actMethodScope = actMethodScope;
    }

    public RubyModule getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(RubyModule wrapper) {
        this.wrapper = wrapper;
    }

    public RubyRuntime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(RubyRuntime runtime) {
        this.runtime = runtime;
    }

    public RubyExceptions getExceptions() {
        return this.exceptions;
    }

    public void defineVariable(GlobalVariable variable) {
        this.globalMap.put(variable.name(), variable);
    }

    public void defineReadonlyVariable(String name, RubyObject value) {
        this.globalMap.put(name, new ReadonlyGlobalVariable(this, name, value));
    }

    public void initLoad(ArrayList ioAdditionalDirectory) {
        String lRubyHome = System.getProperty("jruby.home");
        String lRubyLib = System.getProperty("jruby.lib");
        int i = ioAdditionalDirectory.size() - 1;
        while (i >= 0) {
            ioAdditionalDirectory.set(i, new RubyString(this, (String)ioAdditionalDirectory.get(i)));
            --i;
        }
        if (lRubyLib != null && lRubyLib.length() != 0) {
            ioAdditionalDirectory.add(new RubyString(this, lRubyLib));
        }
        if (lRubyHome != null && lRubyHome.length() != 0) {
            String lRuby = lRubyHome + File.separatorChar + "lib" + File.separatorChar + "ruby" + File.separatorChar;
            String lSiteRuby = lRuby + "site_ruby";
            String lSiteRubyVersion = lSiteRuby + File.separatorChar + RUBY_MAJOR_VERSION;
            String lArch = File.separatorChar + "java";
            String lRubyVersion = lRuby + RUBY_MAJOR_VERSION;
            ioAdditionalDirectory.add(new RubyString(this, lSiteRubyVersion));
            ioAdditionalDirectory.add(new RubyString(this, lSiteRubyVersion + lArch));
            ioAdditionalDirectory.add(new RubyString(this, lSiteRuby));
            ioAdditionalDirectory.add(new RubyString(this, lRubyVersion));
            ioAdditionalDirectory.add(new RubyString(this, lRubyVersion + lArch));
        }
        ioAdditionalDirectory.add(new RubyString(this, "."));
        RubyArray loadPath = (RubyArray)this.getGlobalVar("$:");
        loadPath.getList().addAll(ioAdditionalDirectory);
    }

    public File findFile(Ruby ruby, File i2find) {
        RubyArray lLoadPath = (RubyArray)this.getGlobalVar("$:");
        int lPathNb = lLoadPath.getLength();
        String l2Find = i2find.getPath();
        int i = 0;
        while (i < lPathNb) {
            String lCurPath = ((RubyString)lLoadPath.entry(i)).getValue();
            File lCurFile = new File(lCurPath + File.separatorChar + l2Find);
            if (lCurFile.exists()) {
                i2find = lCurFile;
                break;
            }
            ++i;
        }
        if (i2find.exists()) {
            return i2find;
        }
        throw new LoadError(ruby, "No such file to load -- " + i2find.getPath());
    }

    public INode compile(String content, String file, int line) {
        RubyParserConfiguration config = new RubyParserConfiguration();
        config.setLocalVariables(this.getScope().getLocalNames());
        this.getParser().init(config);
        IRubyParserResult result = (IRubyParserResult)this.getParser().parse(LexerFactory.getInstance().getSource(file, content));
        if (result.getLocalVariables() != null) {
            this.getScope().setLocalNames(new ArrayList(result.getLocalVariables()));
            if (this.getScope().getLocalNames() != null && this.getScope().getLocalNames().size() > 0) {
                if (this.getScope().getLocalValues() == null) {
                    this.getScope().setLocalValues(new ArrayList<RubyObject>(Collections.nCopies(this.getScope().getLocalNames().size(), this.getNil())));
                } else {
                    this.getScope().getLocalValues().addAll(Collections.nCopies(this.getScope().getLocalNames().size() - this.getScope().getLocalValues().size(), this.getNil()));
                }
            }
        }
        return result.getAST();
    }

    public RubyObject getLastline() {
        if (this.getScope().getLocalValues() != null) {
            return this.getScope().getValue(0);
        }
        return RubyString.nilString(this);
    }

    public void setLastline(RubyObject value) {
        if (this.getScope().getLocalValues() == null) {
            this.getScope().setLocalValues(new ArrayList<RubyObject>(Collections.nCopies(2, this.getNil())));
            this.getScope().setLocalNames(new ArrayList<String>(Arrays.asList("_", "~")));
        }
        this.getScope().setValue(0, value);
    }

    public RubyObject getBackref() {
        if (this.getScope().getLocalValues() != null) {
            return this.getScope().getValue(1);
        }
        return this.getNil();
    }

    public void setBackref(RubyObject match) {
        if (this.getScope().getLocalValues() == null) {
            this.getScope().setLocalValues(new ArrayList<RubyObject>(Collections.nCopies(2, this.getNil())));
            this.getScope().setLocalNames(new ArrayList<String>(Arrays.asList("_", "~")));
        }
        this.getScope().setValue(1, match);
    }

    public IParser getParser() {
        if (this.parser == null) {
            this.parser = new DefaultRubyParser();
            this.parser.setErrorHandler(new RubyErrorHandler(this, this.verbose));
        }
        return this.parser;
    }

    static {
        RUBY_MAJOR_VERSION = RUBY_MAJOR_VERSION;
        RUBY_VERSION = RUBY_VERSION;
        REGEXP_ADAPTER = new String[]{"org.jruby.regexp.JDKRegexpAdapter", "org.jruby.regexp.GNURegexpAdapter", "org.jruby.regexp.ORORegexpAdapter"};
    }
}

