/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.RangeError;
import org.jruby.exceptions.RubyBugException;
import org.jruby.marshal.MarshalStream;
import org.jruby.marshal.UnmarshalStream;
import org.jruby.runtime.CallbackFactory;

public class RubyBignum
extends RubyInteger {
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private BigInteger value;
    static /* synthetic */ Class class$org$jruby$RubyBignum;
    static /* synthetic */ Class class$org$jruby$RubyObject;
    static /* synthetic */ Class class$org$jruby$RubyInteger;

    public RubyBignum(Ruby ruby) {
        this(ruby, BigInteger.ZERO);
    }

    public RubyBignum(Ruby ruby, BigInteger value) {
        super(ruby, ruby.getClasses().getBignumClass());
        this.value = value;
    }

    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    public long getLongValue() {
        long result = this.getTruncatedLongValue();
        if (!BigInteger.valueOf(result).equals(this.value)) {
            throw new RangeError(this.ruby, "bignum too big to convert into 'int'");
        }
        return result;
    }

    public long getTruncatedLongValue() {
        return this.value.longValue();
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public static RubyClass createBignumClass(Ruby ruby) {
        RubyClass bignumClass = ruby.defineClass("Bignum", ruby.getClasses().getIntegerClass());
        bignumClass.defineMethod("-@", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_uminus"));
        bignumClass.defineMethod("modulo", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_mod", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("remainder", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "remainder", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "to_s"));
        bignumClass.defineMethod("coerce", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "coerce", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("hash", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "hash"));
        bignumClass.defineMethod("to_f", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "to_f"));
        bignumClass.defineMethod("+", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_plus", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("-", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_minus", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("*", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_mul", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("/", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_div", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("%", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_mod", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("&", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_and", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("**", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_pow", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("<<", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_lshift", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod(">>", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_rshift", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("<=>", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_cmp", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod(">", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_gt", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod(">=", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_ge", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("<", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_lt", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("<=", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_le", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBignum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        bignumClass.defineMethod("|", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_or", class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyBignum.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger));
        bignumClass.defineMethod("^", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "op_xor", class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyBignum.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger));
        bignumClass.defineMethod("[]", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "aref", class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyBignum.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger));
        bignumClass.defineMethod("size", CallbackFactory.getMethod(class$org$jruby$RubyBignum == null ? (class$org$jruby$RubyBignum = RubyBignum.class$("org.jruby.RubyBignum")) : class$org$jruby$RubyBignum, "size"));
        return bignumClass;
    }

    private static RubyInteger bigNorm(Ruby ruby, BigInteger bi) {
        if (bi.compareTo(LONG_MIN) < 0 || bi.compareTo(LONG_MAX) > 0) {
            return RubyBignum.newBignum(ruby, bi);
        }
        return RubyFixnum.newFixnum(ruby, bi.longValue());
    }

    public static BigInteger bigIntValue(RubyNumeric other) {
        if (other instanceof RubyFloat) {
            throw new RubyBugException("argument must be an integer");
        }
        return other instanceof RubyBignum ? ((RubyBignum)other).getValue() : BigInteger.valueOf(other.getLongValue());
    }

    protected int compareValue(RubyNumeric other) {
        if (other instanceof RubyFloat) {
            double otherVal = other.getDoubleValue();
            double thisVal = this.getDoubleValue();
            return thisVal > otherVal ? 1 : (thisVal < otherVal ? -1 : 0);
        }
        return this.getValue().compareTo(RubyBignum.bigIntValue(other));
    }

    public static RubyBignum newBignum(Ruby ruby, long value) {
        return RubyBignum.newBignum(ruby, BigInteger.valueOf(value));
    }

    public static RubyBignum newBignum(Ruby ruby, double value) {
        return RubyBignum.newBignum(ruby, new BigDecimal(value).toBigInteger());
    }

    public static RubyBignum newBignum(Ruby ruby, BigInteger value) {
        return new RubyBignum(ruby, value);
    }

    public RubyBignum newBignum(BigInteger value) {
        return RubyBignum.newBignum(this.ruby, value);
    }

    public RubyFixnum hash() {
        return new RubyFixnum(this.getRuby(), this.value.hashCode());
    }

    public RubyNumeric op_mod(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).modulo(other);
        }
        BigInteger m = RubyBignum.bigIntValue(other);
        BigInteger result = this.getValue().mod(m.abs());
        if (m.compareTo(BigInteger.ZERO) < 0) {
            result = m.add(result);
        }
        return RubyBignum.bigNorm(this.getRuby(), result);
    }

    public RubyNumeric op_and(RubyObject other) {
        RubyNumeric otherNumeric = RubyNumeric.numericValue(other);
        if (otherNumeric instanceof RubyBignum) {
            return RubyBignum.bigNorm(this.getRuby(), this.value.and(((RubyBignum)other).value));
        }
        return RubyFixnum.newFixnum(this.getRuby(), this.getTruncatedLongValue() & otherNumeric.getLongValue());
    }

    public RubyNumeric op_uminus() {
        return RubyBignum.bigNorm(this.getRuby(), this.getValue().negate());
    }

    public RubyNumeric remainder(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).remainder(other);
        }
        return RubyBignum.bigNorm(this.getRuby(), this.getValue().remainder(RubyBignum.bigIntValue(other)));
    }

    public RubyNumeric op_plus(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_plus(other);
        }
        return RubyBignum.bigNorm(this.getRuby(), this.getValue().add(RubyBignum.bigIntValue(other)));
    }

    public RubyNumeric op_minus(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_minus(other);
        }
        return RubyBignum.bigNorm(this.getRuby(), this.getValue().subtract(RubyBignum.bigIntValue(other)));
    }

    public RubyNumeric op_mul(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_mul(other);
        }
        return RubyBignum.bigNorm(this.getRuby(), this.getValue().multiply(RubyBignum.bigIntValue(other)));
    }

    public RubyNumeric op_div(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_div(other);
        }
        return RubyBignum.bigNorm(this.getRuby(), this.getValue().divide(RubyBignum.bigIntValue(other)));
    }

    public RubyNumeric op_pow(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_pow(other);
        }
        return RubyBignum.bigNorm(this.getRuby(), this.getValue().pow((int)other.getLongValue()));
    }

    public RubyBoolean op_equal(RubyObject other) {
        if (!(other instanceof RubyNumeric)) {
            return this.getRuby().getFalse();
        }
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue((RubyNumeric)other) == 0);
    }

    public RubyNumeric op_cmp(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFixnum.newFixnum(this.getRuby(), this.compareValue(other));
    }

    public RubyBoolean op_gt(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) > 0);
    }

    public RubyBoolean op_ge(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) >= 0);
    }

    public RubyBoolean op_lt(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) < 0);
    }

    public RubyBoolean op_le(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) <= 0);
    }

    public RubyInteger op_or(RubyInteger other) {
        return this.newBignum(this.value.or(RubyBignum.bigIntValue(other)));
    }

    public RubyInteger op_xor(RubyInteger other) {
        return this.newBignum(this.value.xor(RubyBignum.bigIntValue(other)));
    }

    public RubyFixnum aref(RubyInteger pos) {
        boolean isSet = this.getValue().testBit((int)pos.getLongValue());
        return RubyFixnum.newFixnum(this.getRuby(), isSet ? 1 : 0);
    }

    public RubyString to_s() {
        return RubyString.newString(this.getRuby(), this.getValue().toString());
    }

    public RubyFloat to_f() {
        return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue());
    }

    public RubyNumeric[] coerce(RubyNumeric iNum) {
        RubyNumeric other = RubyNumeric.numericValue(iNum);
        if (!(iNum instanceof RubyInteger)) {
            return new RubyNumeric[]{other, this};
        }
        return new RubyNumeric[]{RubyFloat.newFloat(this.getRuby(), other.getDoubleValue()), RubyFloat.newFloat(this.getRuby(), this.getDoubleValue())};
    }

    public RubyBignum op_lshift(RubyObject iNum) {
        long shift = RubyNumeric.numericValue(iNum).getLongValue();
        if (shift > Integer.MAX_VALUE || shift < Integer.MIN_VALUE) {
            throw new RangeError(this.ruby, "bignum too big to convert into `int'");
        }
        return new RubyBignum(this.ruby, this.value.shiftLeft((int)shift));
    }

    public RubyBignum op_rshift(RubyObject iNum) {
        long shift = RubyNumeric.numericValue(iNum).getLongValue();
        if (shift > Integer.MAX_VALUE || shift < Integer.MIN_VALUE) {
            throw new RangeError(this.ruby, "bignum too big to convert into `int'");
        }
        return new RubyBignum(this.ruby, this.value.shiftRight((int)shift));
    }

    public RubyFixnum size() {
        int byteLength = this.value.bitLength() / 8;
        if (this.value.bitLength() % 8 != 0) {
            ++byteLength;
        }
        return RubyFixnum.newFixnum(this.ruby, byteLength);
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(108);
        output.write(this.value.signum() >= 0 ? 43 : 45);
        BigInteger absValue = this.value.abs();
        int bitLength = absValue.bitLength();
        int shortLength = bitLength / 16;
        if (bitLength % 16 != 0) {
            ++shortLength;
        }
        output.dumpInt(shortLength);
        byte[] digits = absValue.toByteArray();
        int i = digits.length - 1;
        while (i >= 0) {
            if (i == 0 && digits[i] == 0 && digits.length % 2 != 0) break;
            output.write(digits[i]);
            --i;
        }
        if (digits[0] != 0 && digits.length % 2 != 0) {
            output.write(0);
        }
    }

    public static RubyBignum unmarshalFrom(UnmarshalStream input) throws IOException {
        int signum = input.readUnsignedByte() == 43 ? 1 : -1;
        int shortLength = input.unmarshalInt();
        byte[] digits = new byte[shortLength * 2];
        int i = digits.length - 1;
        while (i >= 0) {
            digits[i] = input.readSignedByte();
            --i;
        }
        BigInteger value = new BigInteger(digits);
        if (signum == -1) {
            value = value.negate();
        }
        return RubyBignum.newBignum(input.getRuby(), value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

