/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.marshal.MarshalStream;
import org.jruby.runtime.CallbackFactory;

public class RubyBoolean
extends RubyObject {
    private boolean value;
    static /* synthetic */ Class class$org$jruby$RubyBoolean;
    static /* synthetic */ Class class$org$jruby$RubyObject;

    public RubyBoolean(Ruby ruby, boolean value) {
        super(ruby, null);
        this.value = value;
    }

    public Class getJavaClass() {
        return Boolean.TYPE;
    }

    public RubyClass getRubyClass() {
        return this.value ? this.getRuby().getClasses().getTrueClass() : this.getRuby().getClasses().getFalseClass();
    }

    public boolean isTrue() {
        return this.value;
    }

    public boolean isFalse() {
        return !this.value;
    }

    public static RubyClass createFalseClass(Ruby ruby) {
        RubyClass falseClass = ruby.defineClass("FalseClass", ruby.getClasses().getObjectClass());
        falseClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "to_s"));
        falseClass.defineMethod("type", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "type"));
        falseClass.defineMethod("&", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "op_and", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBoolean.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        falseClass.defineMethod("|", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "op_or", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBoolean.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        falseClass.defineMethod("^", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "op_xor", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBoolean.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        falseClass.getRubyClass().undefMethod("new");
        ruby.defineGlobalConstant("FALSE", ruby.getFalse());
        return falseClass;
    }

    public static RubyClass createTrueClass(Ruby ruby) {
        RubyClass trueClass = ruby.defineClass("TrueClass", ruby.getClasses().getObjectClass());
        trueClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "to_s"));
        trueClass.defineMethod("type", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "type"));
        trueClass.defineMethod("&", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "op_and", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBoolean.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        trueClass.defineMethod("|", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "op_or", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBoolean.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        trueClass.defineMethod("^", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "op_xor", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyBoolean.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        trueClass.getRubyClass().undefMethod("new");
        ruby.defineGlobalConstant("TRUE", ruby.getTrue());
        return trueClass;
    }

    public static RubyBoolean newBoolean(Ruby ruby, boolean value) {
        if (value) {
            return ruby.getTrue();
        }
        return ruby.getFalse();
    }

    public RubyString to_s() {
        if (this.isFalse()) {
            return RubyString.newString(this.getRuby(), "false");
        }
        return RubyString.newString(this.getRuby(), "true");
    }

    public RubyClass type() {
        return this.getRubyClass();
    }

    public RubyBoolean op_and(RubyObject obj) {
        if (this.isTrue() && obj.isTrue()) {
            return this.getRuby().getTrue();
        }
        return this.getRuby().getFalse();
    }

    public RubyBoolean op_or(RubyObject obj) {
        if (this.isFalse() && obj.isFalse()) {
            return this.getRuby().getFalse();
        }
        return this.getRuby().getTrue();
    }

    public RubyBoolean op_xor(RubyObject obj) {
        if (this.isTrue() && obj.isFalse() || this.isFalse() && obj.isTrue()) {
            return this.getRuby().getTrue();
        }
        return this.getRuby().getFalse();
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(this.isTrue() ? 84 : 70);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

