/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.IOError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.util.RubyInputStream;

public class RubyFile
extends RubyIO {
    static /* synthetic */ Class class$org$jruby$RubyFile;
    static /* synthetic */ Class class$org$jruby$RubyString;

    public RubyFile(Ruby ruby, RubyClass type) {
        super(ruby, type);
    }

    public static RubyClass createFileClass(Ruby ruby) {
        RubyClass fileClass = ruby.defineClass("File", ruby.getClasses().getIoClass());
        fileClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyFile == null ? (class$org$jruby$RubyFile = RubyFile.class$("org.jruby.RubyFile")) : class$org$jruby$RubyFile, "newInstance"));
        fileClass.defineSingletonMethod("open", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyFile == null ? (class$org$jruby$RubyFile = RubyFile.class$("org.jruby.RubyFile")) : class$org$jruby$RubyFile, "open"));
        fileClass.defineSingletonMethod("exist?", CallbackFactory.getSingletonMethod(class$org$jruby$RubyFile == null ? (class$org$jruby$RubyFile = RubyFile.class$("org.jruby.RubyFile")) : class$org$jruby$RubyFile, "exist", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyFile.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        fileClass.defineSingletonMethod("unlink", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyFile == null ? (class$org$jruby$RubyFile = RubyFile.class$("org.jruby.RubyFile")) : class$org$jruby$RubyFile, "unlink"));
        fileClass.defineSingletonMethod("delete", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyFile == null ? (class$org$jruby$RubyFile = RubyFile.class$("org.jruby.RubyFile")) : class$org$jruby$RubyFile, "unlink"));
        fileClass.defineSingletonMethod("dirname", CallbackFactory.getSingletonMethod(class$org$jruby$RubyFile == null ? (class$org$jruby$RubyFile = RubyFile.class$("org.jruby.RubyFile")) : class$org$jruby$RubyFile, "dirname", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyFile.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        fileClass.defineSingletonMethod("join", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyFile == null ? (class$org$jruby$RubyFile = RubyFile.class$("org.jruby.RubyFile")) : class$org$jruby$RubyFile, "join"));
        fileClass.defineSingletonMethod("directory?", CallbackFactory.getSingletonMethod(class$org$jruby$RubyFile == null ? (class$org$jruby$RubyFile = RubyFile.class$("org.jruby.RubyFile")) : class$org$jruby$RubyFile, "directory", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyFile.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        fileClass.defineSingletonMethod("basename", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyFile == null ? (class$org$jruby$RubyFile = RubyFile.class$("org.jruby.RubyFile")) : class$org$jruby$RubyFile, "basename"));
        fileClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyFile == null ? (class$org$jruby$RubyFile = RubyFile.class$("org.jruby.RubyFile")) : class$org$jruby$RubyFile, "initialize"));
        return fileClass;
    }

    protected void openInternal(String path, String mode) {
        this.path = path;
        this.setMode(mode);
        File file = new File(path);
        try {
            if (this.isReadable()) {
                this.inStream = new RubyInputStream(new BufferedInputStream(new FileInputStream(file)));
            }
            if (this.isWriteable()) {
                this.outStream = new BufferedOutputStream(new FileOutputStream(file.getAbsolutePath(), this.append));
            }
        }
        catch (IOException ioExcptn) {
            throw new IOError(this.getRuby(), ioExcptn.getMessage());
        }
    }

    private static String separator() {
        return "/";
    }

    public static RubyObject newInstance(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyFile file = new RubyFile(ruby, (RubyClass)recv);
        file.callInit(args);
        return file;
    }

    public RubyObject initialize(RubyObject[] args) {
        if (args.length == 0) {
            throw new ArgumentError(this.getRuby(), "");
        }
        args[0].checkSafeString();
        this.path = args[0].toString();
        String mode = "r";
        if (args.length > 1 && args[1] instanceof RubyString) {
            mode = ((RubyString)args[1]).getValue();
        }
        this.closeStreams();
        this.openInternal(this.path, mode);
        if (this.getRuby().isBlockGiven()) {
            // empty if block
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyObject open(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyFile file = new RubyFile(ruby, (RubyClass)recv);
        if (args.length == 0) {
            throw new ArgumentError(ruby, "");
        }
        args[0].checkSafeString();
        file.path = args[0].toString();
        String mode = "r";
        if (args.length > 1 && args[1] instanceof RubyString) {
            mode = ((RubyString)args[1]).getValue();
        }
        file.closeStreams();
        file.openInternal(file.path, mode);
        if (ruby.isBlockGiven()) {
            try {
                ruby.yield(file);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                file.closeStreams();
                throw throwable;
            }
            file.closeStreams();
            {
            }
        }
        return file;
    }

    public static RubyObject unlink(Ruby ruby, RubyObject recv, RubyObject[] args) {
        int i = 0;
        while (i < args.length) {
            args[i].checkSafeString();
            File lToDelete = new File(args[i].toString());
            if (!lToDelete.exists()) {
                throw new IOError(ruby, " No such file or directory - \"" + args[i].toString() + "\"");
            }
            if (!lToDelete.delete()) {
                return ruby.getFalse();
            }
            ++i;
        }
        return RubyFixnum.newFixnum(ruby, args.length);
    }

    public static RubyObject exist(Ruby ruby, RubyObject recv, RubyString filename) {
        return RubyBoolean.newBoolean(ruby, new File(filename.toString()).exists());
    }

    public static RubyString dirname(Ruby ruby, RubyObject recv, RubyString filename) {
        String name = filename.toString();
        int index = name.lastIndexOf(RubyFile.separator());
        if (index == -1) {
            return RubyString.newString(ruby, ".");
        }
        if (index == 0) {
            return RubyString.newString(ruby, RubyFile.separator());
        }
        return RubyString.newString(ruby, name.substring(0, index));
    }

    public static RubyString basename(Ruby ruby, RubyObject recv, RubyObject[] args) {
        if (args.length < 1 || args.length > 2) {
            throw new ArgumentError(ruby, "This method expected 1 or 2 arguments.");
        }
        String name = args[0].toString();
        name = new File(name).getName();
        if (args.length == 2 && name.endsWith(args[1].toString())) {
            name = name.substring(0, name.length() - args[1].toString().length());
        }
        return RubyString.newString(ruby, name);
    }

    public static RubyString join(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyArray argArray = RubyArray.newArray(ruby, args);
        return argArray.join(RubyString.newString(ruby, RubyFile.separator()));
    }

    public static RubyBoolean directory(Ruby ruby, RubyObject recv, RubyString filename) {
        return RubyBoolean.newBoolean(ruby, new File(filename.toString()).isDirectory());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

