/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.marshal.MarshalStream;
import org.jruby.marshal.UnmarshalStream;
import org.jruby.runtime.CallbackFactory;

public class RubyFixnum
extends RubyInteger {
    private long value;
    private static int BIT_SIZE = 64;
    static /* synthetic */ Class class$org$jruby$RubyFixnum;
    static /* synthetic */ Class class$org$jruby$RubyObject;
    static /* synthetic */ Class class$org$jruby$RubyInteger;

    public RubyFixnum(Ruby ruby) {
        this(ruby, 0L);
    }

    public RubyFixnum(Ruby ruby, long value) {
        super(ruby, ruby.getClasses().getFixnumClass());
        this.value = value;
    }

    public static RubyClass createFixnumClass(Ruby ruby) {
        RubyClass fixnumClass = ruby.defineClass("Fixnum", ruby.getClasses().getIntegerClass());
        fixnumClass.includeModule(ruby.getClasses().getPrecisionModule());
        fixnumClass.defineSingletonMethod("induced_from", CallbackFactory.getSingletonMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "induced_from", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod("to_f", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "to_f"));
        fixnumClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "to_s"));
        fixnumClass.defineMethod("to_str", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "to_s"));
        fixnumClass.defineMethod("hash", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "hash"));
        fixnumClass.defineMethod("taint", CallbackFactory.getSelfMethod());
        fixnumClass.defineMethod("freeze", CallbackFactory.getSelfMethod());
        fixnumClass.defineMethod("<<", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_lshift", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod(">>", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_rshift", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod("+", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_plus", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod("-", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_minus", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod("*", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_mul", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod("/", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_div", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod("%", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_mod", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod("**", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_pow", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod("<=>", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_cmp", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod(">", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_gt", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod(">=", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_ge", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod("<", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_lt", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod("<=", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_le", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod("&", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_and", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFixnum.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        fixnumClass.defineMethod("|", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_or", class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyFixnum.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger));
        fixnumClass.defineMethod("^", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_xor", class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyFixnum.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger));
        fixnumClass.defineMethod("size", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "size"));
        fixnumClass.defineMethod("[]", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "aref", class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyFixnum.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger));
        return fixnumClass;
    }

    public Class getJavaClass() {
        return Long.TYPE;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public long getLongValue() {
        return this.value;
    }

    public static RubyFixnum zero(Ruby ruby) {
        return RubyFixnum.newFixnum(ruby, 0L);
    }

    public static RubyFixnum one(Ruby ruby) {
        return RubyFixnum.newFixnum(ruby, 1L);
    }

    public static RubyFixnum minus_one(Ruby ruby) {
        return RubyFixnum.newFixnum(ruby, -1L);
    }

    protected int compareValue(RubyNumeric other) {
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).compareValue(this) * -1;
        }
        if (other instanceof RubyFloat) {
            double otherVal = other.getDoubleValue();
            double thisVal = this.getDoubleValue();
            return thisVal > otherVal ? 1 : (thisVal < otherVal ? -1 : 0);
        }
        long otherVal = other.getLongValue();
        return this.getLongValue() > otherVal ? 1 : (this.getLongValue() < otherVal ? -1 : 0);
    }

    public static RubyFixnum newFixnum(Ruby ruby, long value) {
        RubyFixnum fixnum;
        if (value >= 0L && value < (long)ruby.fixnumCache.length) {
            fixnum = ruby.fixnumCache[(int)value];
            if (fixnum == null) {
                ruby.fixnumCache[(int)value] = fixnum = new RubyFixnum(ruby, value);
            }
        } else {
            fixnum = new RubyFixnum(ruby, value);
        }
        return fixnum;
    }

    public RubyFixnum newFixnum(long value) {
        return RubyFixnum.newFixnum(this.ruby, value);
    }

    public static RubyInteger induced_from(Ruby ruby, RubyObject recv, RubyObject number) {
        if (number instanceof RubyFixnum) {
            return (RubyFixnum)number;
        }
        if (number instanceof RubyFloat) {
            return ((RubyFloat)number).to_i();
        }
        if (number instanceof RubyBignum) {
            return RubyFixnum.newFixnum(ruby, ((RubyBignum)number).getLongValue());
        }
        return (RubyFixnum)number.convertToType("Fixnum", "to_int", true);
    }

    public RubyFixnum hash() {
        return this;
    }

    public RubyNumeric op_plus(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_plus(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuby(), this.value).op_plus(other);
        }
        long otherValue = other.getLongValue();
        long result = this.value + otherValue;
        if (this.value < 0L && otherValue < 0L && result > 0L || this.value > 0L && otherValue > 0L && result < 0L) {
            return RubyBignum.newBignum(this.getRuby(), this.value).op_plus(other);
        }
        return this.newFixnum(result);
    }

    public RubyNumeric op_minus(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_minus(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuby(), this.value).op_minus(other);
        }
        long otherValue = other.getLongValue();
        long result = this.value - otherValue;
        if (this.value < 0L && otherValue > 0L && result > 0L || this.value > 0L && otherValue < 0L && result < 0L) {
            return RubyBignum.newBignum(this.getRuby(), this.value).op_minus(other);
        }
        return this.newFixnum(result);
    }

    public RubyNumeric op_mul(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_mul(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuby(), this.getLongValue()).op_mul(other);
        }
        long otherValue = other.getLongValue();
        long result = this.value * otherValue;
        if (result / otherValue == this.value) {
            return this.newFixnum(result);
        }
        return RubyBignum.newBignum(this.getRuby(), this.getLongValue()).op_mul(other);
    }

    public RubyNumeric op_div(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_div(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuby(), this.getLongValue()).op_div(other);
        }
        return RubyFixnum.newFixnum(this.getRuby(), this.getLongValue() / other.getLongValue());
    }

    public RubyNumeric op_mod(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_mod(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuby(), this.getLongValue()).op_mod(other);
        }
        return RubyFixnum.newFixnum(this.getRuby(), this.getLongValue() % other.getLongValue());
    }

    public RubyNumeric op_pow(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_pow(other);
        }
        if (other.getLongValue() == 0L) {
            return RubyFixnum.newFixnum(this.getRuby(), 1L);
        }
        if (other.getLongValue() == 1L) {
            return this;
        }
        if (other.getLongValue() > 1L) {
            return RubyBignum.newBignum(this.getRuby(), this.getLongValue()).op_pow(other);
        }
        return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue()).op_pow(other);
    }

    public RubyBoolean op_equal(RubyObject other) {
        if (!(other instanceof RubyNumeric)) {
            return this.getRuby().getFalse();
        }
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue((RubyNumeric)other) == 0);
    }

    public RubyNumeric op_cmp(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFixnum.newFixnum(this.getRuby(), this.compareValue(other));
    }

    public RubyBoolean op_gt(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) > 0);
    }

    public RubyBoolean op_ge(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) >= 0);
    }

    public RubyBoolean op_lt(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) < 0);
    }

    public RubyBoolean op_le(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) <= 0);
    }

    public RubyString to_s() {
        return RubyString.newString(this.getRuby(), String.valueOf(this.getLongValue()));
    }

    public RubyFloat to_f() {
        return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue());
    }

    public RubyInteger op_lshift(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        long width = other.getLongValue();
        if (width < 0L) {
            return this.op_rshift(other.op_uminus());
        }
        if (width > (long)BIT_SIZE || this.value >>> (int)((long)BIT_SIZE - width) > 0L) {
            RubyBignum lBigValue = new RubyBignum(this.ruby, RubyBignum.bigIntValue(this));
            return lBigValue.op_lshift(other);
        }
        return this.newFixnum(this.value << (int)width);
    }

    public RubyInteger op_rshift(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        long width = other.getLongValue();
        if (width < 0L) {
            return this.op_lshift(other.op_uminus());
        }
        return this.newFixnum(this.value >>> (int)width);
    }

    public RubyNumeric op_and(RubyObject other) {
        RubyNumeric otherNumeric = RubyNumeric.numericValue(other);
        long otherLong = otherNumeric.getTruncatedLongValue();
        return this.newFixnum(this.value & otherLong);
    }

    public RubyInteger op_or(RubyInteger other) {
        if (other instanceof RubyBignum) {
            return (RubyInteger)other.funcall("|", this);
        }
        return this.newFixnum(this.value | other.getLongValue());
    }

    public RubyInteger op_xor(RubyInteger other) {
        if (other instanceof RubyBignum) {
            return (RubyInteger)other.funcall("^", this);
        }
        return this.newFixnum(this.value ^ other.getLongValue());
    }

    public RubyBoolean equal(RubyObject obj) {
        return RubyBoolean.newBoolean(this.ruby, obj instanceof RubyFixnum && ((RubyFixnum)obj).getLongValue() == this.getLongValue());
    }

    public RubyFixnum size() {
        return this.newFixnum(4L);
    }

    public RubyFixnum aref(RubyInteger pos) {
        long mask = 1 << (int)pos.getLongValue();
        return this.newFixnum((this.value & mask) == 0L ? 0L : 1L);
    }

    public void marshalTo(MarshalStream output) throws IOException {
        if (this.value <= Integer.MAX_VALUE) {
            output.write(105);
            output.dumpInt((int)this.value);
        } else {
            output.dumpObject(RubyBignum.newBignum(this.ruby, this.value));
        }
    }

    public static RubyFixnum unmarshalFrom(UnmarshalStream input) throws IOException {
        return RubyFixnum.newFixnum(input.getRuby(), input.unmarshalInt());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

