/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.GlobalVariable;

public class RubyGlobal {
    public static void createGlobals(Ruby ruby) {
        RubyObject version = RubyString.newString(ruby, "1.6.7").freeze();
        RubyObject release = RubyString.newString(ruby, "$Date: 2002/05/03 21:19:01 $").freeze();
        RubyObject platform = RubyString.newString(ruby, "java").freeze();
        ruby.defineGlobalConstant("RUBY_VERSION", version);
        ruby.defineGlobalConstant("RUBY_RELEASE_DATE", release);
        ruby.defineGlobalConstant("RUBY_PLATFORM", platform);
        ruby.defineGlobalConstant("VERSION", version);
        ruby.defineGlobalConstant("RELEASE_DATE", release);
        ruby.defineGlobalConstant("PLATFORM", platform);
        ruby.defineVariable(new StringGlobalVariable(ruby, "$/", RubyString.newString(ruby, "\n")));
        ruby.defineVariable(new StringGlobalVariable(ruby, "$\\", ruby.getNil()));
        ruby.defineVariable(new StringGlobalVariable(ruby, "$,", ruby.getNil()));
        ruby.defineVariable(new LineNumberGlobalVariable(ruby, "$.", RubyFixnum.one(ruby)));
        ruby.defineVariable(new LastlineGlobalVariable(ruby, "$_"));
        ruby.defineVariable(new ErrorInfoGlobalVariable(ruby, "$!", ruby.getNil()));
        ruby.defineVariable(new SafeGlobalVariable(ruby, "$SAFE"));
        ruby.defineVariable(new BacktraceGlobalVariable(ruby, "$@"));
        RubyObject stdin = RubyIO.stdin(ruby, ruby.getClasses().getIoClass(), System.in);
        RubyObject stdout = RubyIO.stdout(ruby, ruby.getClasses().getIoClass(), System.out);
        RubyObject stderr = RubyIO.stderr(ruby, ruby.getClasses().getIoClass(), System.err);
        ruby.defineVariable(new InputGlobalVariable(ruby, "$stdin", stdin));
        ruby.defineVariable(new OutputGlobalVariable(ruby, "$stdout", stdout));
        ruby.defineVariable(new OutputGlobalVariable(ruby, "$stderr", stderr));
        ruby.defineVariable(new OutputGlobalVariable(ruby, "$>", stdout));
        ruby.defineVariable(new OutputGlobalVariable(ruby, "$defout", stdout));
        ruby.defineGlobalConstant("STDIN", stdin);
        ruby.defineGlobalConstant("STDOUT", stdout);
        ruby.defineGlobalConstant("STDERR", stderr);
        ruby.defineReadonlyVariable("$\"", RubyArray.newArray(ruby));
        ruby.defineReadonlyVariable("$*", RubyArray.newArray(ruby));
        RubyArray loadPath = RubyArray.newArray(ruby);
        ruby.defineReadonlyVariable("$:", loadPath);
        ruby.defineReadonlyVariable("$-I", loadPath);
        ruby.defineReadonlyVariable("$LOAD_PATH", loadPath);
        RubyArgsFile argsFile = new RubyArgsFile(ruby);
        argsFile.initArgsFile();
    }

    private static class OutputGlobalVariable
    extends GlobalVariable {
        public OutputGlobalVariable(Ruby ruby, String name, RubyObject value) {
            super(ruby, name, value);
        }

        public RubyObject set(RubyObject value) {
            if (value == this.get()) {
                return value;
            }
            if (value instanceof RubyIO) {
                ((RubyIO)value).checkWriteable();
            }
            if (!value.respondsTo("write")) {
                throw new TypeError(this.ruby, this.name() + " must have write method, " + value.type().toName() + " given");
            }
            return super.set(value);
        }
    }

    private static class InputGlobalVariable
    extends GlobalVariable {
        public InputGlobalVariable(Ruby ruby, String name, RubyObject value) {
            super(ruby, name, value);
        }

        public RubyObject set(RubyObject value) {
            if (value == this.get()) {
                return value;
            }
            if (value instanceof RubyIO) {
                ((RubyIO)value).checkReadable();
            }
            return super.set(value);
        }
    }

    private static class LastlineGlobalVariable
    extends GlobalVariable {
        public LastlineGlobalVariable(Ruby ruby, String name) {
            super(ruby, name, null);
        }

        public RubyObject get() {
            return this.ruby.getLastline();
        }

        public RubyObject set(RubyObject value) {
            this.ruby.setLastline(value);
            return value;
        }
    }

    private static class BacktraceGlobalVariable
    extends GlobalVariable {
        public BacktraceGlobalVariable(Ruby ruby, String name) {
            super(ruby, name, null);
        }

        public RubyObject get() {
            RubyObject errorInfo = this.ruby.getGlobalVar("$!");
            return errorInfo.isNil() ? this.ruby.getNil() : errorInfo.funcall("backtrace");
        }

        public RubyObject set(RubyObject value) {
            if (this.ruby.getGlobalVar("$!").isNil()) {
                throw new ArgumentError(this.ruby, "$! not set.");
            }
            this.ruby.getGlobalVar("$!").funcall("set_backtrace", value);
            return value;
        }
    }

    private static class SafeGlobalVariable
    extends GlobalVariable {
        public SafeGlobalVariable(Ruby ruby, String name) {
            super(ruby, name, null);
        }

        public RubyObject get() {
            return RubyFixnum.newFixnum(this.ruby, this.ruby.getSafeLevel());
        }

        public RubyObject set(RubyObject value) {
            int level = RubyFixnum.fix2int(value);
            if (level < this.ruby.getSafeLevel()) {
                throw new SecurityException("tried to downgrade level from " + this.ruby.getSafeLevel() + " to " + level);
            }
            this.ruby.setSafeLevel(level);
            return value;
        }
    }

    public static class StringGlobalVariable
    extends GlobalVariable {
        public StringGlobalVariable(Ruby ruby, String name, RubyObject value) {
            super(ruby, name, value);
        }

        public RubyObject set(RubyObject value) {
            if (!(value instanceof RubyString)) {
                throw new TypeError(this.ruby, "value of " + this.name() + " must be a String");
            }
            return super.set(value);
        }
    }

    private static class ErrorInfoGlobalVariable
    extends GlobalVariable {
        public ErrorInfoGlobalVariable(Ruby ruby, String name, RubyObject value) {
            super(ruby, name, value);
        }

        public RubyObject set(RubyObject value) {
            if (!value.isNil() && value.kind_of(this.ruby.getClasses().getExceptionClass()).isFalse()) {
                throw new TypeError(this.ruby, "assigning non-exception to $!");
            }
            return super.set(value);
        }
    }

    private static class LineNumberGlobalVariable
    extends GlobalVariable {
        public LineNumberGlobalVariable(Ruby ruby, String name, RubyFixnum value) {
            super(ruby, name, value);
        }

        public RubyObject set(RubyObject value) {
            ((RubyArgsFile)this.ruby.getGlobalVar("$<")).setCurrentLineNumber(RubyFixnum.fix2int(value));
            return super.set(value);
        }
    }
}

