/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.ast.AttrSetNode;
import org.jruby.ast.InstVarNode;
import org.jruby.internal.runtime.methods.EvaluateMethod;
import org.jruby.runtime.Iter;
import org.jruby.runtime.ReflectionCallbackMethod;
import org.jruby.runtime.methods.IMethod;
import org.jruby.util.RubyPointer;

public class RubyMethod
extends RubyObject {
    private RubyClass receiverClass;
    private RubyObject receiver;
    private String methodId;
    private IMethod method;
    private RubyClass originalClass;
    private String originalId;
    static /* synthetic */ Class class$org$jruby$RubyMethod;

    public RubyMethod(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createMethodClass(Ruby ruby) {
        ReflectionCallbackMethod arity = new ReflectionCallbackMethod(class$org$jruby$RubyMethod == null ? (class$org$jruby$RubyMethod = RubyMethod.class$("org.jruby.RubyMethod")) : class$org$jruby$RubyMethod, "arity");
        ReflectionCallbackMethod call = new ReflectionCallbackMethod(class$org$jruby$RubyMethod == null ? (class$org$jruby$RubyMethod = RubyMethod.class$("org.jruby.RubyMethod")) : class$org$jruby$RubyMethod, "call", true);
        RubyClass methodClass = ruby.defineClass("Method", ruby.getClasses().getObjectClass());
        methodClass.defineMethod("arity", arity);
        methodClass.defineMethod("[]", call);
        methodClass.defineMethod("call", call);
        return methodClass;
    }

    public String getMethodId() {
        return this.methodId;
    }

    public void setMethodId(String methodId) {
        this.methodId = methodId;
    }

    public RubyClass getOriginalClass() {
        return this.originalClass;
    }

    public void setOriginalClass(RubyClass originalClass) {
        this.originalClass = originalClass;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public RubyObject getReceiver() {
        return this.receiver;
    }

    public void setReceiver(RubyObject receiver) {
        this.receiver = receiver;
    }

    public RubyClass getReceiverClass() {
        return this.receiverClass;
    }

    public void setReceiverClass(RubyClass receiverClass) {
        this.receiverClass = receiverClass;
    }

    public RubyObject call(RubyObject[] args) {
        this.getRuby().getIterStack().push(this.getRuby().isBlockGiven() ? Iter.ITER_PRE : Iter.ITER_NOT);
        RubyObject result = this.getReceiverClass().call0(this.getReceiver(), this.getMethodId(), new RubyPointer(args), this.getMethod(), false);
        this.getRuby().getIterStack().pop();
        return result;
    }

    public RubyFixnum arity() {
        if (this.method instanceof EvaluateMethod) {
            if (((EvaluateMethod)this.method).getNode() instanceof AttrSetNode) {
                return RubyFixnum.one(this.getRuby());
            }
            if (((EvaluateMethod)this.method).getNode() instanceof InstVarNode) {
                return RubyFixnum.zero(this.getRuby());
            }
        }
        return RubyFixnum.newFixnum(this.getRuby(), -1L);
    }

    public IMethod getMethod() {
        return this.method;
    }

    public void setMethod(IMethod method) {
        this.method = method;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Nil
    extends RubyMethod {
        public Nil(Ruby ruby) {
            super(ruby, ruby.getClasses().getNilClass());
        }
    }
}

