/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.ablaf.ast.INode;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIncludedClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.ZSuperNode;
import org.jruby.evaluator.EvaluateVisitor;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RubyBugException;
import org.jruby.exceptions.RubyFrozenException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.TypeError;
import org.jruby.internal.runtime.methods.CacheEntry;
import org.jruby.internal.runtime.methods.EvaluateMethod;
import org.jruby.marshal.MarshalStream;
import org.jruby.runtime.Block;
import org.jruby.runtime.Callback;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Iter;
import org.jruby.runtime.methods.IMethod;
import org.jruby.util.RubyHashMap;
import org.jruby.util.RubyMap;
import org.jruby.util.RubyMapMethod;
import org.jruby.util.RubyPointer;

public class RubyObject
implements Cloneable {
    protected transient Ruby ruby;
    private RubyClass rubyClass;
    private RubyMap instanceVariables;
    private boolean frozen;
    private boolean taint;
    static /* synthetic */ Class class$org$jruby$RubyObject;
    static /* synthetic */ Class class$org$jruby$RubyModule;

    public RubyObject(Ruby ruby) {
        this(ruby, null, false);
    }

    public RubyObject(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, true);
    }

    public RubyObject(Ruby ruby, RubyClass rubyClass, boolean objectSpace) {
        this.ruby = ruby;
        this.rubyClass = rubyClass;
        this.frozen = false;
        this.taint = false;
        if (objectSpace) {
            ruby.objectSpace.add(new SoftReference<RubyObject>(this));
        }
    }

    public static RubyObject nilObject(Ruby ruby) {
        if (ruby.getNil() != null) {
            return ruby.getNil();
        }
        return new RubyObject(ruby){

            public boolean isNil() {
                return true;
            }
        };
    }

    public RubyClass makeMetaClass(RubyClass type) {
        type = type.newSingletonClass();
        this.setRubyClass(type);
        type.attachSingletonClass(this);
        return type;
    }

    public Class getJavaClass() {
        return class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject;
    }

    public int hashCode() {
        long rubyHash = RubyNumeric.fix2long(this.funcall("hash"));
        int result = (int)rubyHash;
        result = (int)((long)result ^ rubyHash >> 32);
        return result;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof RubyObject && this.funcall("==", (RubyObject)other).isTrue();
    }

    public String toString() {
        return ((RubyString)this.funcall("to_s")).getValue();
    }

    public Ruby getRuby() {
        return this.ruby;
    }

    public RubyMap getInstanceVariables() {
        return this.instanceVariables;
    }

    public void setInstanceVariables(RubyMap instanceVariables) {
        this.instanceVariables = instanceVariables;
    }

    public RubyClass getRubyClass() {
        if (this.isNil()) {
            return this.getRuby().getClasses().getNilClass();
        }
        return this.rubyClass;
    }

    public void setRubyClass(RubyClass rubyClass) {
        this.rubyClass = rubyClass;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public boolean isTaint() {
        return this.taint;
    }

    public void setTaint(boolean taint) {
        this.taint = taint;
    }

    public boolean isNil() {
        return false;
    }

    public boolean isTrue() {
        return !this.isNil();
    }

    public boolean isFalse() {
        return this.isNil();
    }

    public boolean respondsTo(String methodName) {
        return this.respond_to(RubySymbol.newSymbol(this.getRuby(), methodName)).isTrue();
    }

    public static void createObjectClass(RubyModule objectClass) {
        objectClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        objectClass.defineMethod("=~", CallbackFactory.getFalseMethod());
        objectClass.defineMethod("clone", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "rbClone"));
        objectClass.defineMethod("dup", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "dup"));
        objectClass.defineMethod("eql?", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        objectClass.defineMethod("respond_to?", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "respond_to", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        objectClass.defineMethod("extend", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "extend"));
        objectClass.defineMethod("freeze", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "freeze"));
        objectClass.defineMethod("frozen?", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "frozen"));
        objectClass.defineMethod("id", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "id"));
        objectClass.defineMethod("hash", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "id"));
        objectClass.defineMethod("__id__", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "id"));
        objectClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "inspect"));
        objectClass.defineMethod("instance_eval", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "instance_eval"));
        objectClass.defineMethod("instance_of?", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "instance_of", class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyObject.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule));
        objectClass.defineMethod("instance_variables", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "instance_variables"));
        objectClass.defineMethod("is_a?", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "kind_of", class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyObject.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule));
        objectClass.defineMethod("kind_of?", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "kind_of", class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyObject.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule));
        objectClass.defineMethod("method", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "method", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        objectClass.defineMethod("methods", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "methods"));
        objectClass.defineMethod("nil?", CallbackFactory.getFalseMethod());
        objectClass.defineMethod("private_methods", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "private_methods"));
        objectClass.defineMethod("protected_methods", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "protected_methods"));
        objectClass.defineMethod("public_methods", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "methods"));
        objectClass.defineMethod("send", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "send", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        objectClass.defineMethod("__send__", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "send", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        objectClass.defineMethod("taint", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "taint"));
        objectClass.defineMethod("tainted?", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "tainted"));
        objectClass.defineMethod("to_a", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "to_a"));
        objectClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "to_s"));
        objectClass.defineMethod("type", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "type"));
        objectClass.defineMethod("untaint", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "untaint"));
        objectClass.defineAlias("===", "==");
        objectClass.defineAlias("class", "type");
        objectClass.defineAlias("equal?", "==");
        Ruby ruby = objectClass.getRuby();
        ruby.defineGlobalFunction("method_missing", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "method_missing", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
    }

    protected int argCount(RubyObject[] args, int min, int max) {
        int len = args.length;
        if (len < min || max > -1 && len > max) {
            throw new ArgumentError(this.getRuby(), "Wrong # of arguments for method. " + args.length + " is not in Range " + min + ".." + max);
        }
        return len;
    }

    private RubyClass getNilSingletonClass() {
        RubyClass rubyClass = this.getRubyClass();
        if (!rubyClass.isSingleton()) {
            rubyClass = rubyClass.newSingletonClass();
            rubyClass.attachSingletonClass(this);
        }
        return rubyClass;
    }

    public RubyClass getSingletonClass() {
        if (this.isNil()) {
            return this.getNilSingletonClass();
        }
        RubyClass type = null;
        type = this.getRubyClass().isSingleton() ? this.getRubyClass() : this.makeMetaClass(this.getRubyClass());
        type.setTaint(this.isTaint());
        type.setFrozen(this.isFrozen());
        return type;
    }

    public void defineSingletonMethod(String name, Callback method) {
        this.getSingletonClass().defineMethod(name, method);
    }

    protected void setupClone(RubyObject obj) {
        this.setRubyClass(obj.getRubyClass().getSingletonClassClone());
        this.getRubyClass().attachSingletonClass(this);
        this.frozen = obj.frozen;
        this.taint = obj.taint;
    }

    protected void infectObject(RubyObject obj) {
        if (obj.isTaint()) {
            this.setTaint(true);
        }
    }

    public RubyObject funcall(String name, RubyObject[] args) {
        return this.funcall(name, new RubyPointer(args));
    }

    public RubyObject funcall(String name, RubyPointer args) {
        return this.getRubyClass().call(this, name, args, 1);
    }

    public RubyObject funcall(String name) {
        return this.funcall(name, (RubyPointer)null);
    }

    public RubyObject funcall3(String name, RubyPointer args) {
        return this.getRubyClass().call(this, name, args, 0);
    }

    public RubyObject funcall3(String name, RubyObject[] args) {
        return this.funcall3(name, new RubyPointer(args));
    }

    public RubyObject funcall(String name, RubyObject arg) {
        return this.funcall(name, new RubyPointer(new RubyObject[]{arg}));
    }

    public RubyObject getInstanceVar(String name) {
        RubyObject value;
        if (this.getInstanceVariables() != null && (value = (RubyObject)this.getInstanceVariables().get(name)) != null) {
            return value;
        }
        return this.getRuby().getNil();
    }

    public RubyObject setInstanceVar(String name, RubyObject value) {
        if (this.isTaint() && this.getRuby().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't modify instance variable");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuby(), "");
        }
        if (this.getInstanceVariables() == null) {
            this.setInstanceVariables(new RubyHashMap());
        }
        this.getInstanceVariables().put(name, value);
        return value;
    }

    public boolean isInstanceVarDefined(String name) {
        return this.getInstanceVariables() != null && this.getInstanceVariables().get(name) != null;
    }

    public RubyModule getClassVarSingleton() {
        return this.getRubyClass();
    }

    public RubyObject eval(INode n) {
        return n == null ? this.getRuby().getNil() : new EvaluateVisitor(this.getRuby(), this).eval(n);
    }

    public RubyObject evalNode(INode n) {
        if (n == null) {
            return this.getRuby().getNil();
        }
        return this.eval(n);
    }

    public void callInit(RubyObject[] args) {
        this.ruby.getIterStack().push(this.ruby.isBlockGiven() ? Iter.ITER_PRE : Iter.ITER_NOT);
        this.funcall("initialize", args);
        this.ruby.getIterStack().pop();
    }

    public void extendObject(RubyModule module) {
        this.getSingletonClass().includeModule(module);
    }

    public String toId() {
        throw new TypeError(this.getRuby(), this.inspect().getValue() + " is not a symbol");
    }

    public boolean isRespondTo(String name) {
        return this.getRubyClass().isMethodBound(name, 0);
    }

    public RubyObject convertToType(String targetType, String convertMethod, boolean raise) {
        if (!this.isRespondTo(convertMethod)) {
            if (raise) {
                throw new TypeError(this.ruby, "Failed to convert " + this.getRubyClass().toName() + " into " + targetType + ".");
            }
            return this.ruby.getNil();
        }
        return this.funcall(convertMethod);
    }

    public RubyObject convertType(Class type, String targetType, String convertMethod) {
        if (type.isAssignableFrom(this.getClass())) {
            return this;
        }
        RubyObject result = this.convertToType(targetType, convertMethod, true);
        if (!type.isAssignableFrom(result.getClass())) {
            throw new TypeError(this.ruby, this.getRubyClass().toName() + "#" + convertMethod + " should return " + targetType + ".");
        }
        return result;
    }

    public void checkSafeString() {
        if (this.ruby.getSafeLevel() > 0 && this.isTaint()) {
            if (this.ruby.getActFrame().getLastFunc() != null) {
                throw new RubySecurityException(this.ruby, "Insecure operation - " + this.ruby.getActFrame().getLastFunc());
            }
            throw new RubySecurityException(this.ruby, "Insecure operation: -r");
        }
        this.getRuby().secure(4);
        if (!(this instanceof RubyString)) {
            throw new TypeError(this.getRuby(), "wrong argument type " + this.getRubyClass().toName() + " (expected String)");
        }
    }

    public RubyObject specificEval(RubyModule mod, RubyObject[] args) {
        if (this.getRuby().isBlockGiven()) {
            if (args.length > 0) {
                throw new ArgumentError(this.getRuby(), "wrong # of arguments (" + args.length + " for 0)");
            }
            return this.yieldUnder(mod);
        }
        if (args.length == 0) {
            throw new ArgumentError(this.getRuby(), "block not supplied");
        }
        if (args.length > 3) {
            String lastFuncName = this.ruby.getActFrame().getLastFunc();
            throw new ArgumentError(this.getRuby(), "wrong # of arguments: " + lastFuncName + "(src) or " + lastFuncName + "{..}");
        }
        RubyObject file = args.length > 1 ? args[1] : RubyString.newString(this.getRuby(), "(eval)");
        RubyObject line = args.length > 2 ? args[2] : RubyFixnum.one(this.getRuby());
        return this.evalUnder(mod, args[0], file, line);
    }

    public RubyObject evalUnder(RubyModule under, RubyObject src, RubyObject file, RubyObject line) {
        return under.executeUnder(new Callback(){

            public RubyObject execute(RubyObject self, RubyObject[] args, Ruby ruby) {
                return args[0].eval(args[1], ruby.getNil(), ((RubyString)args[2]).getValue(), RubyNumeric.fix2int(args[3]));
            }
        }, new RubyObject[]{this, src, file, line});
    }

    public RubyObject yieldUnder(RubyModule under) {
        return under.executeUnder(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RubyObject execute(RubyObject self, RubyObject[] args, Ruby ruby) {
                Block oldBlock = ruby.getBlock().getAct().cloneBlock();
                ruby.getBlock().getAct().getFrame().setNamespace(ruby.getActFrame().getNamespace());
                RubyObject result = null;
                try {
                    result = ruby.yield0(args[0], args[0], ruby.getRubyClass(), false);
                    Object var7_6 = null;
                    ruby.getBlock().setAct(oldBlock);
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    ruby.getBlock().setAct(oldBlock);
                    throw throwable;
                }
                return result;
            }
        }, new RubyObject[]{this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyObject eval(RubyObject src, RubyObject scope, String file, int line) {
        String fileSave = this.ruby.getSourceFile();
        int lineSave = this.ruby.getSourceLine();
        Iter iter = this.ruby.getActFrame().getIter();
        if (file == null) {
            file = this.ruby.getSourceFile();
            line = this.ruby.getSourceLine();
        }
        if (scope.isNil() && this.ruby.getFrameStack().getPrevious() != null) {
            this.ruby.getActFrame().setIter(this.ruby.getFrameStack().getPrevious().getIter());
        }
        this.getRuby().pushClass(this.ruby.getCBase());
        this.ruby.setInEval(this.ruby.getInEval() + 1);
        if (this.ruby.getRubyClass().isIncluded()) {
            this.ruby.setRubyClass(((RubyIncludedClass)this.ruby.getRubyClass()).getDelegate());
        }
        RubyObject result = this.getRuby().getNil();
        try {
            try {
                INode node = this.getRuby().compile(src.toString(), file, line);
                result = this.evalNode(node);
            }
            catch (RaiseException rExcptn) {
                Object var11_12 = null;
                this.ruby.popClass();
                this.ruby.setInEval(this.ruby.getInEval());
                if (scope.isNil()) {
                    this.ruby.getActFrame().setIter(iter);
                }
                this.ruby.setSourceFile(fileSave);
                this.ruby.setSourceLine(lineSave);
            }
            Object var11_11 = null;
            this.ruby.popClass();
            this.ruby.setInEval(this.ruby.getInEval());
            if (scope.isNil()) {
                this.ruby.getActFrame().setIter(iter);
            }
            this.ruby.setSourceFile(fileSave);
            this.ruby.setSourceLine(lineSave);
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.ruby.popClass();
            this.ruby.setInEval(this.ruby.getInEval());
            if (scope.isNil()) {
                this.ruby.getActFrame().setIter(iter);
            }
            this.ruby.setSourceFile(fileSave);
            this.ruby.setSourceLine(lineSave);
            throw throwable;
        }
        return result;
    }

    public RubyBoolean equal(RubyObject obj) {
        if (this.isNil()) {
            return RubyBoolean.newBoolean(this.getRuby(), obj.isNil());
        }
        return RubyBoolean.newBoolean(this.getRuby(), this == obj);
    }

    public RubyBoolean respond_to(RubyObject methodName) {
        String name;
        if (methodName instanceof RubySymbol) {
            name = ((RubySymbol)methodName).toId();
        } else if (methodName instanceof RubyString) {
            name = ((RubyString)methodName).getValue();
        } else {
            throw new ArgumentError(this.getRuby(), "not a symbol");
        }
        CacheEntry ent = this.getRuby().getMethodCache().getEntry(this.getRubyClass(), name);
        if (ent != null) {
            return this.ruby.getTrue();
        }
        IMethod method = this.getRubyClass().searchMethod(name);
        if (method != null) {
            return this.ruby.getTrue();
        }
        return this.ruby.getFalse();
    }

    public RubyFixnum id() {
        return RubyFixnum.newFixnum(this.getRuby(), System.identityHashCode(this));
    }

    public RubyClass type() {
        return this.getRubyClass().getRealClass();
    }

    public RubyObject rbClone() {
        try {
            RubyObject clone = (RubyObject)this.clone();
            clone.setupClone(this);
            if (this.getInstanceVariables() != null) {
                clone.setInstanceVariables(this.getInstanceVariables().cloneRubyMap());
            }
            return clone;
        }
        catch (CloneNotSupportedException cnsExcptn) {
            throw new RubyBugException(cnsExcptn.getMessage());
        }
    }

    public RubyObject dup() {
        RubyObject dup = this.funcall("clone");
        if (!dup.getClass().equals(this.getClass())) {
            throw new TypeError(this.getRuby(), "duplicated object must be same type");
        }
        dup.setRubyClass(this.type());
        dup.frozen = false;
        return dup;
    }

    public RubyBoolean tainted() {
        if (this.isTaint()) {
            return this.getRuby().getTrue();
        }
        return this.getRuby().getFalse();
    }

    public RubyObject taint() {
        this.getRuby().secure(4);
        if (!this.isTaint()) {
            if (this.isFrozen()) {
                throw new RubyFrozenException(this.getRuby(), "object");
            }
            this.setTaint(true);
        }
        return this;
    }

    public RubyObject untaint() {
        this.getRuby().secure(3);
        if (this.isTaint()) {
            if (this.isFrozen()) {
                throw new RubyFrozenException(this.getRuby(), "object");
            }
            this.setTaint(false);
        }
        return this;
    }

    public RubyObject freeze() {
        if (this.getRuby().getSafeLevel() >= 4 && this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't freeze object");
        }
        this.setFrozen(true);
        return this;
    }

    public RubyBoolean frozen() {
        return RubyBoolean.newBoolean(this.getRuby(), this.isFrozen());
    }

    public RubyString inspect() {
        return (RubyString)this.funcall("to_s");
    }

    public RubyBoolean instance_of(RubyModule type) {
        return RubyBoolean.newBoolean(this.getRuby(), this.type() == type);
    }

    public RubyArray instance_variables() {
        ArrayList<RubyString> names = new ArrayList<RubyString>();
        Iterator iter = this.instanceVariables.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            names.add(RubyString.newString(this.getRuby(), name));
        }
        return RubyArray.newArray(this.ruby, names);
    }

    public RubyBoolean kind_of(RubyModule type) {
        RubyClass currType = this.getRubyClass();
        while (currType != null) {
            if (currType == type || currType.getMethods().keySet().containsAll(type.getMethods().keySet())) {
                return this.getRuby().getTrue();
            }
            currType = currType.getSuperClass();
        }
        return this.getRuby().getFalse();
    }

    public RubyObject methods() {
        return this.getRubyClass().instance_methods(new RubyObject[]{this.getRuby().getTrue()});
    }

    public RubyObject protected_methods() {
        return this.getRubyClass().protected_instance_methods(new RubyObject[]{this.getRuby().getTrue()});
    }

    public RubyObject private_methods() {
        return this.getRubyClass().private_instance_methods(new RubyObject[]{this.getRuby().getTrue()});
    }

    public RubyArray singleton_methods() {
        RubyArray ary = RubyArray.newArray(this.getRuby());
        RubyClass type = this.getRubyClass();
        while (type != null && type.isSingleton()) {
            type.getMethods().foreach(new RubyMapMethod(){

                public int execute(Object key, Object value, Object arg) {
                    RubyString name = RubyString.newString(RubyObject.this.getRuby(), (String)key);
                    if ((((IMethod)value).getNoex() & 6) == 0) {
                        if (((RubyArray)arg).includes(name).isFalse()) {
                            if ((IMethod)value == null) {
                                ((RubyArray)arg).push(RubyObject.this.getRuby().getNil());
                            }
                            ((RubyArray)arg).push(name);
                        }
                    } else if (value instanceof EvaluateMethod && ((EvaluateMethod)value).getNode() instanceof ZSuperNode) {
                        ((RubyArray)arg).push(RubyObject.this.getRuby().getNil());
                        ((RubyArray)arg).push(name);
                    }
                    return 0;
                }
            }, ary);
            type = type.getSuperClass();
        }
        ary.compact_bang();
        return ary;
    }

    public RubyObject method(RubyObject symbol) {
        return this.getRubyClass().newMethod(this, symbol.toId(), this.getRuby().getClasses().getMethodClass());
    }

    public RubyArray to_a() {
        return RubyArray.newArray(this.getRuby(), this);
    }

    public RubyString to_s() {
        String cname = this.getRubyClass().toName();
        RubyString str = RubyString.newString(this.getRuby(), "");
        str.setValue("#<" + cname + ":0x" + Integer.toHexString(System.identityHashCode(this)) + ">");
        str.setTaint(this.isTaint());
        return str;
    }

    public RubyObject instance_eval(RubyObject[] args) {
        return this.specificEval(this.getSingletonClass(), args);
    }

    public RubyObject extend(RubyObject[] args) {
        if (args.length == 0) {
            throw new ArgumentError(this.ruby, "wrong # of arguments");
        }
        int i = 0;
        while (i < args.length) {
            args[i].funcall("extend_object", this);
            ++i;
        }
        return this;
    }

    public RubyObject method_missing(RubyObject symbol, RubyObject[] args) {
        throw new NameError(this.getRuby(), "Undefined local variable or method '" + symbol.toId() + "' for " + this.inspect().getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyObject send(RubyObject method, RubyObject[] args) {
        RubyObject rubyObject;
        try {
            this.getRuby().getIterStack().push(this.getRuby().isBlockGiven() ? Iter.ITER_PRE : Iter.ITER_NOT);
            rubyObject = this.getRubyClass().call(this, method.toId(), new RubyPointer(args), 1);
            Object var5_4 = null;
            this.getRuby().getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getRuby().getIterStack().pop();
            throw throwable;
        }
        return rubyObject;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(111);
        RubySymbol classname = this.getRubyClass().getClassname().intern();
        output.dumpObject(classname);
        if (this.getInstanceVariables() == null) {
            output.dumpInt(0);
        } else {
            output.dumpInt(this.getInstanceVariables().size());
            Iterator iter = this.getInstanceVariables().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                RubyObject value = (RubyObject)entry.getValue();
                output.dumpObject(RubySymbol.newSymbol(this.ruby, name));
                output.dumpObject(value);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

