/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RangeError;
import org.jruby.runtime.CallbackFactory;

public class RubyRange
extends RubyObject {
    private RubyObject begin;
    private RubyObject end;
    private boolean isExclusive;
    static /* synthetic */ Class class$org$jruby$RubyRange;
    static /* synthetic */ Class class$org$jruby$RubyObject;

    public RubyRange(Ruby ruby) {
        super(ruby, ruby.getRubyClass("Range"));
    }

    public void init(RubyObject begin, RubyObject end, RubyBoolean isExclusive) {
        if (!(begin instanceof RubyFixnum) || !(end instanceof RubyFixnum)) {
            try {
                begin.funcall("<=>", end);
            }
            catch (RaiseException rExcptn) {
                throw new ArgumentError(this.getRuby(), "bad value for range");
            }
        }
        this.begin = begin;
        this.end = end;
        this.isExclusive = isExclusive.isTrue();
    }

    public static RubyClass createRangeClass(Ruby ruby) {
        RubyClass rangeClass = ruby.defineClass("Range", ruby.getClasses().getObjectClass());
        rangeClass.includeModule(ruby.getClasses().getEnumerableModule());
        rangeClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyRange.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        rangeClass.defineMethod("===", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "op_eqq", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyRange.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        rangeClass.defineMethod("first", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "first"));
        rangeClass.defineMethod("begin", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "first"));
        rangeClass.defineMethod("last", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "last"));
        rangeClass.defineMethod("end", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "last"));
        rangeClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "inspect"));
        rangeClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "inspect"));
        rangeClass.defineMethod("exclude_end?", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "exclude_end_p"));
        rangeClass.defineMethod("length", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "length"));
        rangeClass.defineMethod("size", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "length"));
        rangeClass.defineMethod("each", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "each"));
        rangeClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "initialize"));
        return rangeClass;
    }

    public long[] getBeginLength(long limit, boolean truncate, boolean isStrict) {
        long beginLong = RubyNumeric.num2long(this.begin);
        long endLong = RubyNumeric.num2long(this.end);
        if (!this.isExclusive) {
            ++endLong;
        }
        if (beginLong < 0L && (beginLong += limit) < 0L) {
            if (isStrict) {
                throw new RangeError(this.ruby, this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (truncate && beginLong > limit) {
            if (isStrict) {
                throw new RangeError(this.ruby, this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (truncate && endLong > limit) {
            endLong = limit;
        }
        if ((endLong < 0L || !this.isExclusive && endLong == 0L) && (endLong += limit) < 0L) {
            if (isStrict) {
                throw new RangeError(this.ruby, this.inspect().toString() + " out of range.");
            }
            return null;
        }
        if (beginLong > endLong) {
            if (isStrict) {
                throw new RangeError(this.ruby, this.inspect().toString() + " out of range.");
            }
            return null;
        }
        return new long[]{beginLong, endLong - beginLong};
    }

    public static RubyRange newRange(Ruby ruby, RubyObject begin, RubyObject end, boolean isExclusive) {
        RubyRange range = new RubyRange(ruby);
        range.init(begin, end, isExclusive ? ruby.getTrue() : ruby.getFalse());
        return range;
    }

    public RubyObject initialize(RubyObject[] args) {
        if (args.length == 3) {
            this.init(args[0], args[1], (RubyBoolean)args[2]);
        } else if (args.length == 2) {
            this.init(args[0], args[1], this.getRuby().getFalse());
        } else {
            throw new ArgumentError(this.getRuby(), "Wrong arguments. (anObject, anObject, aBoolean = false) excepted");
        }
        return this.getRuby().getNil();
    }

    public RubyObject first() {
        return this.begin;
    }

    public RubyObject last() {
        return this.end;
    }

    public RubyString inspect() {
        RubyString begStr = (RubyString)this.begin.funcall("to_s");
        RubyString endStr = (RubyString)this.end.funcall("to_s");
        begStr.cat(this.isExclusive ? "..." : "..");
        begStr.concat(endStr);
        return begStr;
    }

    public RubyBoolean exclude_end_p() {
        return RubyBoolean.newBoolean(this.getRuby(), this.isExclusive);
    }

    public RubyFixnum length() {
        long size = 0L;
        if (this.begin.funcall(">", this.end).isTrue()) {
            return new RubyFixnum(this.getRuby(), 0L);
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            size = ((RubyNumeric)this.end).getLongValue() - ((RubyNumeric)this.begin).getLongValue();
            if (!this.isExclusive) {
                ++size;
            }
        }
        return new RubyFixnum(this.getRuby(), size);
    }

    public RubyBoolean equal(RubyObject obj) {
        if (!(obj instanceof RubyRange)) {
            return this.getRuby().getFalse();
        }
        RubyRange otherRange = (RubyRange)obj;
        boolean result = this.begin.equals(otherRange.begin) && this.end.equals(otherRange.end) && this.isExclusive == otherRange.isExclusive;
        return RubyBoolean.newBoolean(this.getRuby(), result);
    }

    public RubyBoolean op_eqq(RubyObject obj) {
        if (this.begin instanceof RubyFixnum && obj instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            long o;
            long b = RubyNumeric.fix2long(this.begin);
            if (b <= (o = RubyNumeric.fix2long(obj))) {
                long e = RubyNumeric.fix2long(this.end);
                if (this.isExclusive ? o < e : o <= e) {
                    return this.getRuby().getTrue();
                }
            }
            return this.getRuby().getFalse();
        }
        if (this.begin.funcall("<=", obj).isTrue() && (this.isExclusive ? this.end.funcall(">", obj).isTrue() : this.end.funcall(">=", obj).isTrue())) {
            return this.getRuby().getTrue();
        }
        return this.getRuby().getFalse();
    }

    /*
     * Unable to fully structure code
     */
    public RubyObject each() {
        block7: {
            block10: {
                block9: {
                    block8: {
                        if (!(this.begin instanceof RubyFixnum) || !(this.end instanceof RubyFixnum)) break block8;
                        endLong = ((RubyNumeric)this.end).getLongValue();
                        i = ((RubyNumeric)this.begin).getLongValue();
                        if (!this.isExclusive) {
                            ++endLong;
                        }
                        while (i < endLong) {
                            this.getRuby().yield(RubyFixnum.newFixnum(this.getRuby(), i));
                            ++i;
                        }
                        break block7;
                    }
                    if (!(this.begin instanceof RubyString)) break block9;
                    ((RubyString)this.begin).upto(this.end, this.isExclusive);
                    break block7;
                }
                if (!this.begin.kind_of(this.getRuby().getClasses().getNumericClass()).isTrue()) break block10;
                if (!this.isExclusive) {
                    this.end = this.end.funcall("+", RubyFixnum.one(this.getRuby()));
                }
                while (this.begin.funcall("<", this.end).isTrue()) {
                    this.getRuby().yield(this.begin);
                    this.begin = this.begin.funcall("+", RubyFixnum.one(this.getRuby()));
                }
                break block7;
            }
            v = this.begin;
            if (!this.isExclusive) ** GOTO lbl42
            while (v.funcall("<", this.end).isTrue()) {
                if (!v.equals(this.end)) {
                    this.getRuby().yield(v);
                    v = v.funcall("succ");
                    continue;
                }
                break block7;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                this.getRuby().yield(v);
                if (v.equals(this.end)) break;
                v = v.funcall("succ");
lbl42:
                // 2 sources

                ** while (v.funcall((String)"<=", (RubyObject)this.end).isTrue())
            }
        }
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

