/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RubyBugException;
import org.jruby.exceptions.RubyFrozenException;
import org.jruby.exceptions.RubyIndexException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.runtime.CallbackFactory;
import org.jruby.util.IdUtil;

public class RubyStruct
extends RubyObject {
    private RubyObject[] values;
    static /* synthetic */ Class class$org$jruby$RubyStruct;
    static /* synthetic */ Class class$org$jruby$RubyObject;

    public RubyStruct(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createStructClass(Ruby ruby) {
        RubyClass structClass = ruby.defineClass("Struct", ruby.getClasses().getObjectClass());
        structClass.includeModule(ruby.getClasses().getEnumerableModule());
        structClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "newInstance"));
        structClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "initialize"));
        structClass.defineMethod("clone", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "rbClone"));
        structClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyStruct.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        structClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "to_s"));
        structClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "inspect"));
        structClass.defineMethod("to_a", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "to_a"));
        structClass.defineMethod("values", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "to_a"));
        structClass.defineMethod("size", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "size"));
        structClass.defineMethod("length", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "size"));
        structClass.defineMethod("each", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "each"));
        structClass.defineMethod("[]", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "aref", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyStruct.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        structClass.defineMethod("[]=", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "aset", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyStruct.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyStruct.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        structClass.defineMethod("members", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "members"));
        return structClass;
    }

    private static RubyObject getInstanceVariable(RubyClass type, String name) {
        RubyClass structClass = type.getRuby().getClasses().getStructClass();
        while (type != null && type != structClass) {
            if (type.isInstanceVarDefined(name)) {
                return type.getInstanceVar(name);
            }
            type = type.getSuperClass();
        }
        return type.getRuby().getNil();
    }

    private RubyClass classOf() {
        return this.getRubyClass().isSingleton() ? this.getRubyClass().getSuperClass() : this.getRubyClass();
    }

    private void modify() {
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.ruby, "Struct is frozen.");
        }
        if (!this.isTaint() && this.ruby.getSafeLevel() >= 4) {
            throw new RubySecurityException(this.ruby, "Insecure: can't modify struct");
        }
    }

    private RubyObject setByName(String name, RubyObject value) {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        if (member.isNil()) {
            throw new RubyBugException("uninitialized struct");
        }
        this.modify();
        int i = 0;
        while (i < member.getLength()) {
            if (member.entry(i).toId().equals(name)) {
                this.values[i] = value;
                return this.values[i];
            }
            ++i;
        }
        throw new NameError(this.ruby, name + " is not struct member");
    }

    private RubyObject getByName(String name) {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        if (member.isNil()) {
            throw new RubyBugException("uninitialized struct");
        }
        int i = 0;
        while (i < member.getLength()) {
            if (member.entry(i).toId().equals(name)) {
                return this.values[i];
            }
            ++i;
        }
        throw new NameError(this.ruby, name + " is not struct member");
    }

    public static RubyClass newInstance(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyClass newStruct;
        String name = null;
        if (args.length > 0 && args[0] instanceof RubyString) {
            name = args[0].toString();
        }
        RubyArray member = RubyArray.newArray(ruby);
        int i = name == null ? 0 : 1;
        while (i < args.length) {
            member.push(RubySymbol.newSymbol(ruby, args[i].toId()));
            ++i;
        }
        if (name == null) {
            newStruct = RubyClass.newClass(ruby, (RubyClass)recv);
        } else {
            if (!IdUtil.isConstant(name)) {
                throw new NameError(ruby, "identifier " + name + " needs to be constant");
            }
            newStruct = ((RubyClass)recv).defineClassUnder(name, (RubyClass)recv);
        }
        newStruct.setInstanceVar("__size__", member.length());
        newStruct.setInstanceVar("__member__", member);
        newStruct.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "newStruct"));
        newStruct.defineSingletonMethod("[]", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "newStruct"));
        newStruct.defineSingletonMethod("members", CallbackFactory.getSingletonMethod(class$org$jruby$RubyStruct == null ? (class$org$jruby$RubyStruct = RubyStruct.class$("org.jruby.RubyStruct")) : class$org$jruby$RubyStruct, "members"));
        int i2 = name == null ? 0 : 1;
        while (i2 < args.length) {
            newStruct.defineMethod(args[i2].toId(), CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? RubyStruct.class$("org.jruby.RubyStruct") : class$org$jruby$RubyStruct, "get", class$org$jruby$RubyObject == null ? RubyStruct.class$("org.jruby.RubyObject") : class$org$jruby$RubyObject));
            newStruct.defineMethod(args[i2].toId() + "=", CallbackFactory.getMethod(class$org$jruby$RubyStruct == null ? RubyStruct.class$("org.jruby.RubyStruct") : class$org$jruby$RubyStruct, "set", class$org$jruby$RubyObject == null ? RubyStruct.class$("org.jruby.RubyObject") : class$org$jruby$RubyObject));
            ++i2;
        }
        return newStruct;
    }

    public static RubyStruct newStruct(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyStruct struct = new RubyStruct(ruby, (RubyClass)recv);
        int size = RubyFixnum.fix2int(RubyStruct.getInstanceVariable((RubyClass)recv, "__size___"));
        struct.values = new RubyObject[size];
        struct.callInit(args);
        return struct;
    }

    public RubyObject initialize(RubyObject[] args) {
        this.modify();
        int size = RubyFixnum.fix2int(RubyStruct.getInstanceVariable(this.getRubyClass(), "__size___"));
        if (args.length > size) {
            throw new ArgumentError(this.ruby, "struct size differs");
        }
        int i = 0;
        while (i < args.length) {
            this.values[i] = args[i];
            ++i;
        }
        int i2 = args.length;
        while (i2 < size) {
            this.values[i2] = this.ruby.getNil();
            ++i2;
        }
        return this.ruby.getNil();
    }

    public static RubyArray members(Ruby ruby, RubyObject recv) {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable((RubyClass)recv, "__member__");
        if (member.isNil()) {
            throw new RubyBugException("uninitialized struct");
        }
        RubyArray result = RubyArray.newArray(ruby, member.getLength());
        int i = 0;
        while (i < member.getLength()) {
            result.push(RubyString.newString(ruby, member.entry(i).toId()));
            ++i;
        }
        return result;
    }

    public RubyArray members() {
        return RubyStruct.members(this.ruby, this.classOf());
    }

    public RubyObject set(RubyObject value) {
        String name = this.ruby.getActFrame().getLastFunc();
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        if (member.isNil()) {
            throw new RubyBugException("uninitialized struct");
        }
        this.modify();
        int i = 0;
        while (i < member.getLength()) {
            if (member.entry(i).toId().equals(name)) {
                this.values[i] = value;
                return this.values[i];
            }
            ++i;
        }
        throw new NameError(this.ruby, name + " is not struct member");
    }

    public RubyObject get() {
        String name = this.ruby.getActFrame().getLastFunc();
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        if (member.isNil()) {
            throw new RubyBugException("uninitialized struct");
        }
        int i = 0;
        while (i < member.getLength()) {
            if (member.entry(i).toId().equals(name)) {
                return this.values[i];
            }
            ++i;
        }
        throw new NameError(this.ruby, name + " is not struct member");
    }

    public RubyObject rbClone() {
        RubyStruct clone = new RubyStruct(this.ruby, this.getRubyClass());
        clone.values = new RubyObject[this.values.length];
        System.arraycopy(this.values, 0, clone.values, 0, this.values.length);
        return clone;
    }

    public RubyBoolean equal(RubyObject other) {
        if (this == other) {
            return this.ruby.getTrue();
        }
        if (!(other instanceof RubyStruct)) {
            return this.ruby.getFalse();
        }
        if (this.getRubyClass() != other.getRubyClass()) {
            return this.ruby.getFalse();
        }
        int i = 0;
        while (i < this.values.length) {
            if (!this.values[i].equals(((RubyStruct)other).values[i])) {
                return this.ruby.getFalse();
            }
            ++i;
        }
        return this.ruby.getTrue();
    }

    public RubyString to_s() {
        return RubyString.newString(this.ruby, "#<" + this.getRubyClass().toName() + ">");
    }

    public RubyString inspect() {
        RubyArray member = (RubyArray)RubyStruct.getInstanceVariable(this.classOf(), "__member__");
        if (member.isNil()) {
            throw new RubyBugException("uninitialized struct");
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("#<").append(this.getRubyClass().toName()).append(' ');
        int i = 0;
        while (i < member.getLength()) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(member.entry(i).toId()).append("=");
            sb.append(this.values[i].funcall("inspect"));
            ++i;
        }
        sb.append('>');
        return RubyString.newString(this.ruby, sb.toString());
    }

    public RubyArray to_a() {
        return RubyArray.newArray(this.ruby, Arrays.asList(this.values));
    }

    public RubyFixnum size() {
        return RubyFixnum.newFixnum(this.ruby, this.values.length);
    }

    public RubyObject each() {
        int i = 0;
        while (i < this.values.length) {
            this.ruby.yield(this.values[i]);
            ++i;
        }
        return this;
    }

    public RubyObject aref(RubyObject key) {
        if (key instanceof RubyString || key instanceof RubySymbol) {
            return this.getByName(key.toId());
        }
        int idx = RubyFixnum.fix2int(key);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw new RubyIndexException(this.ruby, "offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw new RubyIndexException(this.ruby, "offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        return this.values[idx];
    }

    public RubyObject aset(RubyObject key, RubyObject value) {
        if (key instanceof RubyString || key instanceof RubySymbol) {
            return this.setByName(key.toId(), value);
        }
        int idx = RubyFixnum.fix2int(key);
        int n = idx = idx < 0 ? this.values.length + idx : idx;
        if (idx < 0) {
            throw new RubyIndexException(this.ruby, "offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        if (idx >= this.values.length) {
            throw new RubyIndexException(this.ruby, "offset " + idx + " too large for struct (size:" + this.values.length + ")");
        }
        this.modify();
        this.values[idx] = value;
        return this.values[idx];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

