/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.TypeError;
import org.jruby.marshal.MarshalStream;
import org.jruby.marshal.UnmarshalStream;
import org.jruby.runtime.CallbackFactory;

public class RubySymbol
extends RubyObject {
    private final String symbol;
    static /* synthetic */ Class class$org$jruby$RubySymbol;
    static /* synthetic */ Class class$org$jruby$RubyObject;

    public RubySymbol(Ruby ruby, String symbol) {
        super(ruby, ruby.getClasses().getSymbolClass());
        this.symbol = symbol.intern();
    }

    public String toId() {
        return this.symbol;
    }

    public static RubySymbol nilSymbol(Ruby ruby) {
        return new RubySymbol(ruby, null){

            public boolean isNil() {
                return true;
            }
        };
    }

    public static RubyClass createSymbolClass(Ruby ruby) {
        RubyClass symbolClass = ruby.defineClass("Symbol", ruby.getClasses().getObjectClass());
        symbolClass.getRubyClass().undefMethod("new");
        symbolClass.defineMethod("id", CallbackFactory.getMethod(class$org$jruby$RubySymbol == null ? (class$org$jruby$RubySymbol = RubySymbol.class$("org.jruby.RubySymbol")) : class$org$jruby$RubySymbol, "id"));
        symbolClass.defineMethod("to_i", CallbackFactory.getMethod(class$org$jruby$RubySymbol == null ? (class$org$jruby$RubySymbol = RubySymbol.class$("org.jruby.RubySymbol")) : class$org$jruby$RubySymbol, "to_i"));
        symbolClass.defineMethod("to_int", CallbackFactory.getMethod(class$org$jruby$RubySymbol == null ? (class$org$jruby$RubySymbol = RubySymbol.class$("org.jruby.RubySymbol")) : class$org$jruby$RubySymbol, "to_i"));
        symbolClass.defineMethod("id2name", CallbackFactory.getMethod(class$org$jruby$RubySymbol == null ? (class$org$jruby$RubySymbol = RubySymbol.class$("org.jruby.RubySymbol")) : class$org$jruby$RubySymbol, "to_s"));
        symbolClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubySymbol == null ? (class$org$jruby$RubySymbol = RubySymbol.class$("org.jruby.RubySymbol")) : class$org$jruby$RubySymbol, "to_s"));
        symbolClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubySymbol == null ? (class$org$jruby$RubySymbol = RubySymbol.class$("org.jruby.RubySymbol")) : class$org$jruby$RubySymbol, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubySymbol.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        symbolClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubySymbol == null ? (class$org$jruby$RubySymbol = RubySymbol.class$("org.jruby.RubySymbol")) : class$org$jruby$RubySymbol, "inspect"));
        symbolClass.defineMethod("hash", CallbackFactory.getMethod(class$org$jruby$RubySymbol == null ? (class$org$jruby$RubySymbol = RubySymbol.class$("org.jruby.RubySymbol")) : class$org$jruby$RubySymbol, "hash"));
        symbolClass.defineMethod("dup", CallbackFactory.getMethod(class$org$jruby$RubySymbol == null ? (class$org$jruby$RubySymbol = RubySymbol.class$("org.jruby.RubySymbol")) : class$org$jruby$RubySymbol, "rbClone"));
        symbolClass.defineMethod("clone", CallbackFactory.getMethod(class$org$jruby$RubySymbol == null ? (class$org$jruby$RubySymbol = RubySymbol.class$("org.jruby.RubySymbol")) : class$org$jruby$RubySymbol, "rbClone"));
        symbolClass.defineMethod("freeze", CallbackFactory.getSelfMethod());
        symbolClass.defineMethod("taint", CallbackFactory.getSelfMethod());
        return symbolClass;
    }

    public static RubySymbol newSymbol(Ruby ruby, String name) {
        if (name != null) {
            return new RubySymbol(ruby, name);
        }
        return RubySymbol.nilSymbol(ruby);
    }

    public RubyFixnum id() {
        return RubyFixnum.newFixnum(this.getRuby(), this.symbol.hashCode());
    }

    public RubyFixnum to_i() {
        return this.hash();
    }

    public RubyString inspect() {
        return RubyString.newString(this.getRuby(), ":" + this.symbol);
    }

    public RubyString to_s() {
        return RubyString.newString(this.getRuby(), this.symbol);
    }

    public RubyFixnum hash() {
        return this.id();
    }

    public RubyBoolean equal(RubyObject other) {
        if (!(other instanceof RubySymbol)) {
            return this.getRuby().getFalse();
        }
        return RubyBoolean.newBoolean(this.getRuby(), this.symbol == ((RubySymbol)other).symbol);
    }

    public RubyObject rbClone() {
        throw new TypeError(this.getRuby(), "can't clone Symbol");
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(58);
        output.dumpString(this.symbol);
    }

    public static RubySymbol unmarshalFrom(UnmarshalStream input) throws IOException {
        return RubySymbol.newSymbol(input.getRuby(), input.unmarshalString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

