/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.util;

import org.ablaf.ast.INode;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;
import org.jruby.evaluator.EvaluateVisitor;
import org.jruby.runtime.Block;
import org.jruby.runtime.Iter;
import org.jruby.util.RubyPointer;

public class ArgsUtil {
    public static Block beginCallArgs(Ruby ruby) {
        Block actBlock = ruby.getBlock().getAct();
        if (ruby.getActIter().isPre()) {
            ruby.getBlock().pop();
        }
        ruby.getIterStack().push(Iter.ITER_NOT);
        return actBlock;
    }

    public static void endCallArgs(Ruby ruby, Block actBlock) {
        if (actBlock != null) {
            ruby.getBlock().push(actBlock);
        }
        ruby.getIterStack().pop();
    }

    public static RubyPointer setupArgs(Ruby ruby, EvaluateVisitor visitor, INode node) {
        if (node != null) {
            String file = ruby.getSourceFile();
            int line = ruby.getSourceLine();
            RubyObject args = visitor.eval(node);
            if (!(args instanceof RubyArray)) {
                args = RubyArray.newArray(ruby, args);
            }
            ruby.setSourceFile(file);
            ruby.setSourceLine(line);
            return new RubyPointer(((RubyArray)args).getList());
        }
        return null;
    }
}

