/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyClass;

public class WrapperClassGenerator {
    public static void main(String[] args) throws IOException {
        Ruby ruby = Ruby.getDefaultInstance(null);
        String fc = WrapperClassGenerator.loadFile(args[0]);
        ruby.evalScript(fc, null);
        RubyClass type = ruby.getRubyClass(args[1]);
        WrapperClassGenerator.generateWrapper(type);
    }

    private static void generateWrapper(RubyClass type) throws IOException {
        String name = type.name().toString();
        RubyClass superClass = type.getSuperClass();
        Class javaClass = type.getRuby().getJavaSupport().getJavaClass(superClass);
        PrintWriter pw = new PrintWriter(new FileWriter(name + ".java"));
        pw.println("import org.jruby.*;");
        pw.println("import org.jruby.javasupport.*;");
        pw.println();
        pw.println("public class " + name + " extends " + javaClass.getName() + "{");
        pw.println("    private static Ruby ruby = null;");
        pw.println();
        pw.println("    private RubyObject __object__ = null;");
        pw.println();
        pw.println("    static {");
        pw.println("        ruby = new " + name + "Script().__start__(new String[]{});");
        pw.println("    }");
        pw.println();
        pw.println("    public " + name + "() {");
        pw.println("        __object__ = ruby.getRubyClass(\"" + name + "\").funcall(\"new\");");
        pw.println("    }");
        pw.println();
        Iterator iter = type.getMethods().keySet().iterator();
        while (iter.hasNext()) {
            String methodname = (String)iter.next();
            if (methodname.equals("new")) continue;
            int i = 0;
            while (i < javaClass.getMethods().length) {
                if (javaClass.getMethods()[i].getName().equals(methodname)) {
                    WrapperClassGenerator.generateMethod(methodname, javaClass.getMethods()[i], pw);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < javaClass.getDeclaredMethods().length) {
                if (javaClass.getDeclaredMethods()[i2].getName().equals(methodname)) {
                    WrapperClassGenerator.generateMethod(methodname, javaClass.getDeclaredMethods()[i2], pw);
                }
                ++i2;
            }
        }
        pw.println("}");
        pw.close();
    }

    private static void generateMethod(String name, Method method, PrintWriter pw) throws IOException {
        pw.print("    public " + method.getReturnType().getName() + " " + name + "(");
        int i = 0;
        while (i < method.getParameterTypes().length) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(method.getParameterTypes()[i].getName());
            pw.print(" arg" + i);
            ++i;
        }
        pw.println(") {");
        pw.print("    RubyObject result = __object__.funcall(\"" + name + "\", JavaUtil.convertJavaArrayToRuby(ruby, new Object[] {");
        int i2 = 0;
        while (i2 < method.getParameterTypes().length) {
            pw.print("arg" + i2 + ", ");
            ++i2;
        }
        pw.println("}));");
        if (method.getReturnType() != Void.TYPE) {
            pw.println("    return JavaUtil.convertRubyToJava(ruby, result, " + method.getReturnType() + ".class)");
        }
        pw.println("    }");
        pw.println();
    }

    /*
     * WARNING - void declaration
     */
    private static String loadFile(String fileName) {
        try {
            String line;
            File rubyFile = new File(fileName);
            StringBuffer sb = new StringBuffer((int)rubyFile.length());
            BufferedReader br = new BufferedReader(new FileReader(rubyFile));
            while ((line = br.readLine()) != null) {
                void var4_5;
                sb.append((String)var4_5).append('\n');
            }
            br.close();
            return sb.toString();
        }
        catch (IOException ioExcptn) {
            return "";
        }
    }
}

