/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.ablaf.ast.INode;
import org.ablaf.common.IErrorHandler;
import org.ablaf.common.ISourcePosition;
import org.ablaf.lexer.LexerFactory;
import org.jruby.Builtins;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrSetNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnCurrNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.ExpandArrayNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OptNNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.RestArgsNode;
import org.jruby.ast.RetryNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.ScopeNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZArrayNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.IListNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.DefinedVisitor;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.BreakJump;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.NextJump;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RedoJump;
import org.jruby.exceptions.RetryException;
import org.jruby.exceptions.ReturnException;
import org.jruby.exceptions.RubyBugException;
import org.jruby.exceptions.RubyFrozenException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.TypeError;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.EvaluateMethod;
import org.jruby.parser.IRubyParserResult;
import org.jruby.parser.RubyParserConfiguration;
import org.jruby.runtime.Block;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Namespace;
import org.jruby.runtime.RubyVarmap;
import org.jruby.runtime.methods.IMethod;
import org.jruby.util.RubyPointer;

public final class EvaluateVisitor
implements NodeVisitor {
    private Ruby ruby;
    private Builtins builtins;
    private IErrorHandler errorHandler;
    private RubyObject self;
    private RubyObject result;
    private INode _curNode;
    private ISourcePosition _curPos;

    public EvaluateVisitor(Ruby ruby, RubyObject self) {
        this.ruby = ruby;
        this.self = self;
        this.builtins = new Builtins(ruby);
    }

    private void setPosition(INode inode) {
        this._curNode = inode;
        ISourcePosition lPos = this._curNode.getPosition();
        if (lPos != null) {
            this._curPos = lPos;
        }
    }

    private boolean isTrace() {
        return this.ruby.getRuntime().getTraceFunction() != null;
    }

    private void callTraceFunction(String event, String file, int line, RubyObject self, String name, RubyObject type) {
        this.ruby.getRuntime().callTraceFunction(event, file, line, self, name, type);
    }

    public RubyObject eval(INode node) {
        this.result = this.ruby.getNil();
        try {
            if (node != null) {
                node.accept(this);
            }
        }
        catch (JumpException lJump) {
            throw lJump;
        }
        catch (RubyBugException lException) {
            throw lException;
        }
        catch (RuntimeException e) {
            System.err.println("native exception thrown when evaluating Node " + this._curNode + " at position: " + this._curPos);
            e.printStackTrace();
            RubyBugException lBug = new RubyBugException(e.getClass().getName() + ": " + e.getMessage());
            lBug.initCause(e);
            throw lBug;
        }
        return this.result;
    }

    public void visitAliasNode(AliasNode iVisited) {
        this.setPosition(iVisited);
        if (this.ruby.getRubyClass() == null) {
            throw new TypeError(this.ruby, "no class to make alias");
        }
        this.ruby.getRubyClass().aliasMethod(iVisited.getNewName(), iVisited.getOldName());
        this.ruby.getRubyClass().funcall("method_added", this.builtins.toSymbol(iVisited.getNewName()));
    }

    public void visitAndNode(AndNode iVisited) {
        this.setPosition(iVisited);
        if (this.eval(iVisited.getFirstNode()).isTrue()) {
            this.eval(iVisited.getSecondNode());
        }
    }

    public void visitArgsNode(ArgsNode iVisited) {
        this.setPosition(iVisited);
    }

    public void visitArrayNode(ArrayNode iVisited) {
        this.setPosition(iVisited);
        ArrayList<RubyObject> list = new ArrayList<RubyObject>();
        Iterator iterator = iVisited.iterator();
        while (iterator.hasNext()) {
            INode node = (INode)iterator.next();
            if (node instanceof ExpandArrayNode) {
                list.addAll(((RubyArray)this.eval(node)).getList());
                continue;
            }
            list.add(this.eval(node));
        }
        this.result = RubyArray.newArray(this.ruby, list);
    }

    public void visitAttrSetNode(AttrSetNode iVisited) {
        this.setPosition(iVisited);
        if (this.ruby.getActFrame().getArgs().size() != 1) {
            throw new ArgumentError(this.ruby, "wrong # of arguments(" + this.ruby.getActFrame().getArgs().size() + "for 1)");
        }
        this.result = this.self.setInstanceVar(iVisited.getAttributeName(), (RubyObject)this.ruby.getActFrame().getArgs().get(0));
    }

    public void visitBackRefNode(BackRefNode iVisited) {
        this.setPosition(iVisited);
        switch (iVisited.getType()) {
            case '&': {
                this.result = RubyRegexp.last_match(this.ruby.getBackref());
                break;
            }
            case '`': {
                this.result = RubyRegexp.match_pre(this.ruby.getBackref());
                break;
            }
            case '\'': {
                this.result = RubyRegexp.match_post(this.ruby.getBackref());
                break;
            }
            case '+': {
                this.result = RubyRegexp.match_last(this.ruby.getBackref());
            }
        }
    }

    public void visitBeginNode(BeginNode iVisited) {
        this.setPosition(iVisited);
        this.eval(iVisited.getBodyNode());
    }

    public void visitBlockArgNode(BlockArgNode iVisited) {
        this.setPosition(iVisited);
    }

    public void visitBlockNode(BlockNode iVisited) {
        this.setPosition(iVisited);
        Iterator iter = iVisited.iterator();
        while (iter.hasNext()) {
            this.eval((INode)iter.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitBlockPassNode(BlockPassNode iVisited) {
        this.setPosition(iVisited);
        RubyObject block = this.eval(iVisited.getBodyNode());
        if (block.isNil()) {
            this.eval(iVisited.getIterNode());
            return;
        }
        if (!block.kind_of(this.ruby.getClasses().getMethodClass()).isTrue() && !(block instanceof RubyProc)) {
            throw new TypeError(this.ruby, "wrong argument type " + block.getRubyClass().toName() + " (expected Proc)");
        }
        Block oldBlock = this.ruby.getBlock().getAct();
        this.ruby.getBlock().push(((RubyProc)block).getBlock());
        this.ruby.getIterStack().push(Iter.ITER_PRE);
        this.ruby.getActFrame().setIter(Iter.ITER_PRE);
        try {
            this.eval(iVisited.getIterNode());
            Object var5_4 = null;
            this.ruby.getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.ruby.getIterStack().pop();
            this.ruby.getBlock().setAct(oldBlock);
            throw throwable;
        }
        this.ruby.getBlock().setAct(oldBlock);
    }

    public void visitBreakNode(BreakNode iVisited) {
        this.setPosition(iVisited);
        throw new BreakJump();
    }

    public void visitConstDeclNode(ConstDeclNode iVisited) {
        this.setPosition(iVisited);
        if (this.ruby.getRubyClass() == null) {
            throw new TypeError(this.ruby, "no class/module to define constant");
        }
        this.ruby.getRubyClass().setConstant(iVisited.getName(), this.eval(iVisited.getValueNode()));
    }

    public void visitClassVarAsgnNode(ClassVarAsgnNode iVisited) {
        this.setPosition(iVisited);
        this.eval(iVisited.getValueNode());
        this.ruby.getCBase().setClassVar(iVisited.getName(), this.result);
    }

    public void visitClassVarDeclNode(ClassVarDeclNode iVisited) {
        this.setPosition(iVisited);
        if (this.ruby.getCBase() == null) {
            throw new TypeError(this.ruby, "no class/module to define class variable");
        }
        this.eval(iVisited.getValueNode());
        if (this.ruby.isVerbose() && this.ruby.getCBase().isSingleton()) {
            this.errorHandler.handleError(1, iVisited.getPosition(), "Declaring singleton class variable.");
        }
        this.ruby.getCBase().declareClassVar(iVisited.getName(), this.result);
    }

    public void visitClassVarNode(ClassVarNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.ruby.getCBase() == null ? this.self.getRubyClass().getClassVar(iVisited.getName()) : (!this.ruby.getCBase().isSingleton() ? this.ruby.getCBase().getClassVar(iVisited.getName()) : ((RubyModule)this.ruby.getCBase().getInstanceVar("__attached__")).getClassVar(iVisited.getName()));
    }

    public void visitCallNode(CallNode iVisited) {
        this.setPosition(iVisited);
        Block tmpBlock = ArgsUtil.beginCallArgs(this.ruby);
        RubyObject receiver = this.eval(iVisited.getReceiverNode());
        RubyPointer args = ArgsUtil.setupArgs(this.ruby, this, iVisited.getArgsNode());
        ArgsUtil.endCallArgs(this.ruby, tmpBlock);
        this.result = receiver.getRubyClass().call(receiver, iVisited.getName(), args, 0);
    }

    public void visitCaseNode(CaseNode iVisited) {
        this.setPosition(iVisited);
        if (iVisited.getCaseNode() != null) {
            RubyObject expression = this.eval(iVisited.getCaseNode());
            Iterator iter = iVisited.getWhenNodes().iterator();
            while (iter.hasNext()) {
                WhenNode whenNode = (WhenNode)iter.next();
                this.ruby.setSourceLine(whenNode.getPosition().getLine());
                this.ruby.setSourceFile(whenNode.getPosition().getFile());
                if (this.isTrace()) {
                    this.callTraceFunction("line", this.ruby.getSourceFile(), this.ruby.getSourceLine(), this.self, this.ruby.getActFrame().getLastFunc(), this.ruby.getActFrame().getLastClass());
                }
                RubyArray expressions = (RubyArray)this.eval(whenNode.getExpressionNodes());
                int i = 0;
                while (i < expressions.getLength()) {
                    if (expressions.entry(i).funcall("===", expression).isTrue()) {
                        this.eval(whenNode);
                        return;
                    }
                    ++i;
                }
            }
        } else {
            Iterator iter = iVisited.getWhenNodes().iterator();
            while (iter.hasNext()) {
                WhenNode whenNode = (WhenNode)iter.next();
                this.ruby.setSourceLine(whenNode.getPosition().getLine());
                this.ruby.setSourceFile(whenNode.getPosition().getFile());
                if (this.isTrace()) {
                    this.callTraceFunction("line", this.ruby.getSourceFile(), this.ruby.getSourceLine(), this.self, this.ruby.getActFrame().getLastFunc(), this.ruby.getActFrame().getLastClass());
                }
                RubyArray expressions = (RubyArray)this.eval(whenNode.getExpressionNodes());
                int i = 0;
                while (i < expressions.getLength()) {
                    if (expressions.entry(i).isTrue()) {
                        this.eval(whenNode);
                        return;
                    }
                    ++i;
                }
            }
        }
        this.eval(iVisited.getElseNode());
    }

    public void visitClassNode(ClassNode iVisited) {
        this.setPosition(iVisited);
        if (this.ruby.getRubyClass() == null) {
            throw new TypeError(this.ruby, "no outer class/module");
        }
        RubyClass superClass = null;
        if (iVisited.getSuperNode() != null) {
            try {
                superClass = (RubyClass)this.eval(iVisited.getSuperNode());
            }
            catch (Exception excptn) {
                if (iVisited.getSuperNode() instanceof Colon2Node) {
                    throw new TypeError(this.ruby, "undefined superclass '" + ((Colon2Node)iVisited.getSuperNode()).getName() + "'");
                }
                if (iVisited.getSuperNode() instanceof ConstNode) {
                    throw new TypeError(this.ruby, "undefined superclass '" + ((ConstNode)iVisited.getSuperNode()).getName() + "'");
                }
                throw new TypeError(this.ruby, "undefined superclass");
            }
            if (superClass != null && superClass.isSingleton()) {
                throw new TypeError(this.ruby, "can't make subclass of virtual class");
            }
        }
        RubyClass rubyClass = null;
        if (this.ruby.getRubyClass().isConstantDefined(iVisited.getClassName())) {
            RubyObject type = this.ruby.getRubyClass().getConstant(iVisited.getClassName());
            if (!(type instanceof RubyClass)) {
                throw new TypeError(this.ruby, iVisited.getClassName() + " is not a class");
            }
            rubyClass = (RubyClass)type;
            if (superClass != null && rubyClass.getSuperClass().getRealClass() != superClass) {
                rubyClass = this.ruby.defineClass(iVisited.getClassName(), superClass);
                rubyClass.setClassPath(this.ruby.getRubyClass(), iVisited.getClassName());
                this.ruby.getRubyClass().setConstant(iVisited.getClassName(), rubyClass);
            } else if (this.ruby.getSafeLevel() >= 4) {
                throw new RubySecurityException(this.ruby, "extending class prohibited");
            }
        } else {
            if (superClass == null) {
                superClass = this.ruby.getClasses().getObjectClass();
            }
            rubyClass = this.ruby.defineClass(iVisited.getClassName(), superClass);
            this.ruby.getRubyClass().setConstant(iVisited.getClassName(), rubyClass);
            rubyClass.setClassPath(this.ruby.getRubyClass(), iVisited.getClassName());
        }
        if (this.ruby.getWrapper() != null) {
            rubyClass.extendObject(this.ruby.getWrapper());
            rubyClass.includeModule(this.ruby.getWrapper());
        }
        this.evalClassDefinitionBody(iVisited.getBodyNode(), rubyClass);
    }

    public void visitColon2Node(Colon2Node iVisited) {
        this.setPosition(iVisited);
        this.eval(iVisited.getLeftNode());
        this.result = this.result instanceof RubyModule ? ((RubyModule)this.result).getConstant(iVisited.getName()) : this.result.funcall(iVisited.getName());
    }

    public void visitColon3Node(Colon3Node iVisited) {
        this.setPosition(iVisited);
        this.result = this.ruby.getClasses().getObjectClass().getConstant(iVisited.getName());
    }

    public void visitConstNode(ConstNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.ruby.getActFrame().getNamespace().getConstant(this.self, iVisited.getName());
    }

    public void visitDAsgnCurrNode(DAsgnCurrNode iVisited) {
        this.setPosition(iVisited);
        this.eval(iVisited.getValueNode());
        RubyVarmap.assignCurrent(this.ruby, iVisited.getName(), this.result);
    }

    public void visitDAsgnNode(DAsgnNode iVisited) {
        this.setPosition(iVisited);
        this.eval(iVisited.getValueNode());
        RubyVarmap.assign(this.ruby, iVisited.getName(), this.result);
    }

    public void visitDRegxNode(DRegexpNode iVisited) {
        this.setPosition(iVisited);
        StringBuffer sb = new StringBuffer();
        Iterator iterator = iVisited.iterator();
        while (iterator.hasNext()) {
            INode node = (INode)iterator.next();
            sb.append(this.eval(node));
        }
        this.result = RubyRegexp.newRegexp(this.ruby, sb.toString(), iVisited.getOptions());
    }

    public void visitDStrNode(DStrNode iVisited) {
        this.setPosition(iVisited);
        StringBuffer sb = new StringBuffer();
        Iterator iterator = iVisited.iterator();
        while (iterator.hasNext()) {
            INode node = (INode)iterator.next();
            sb.append(this.eval(node));
        }
        this.result = this.builtins.toString(sb.toString());
    }

    public void visitDVarNode(DVarNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.ruby.getDynamicVars().getRef(this.ruby, iVisited.getName());
    }

    public void visitDXStrNode(DXStrNode iVisited) {
        this.setPosition(iVisited);
        StringBuffer sb = new StringBuffer();
        Iterator iterator = iVisited.iterator();
        while (iterator.hasNext()) {
            INode node = (INode)iterator.next();
            sb.append(this.eval(node));
        }
        this.result = this.self.funcall("`", this.builtins.toString(sb.toString()));
    }

    public void visitDefinedNode(DefinedNode iVisited) {
        this.setPosition(iVisited);
        String def = new DefinedVisitor(this.ruby, this.self).getDefinition(iVisited.getExpressionNode());
        if (def != null) {
            this.result = this.builtins.toString(def);
        }
    }

    public void visitDefnNode(DefnNode iVisited) {
        this.setPosition(iVisited);
        RubyModule rubyClass = this.ruby.getRubyClass();
        if (rubyClass == null) {
            throw new TypeError(this.ruby, "No class to add method.");
        }
        IMethod method = rubyClass.searchMethod(iVisited.getName());
        int noex = this.ruby.isScope(1) || iVisited.getName().equals("initialize") ? 2 : (this.ruby.isScope(2) ? 4 : (rubyClass == this.ruby.getClasses().getObjectClass() ? iVisited.getNoex() : 0));
        if (method != null && method.getImplementationClass() == rubyClass && (method.getNoex() & 1) != 0) {
            noex |= 1;
        }
        DefaultMethod newMethod = new DefaultMethod(iVisited.getBodyNode(), (ArgsNode)iVisited.getArgsNode(), this.ruby.getNamespace());
        rubyClass.addMethod(iVisited.getName(), newMethod, noex);
        if (this.ruby.getActMethodScope() == 5) {
            rubyClass.getSingletonClass().addMethod(iVisited.getName(), newMethod, 0);
            rubyClass.funcall("singleton_method_added", this.builtins.toSymbol(iVisited.getName()));
        }
        if (rubyClass.isSingleton()) {
            rubyClass.getInstanceVar("__attached__").funcall("singleton_method_added", this.builtins.toSymbol(iVisited.getName()));
        } else {
            rubyClass.funcall("method_added", this.builtins.toSymbol(iVisited.getName()));
        }
    }

    public void visitDefsNode(DefsNode iVisited) {
        this.setPosition(iVisited);
        RubyObject receiver = this.eval(iVisited.getReceiverNode());
        if (this.ruby.getSafeLevel() >= 4 && !receiver.isTaint()) {
            throw new RubySecurityException(this.ruby, "Insecure; can't define singleton method.");
        }
        if (receiver.isFrozen()) {
            throw new RubyFrozenException(this.ruby, "object");
        }
        RubyClass rubyClass = receiver.getSingletonClass();
        IMethod method = (IMethod)rubyClass.getMethods().get(iVisited.getName());
        if (method != null && this.ruby.getSafeLevel() >= 4) {
            throw new RubySecurityException(this.ruby, "Redefining method prohibited.");
        }
        DefaultMethod newMethod = new DefaultMethod(iVisited.getBodyNode(), (ArgsNode)iVisited.getArgsNode(), this.ruby.getNamespace());
        rubyClass.addMethod(iVisited.getName(), newMethod, 0 | (method != null ? method.getNoex() & 1 : 0));
        receiver.funcall("singleton_method_added", this.builtins.toSymbol(iVisited.getName()));
        this.result = this.ruby.getNil();
    }

    public void visitDotNode(DotNode iVisited) {
        this.setPosition(iVisited);
        this.result = RubyRange.newRange(this.ruby, this.eval(iVisited.getBeginNode()), this.eval(iVisited.getEndNode()), iVisited.isExclusive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitEnsureNode(EnsureNode iVisited) {
        block3: {
            RubyObject oldResult2;
            this.setPosition(iVisited);
            try {
                this.result = this.eval(iVisited.getBodyNode());
                Object var3_2 = null;
                if (iVisited.getEnsureNode() == null) break block3;
                oldResult2 = this.result;
                this.eval(iVisited.getEnsureNode());
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (iVisited.getEnsureNode() != null) {
                    RubyObject oldResult2 = this.result;
                    this.eval(iVisited.getEnsureNode());
                    this.result = oldResult2;
                }
                throw throwable;
            }
            this.result = oldResult2;
            {
            }
        }
    }

    public void visitEvStrNode(EvStrNode iVisited) {
        this.setPosition(iVisited);
        if (iVisited.getEvaluatedNode() == null) {
            int newLen;
            RubyParserConfiguration config = new RubyParserConfiguration();
            config.setLocalVariables(this.ruby.getScope().getLocalNames());
            config.setBlockVariables(RubyVarmap.getNames(this.ruby));
            this.ruby.getParser().init(config);
            IRubyParserResult result = (IRubyParserResult)this.ruby.getParser().parse(LexerFactory.getInstance().getSource("#{}", iVisited.getValue()));
            int oldLen = this.ruby.getScope().getLocalNames() != null ? this.ruby.getScope().getLocalNames().size() : 0;
            int n = newLen = result.getLocalVariables() != null ? result.getLocalVariables().size() : 0;
            if (newLen > oldLen) {
                this.ruby.getScope().setLocalNames(result.getLocalVariables());
                this.ruby.getScope().getLocalValues().addAll(Collections.nCopies(newLen - oldLen, this.ruby.getNil()));
            }
            iVisited.setEvaluatedNode(result.getAST());
        }
        this.eval(iVisited.getEvaluatedNode());
    }

    public void visitFCallNode(FCallNode iVisited) {
        this.setPosition(iVisited);
        Block tmpBlock = ArgsUtil.beginCallArgs(this.ruby);
        RubyPointer args = ArgsUtil.setupArgs(this.ruby, this, iVisited.getArgsNode());
        ArgsUtil.endCallArgs(this.ruby, tmpBlock);
        this.result = this.self.getRubyClass().call(this.self, iVisited.getName(), args, 1);
    }

    public void visitFalseNode(FalseNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.ruby.getFalse();
    }

    public void visitFlipNode(FlipNode iVisited) {
        this.setPosition(iVisited);
        if (iVisited.isExclusive()) {
            if (this.ruby.getScope().getValue(iVisited.getCount()).isFalse()) {
                this.result = this.eval(iVisited.getBeginNode()).isTrue() ? this.ruby.getFalse() : this.ruby.getTrue();
                this.ruby.getScope().setValue(iVisited.getCount(), this.result);
            } else {
                if (this.eval(iVisited.getEndNode()).isTrue()) {
                    this.ruby.getScope().setValue(iVisited.getCount(), this.ruby.getFalse());
                }
                this.result = this.ruby.getTrue();
            }
        } else if (this.ruby.getScope().getValue(iVisited.getCount()).isFalse()) {
            if (this.eval(iVisited.getBeginNode()).isTrue()) {
                this.ruby.getScope().setValue(iVisited.getCount(), this.eval(iVisited.getEndNode()).isTrue() ? this.ruby.getFalse() : this.ruby.getTrue());
                this.result = this.ruby.getTrue();
            } else {
                this.result = this.ruby.getFalse();
            }
        } else {
            if (this.eval(iVisited.getEndNode()).isTrue()) {
                this.ruby.getScope().setValue(iVisited.getCount(), this.ruby.getFalse());
            }
            this.result = this.ruby.getTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visitForNode(ForNode iVisited) {
        this.setPosition(iVisited);
        this.ruby.getBlock().push(iVisited.getVarNode(), new EvaluateMethod(iVisited.getBodyNode()), this.self);
        this.ruby.getIterStack().push(Iter.ITER_PRE);
        try {
            try {
                while (true) {
                    try {
                        String file = this.ruby.getSourceFile();
                        int line = this.ruby.getSourceLine();
                        Block tmpBlock = ArgsUtil.beginCallArgs(this.ruby);
                        RubyObject recv = this.eval(iVisited.getIterNode());
                        ArgsUtil.endCallArgs(this.ruby, tmpBlock);
                        this.ruby.setSourceFile(file);
                        this.ruby.setSourceLine(line);
                        this.result = recv.getRubyClass().call(recv, "each", null, 0);
                        Object var7_9 = null;
                    }
                    catch (RetryException rExcptn) {
                        continue;
                    }
                    break;
                }
            }
            catch (ReturnException rExcptn) {
                this.result = rExcptn.getReturnValue();
                Object var7_10 = null;
                this.ruby.getIterStack().pop();
                this.ruby.getBlock().pop();
                return;
            }
            catch (BreakJump bExcptn) {
                this.result = this.ruby.getNil();
                Object var7_11 = null;
                this.ruby.getIterStack().pop();
                this.ruby.getBlock().pop();
                return;
            }
            this.ruby.getIterStack().pop();
            this.ruby.getBlock().pop();
            return;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            this.ruby.getIterStack().pop();
            this.ruby.getBlock().pop();
            throw throwable;
        }
    }

    public void visitGlobalAsgnNode(GlobalAsgnNode iVisited) {
        this.setPosition(iVisited);
        this.eval(iVisited.getValueNode());
        this.ruby.setGlobalVar(iVisited.getName(), this.result);
    }

    public void visitGlobalVarNode(GlobalVarNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.ruby.getGlobalVar(iVisited.getName());
    }

    public void visitHashNode(HashNode iVisited) {
        this.setPosition(iVisited);
        RubyHash hash = RubyHash.newHash(this.ruby);
        if (iVisited.getListNode() != null) {
            Iterator iterator = iVisited.getListNode().iterator();
            while (iterator.hasNext()) {
                RubyObject key = this.eval((INode)iterator.next());
                if (iterator.hasNext()) {
                    hash.aset(key, this.eval((INode)iterator.next()));
                    continue;
                }
                throw new RuntimeException("[BUG] odd number list for Hash");
            }
        }
        this.result = hash;
    }

    public void visitInstAsgnNode(InstAsgnNode iVisited) {
        this.setPosition(iVisited);
        this.eval(iVisited.getValueNode());
        this.self.setInstanceVar(iVisited.getName(), this.result);
    }

    public void visitInstVarNode(InstVarNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.self.getInstanceVar(iVisited.getName());
    }

    public void visitIfNode(IfNode iVisited) {
        this.setPosition(iVisited);
        if (this.eval(iVisited.getCondition()).isTrue()) {
            this.eval(iVisited.getThenBody());
        } else {
            this.eval(iVisited.getElseBody());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visitIterNode(IterNode iVisited) {
        this.setPosition(iVisited);
        this.ruby.getBlock().push(iVisited.getVarNode(), new EvaluateMethod(iVisited.getBodyNode()), this.self);
        this.ruby.getIterStack().push(Iter.ITER_PRE);
        try {
            try {
                while (true) {
                    try {
                        this.result = this.eval(iVisited.getIterNode());
                        Object var5_2 = null;
                    }
                    catch (RetryException rExcptn) {
                        continue;
                    }
                    break;
                }
            }
            catch (ReturnException rExcptn) {
                this.result = rExcptn.getReturnValue();
                Object var5_3 = null;
                this.ruby.getIterStack().pop();
                this.ruby.getBlock().pop();
                return;
            }
            catch (BreakJump bExcptn) {
                this.result = this.ruby.getNil();
                Object var5_4 = null;
                this.ruby.getIterStack().pop();
                this.ruby.getBlock().pop();
                return;
            }
            this.ruby.getIterStack().pop();
            this.ruby.getBlock().pop();
            return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.ruby.getIterStack().pop();
            this.ruby.getBlock().pop();
            throw throwable;
        }
    }

    public void visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.setPosition(iVisited);
        this.eval(iVisited.getValueNode());
        this.ruby.getScope().setValue(iVisited.getCount(), this.result);
    }

    public void visitLocalVarNode(LocalVarNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.ruby.getScope().getValue(iVisited.getCount());
    }

    public void visitMultipleAsgnNode(MultipleAsgnNode iVisited) {
        this.setPosition(iVisited);
        this.result = new AssignmentVisitor(this.ruby, this.self).assign(iVisited, this.eval(iVisited.getValueNode()), false);
    }

    public void visitMatch2Node(Match2Node iVisited) {
        this.setPosition(iVisited);
        this.result = ((RubyRegexp)this.eval(iVisited.getReceiverNode())).match(this.eval(iVisited.getValueNode()));
    }

    public void visitMatch3Node(Match3Node iVisited) {
        this.setPosition(iVisited);
        RubyObject receiver = this.eval(iVisited.getReceiverNode());
        RubyObject value = this.eval(iVisited.getValueNode());
        this.result = value instanceof RubyString ? ((RubyRegexp)receiver).match(value) : value.funcall("=~", receiver);
    }

    public void visitMatchNode(MatchNode iVisited) {
        this.setPosition(iVisited);
        this.result = ((RubyRegexp)this.eval(iVisited.getRegexpNode())).match2();
    }

    public void visitModuleNode(ModuleNode iVisited) {
        this.setPosition(iVisited);
        if (this.ruby.getRubyClass() == null) {
            throw new TypeError(this.ruby, "no outer class/module");
        }
        if (this.ruby.getRubyClass() != this.ruby.getClasses().getObjectClass() || this.ruby.isAutoloadDefined(iVisited.getName())) {
            // empty if block
        }
        RubyModule module = null;
        if (this.ruby.getRubyClass().isConstantDefined(iVisited.getName())) {
            module = (RubyModule)this.ruby.getRubyClass().getConstant(iVisited.getName());
            if (this.ruby.getSafeLevel() >= 4) {
                throw new RubySecurityException(this.ruby, "Extending module prohibited.");
            }
        } else {
            module = this.ruby.defineModule(iVisited.getName());
            this.ruby.getRubyClass().setConstant(iVisited.getName(), module);
            module.setClassPath(this.ruby.getRubyClass(), iVisited.getName());
        }
        if (this.ruby.getWrapper() != null) {
            module.getSingletonClass().includeModule(this.ruby.getWrapper());
            module.includeModule(this.ruby.getWrapper());
        }
        this.evalClassDefinitionBody(iVisited.getBodyNode(), module);
    }

    public void visitNewlineNode(NewlineNode iVisited) {
        this.setPosition(iVisited);
        if (iVisited.getPosition() != null) {
            this.ruby.setSourceFile(iVisited.getPosition().getFile());
            this.ruby.setSourceLine(iVisited.getPosition().getLine());
            if (this.isTrace()) {
                this.callTraceFunction("line", this.ruby.getSourceFile(), this.ruby.getSourceLine(), this.self, this.ruby.getActFrame().getLastFunc(), this.ruby.getActFrame().getLastClass());
            }
        }
        this.eval(iVisited.getNextNode());
    }

    public void visitNextNode(NextNode iVisited) {
        this.setPosition(iVisited);
        throw new NextJump();
    }

    public void visitNilNode(NilNode iVisited) {
        this.setPosition(iVisited);
    }

    public void visitNotNode(NotNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.eval(iVisited.getConditionNode()).isTrue() ? this.ruby.getFalse() : this.ruby.getTrue();
    }

    public void visitNthRefNode(NthRefNode iVisited) {
        this.setPosition(iVisited);
        this.result = RubyRegexp.nth_match(iVisited.getMatchNumber(), this.ruby.getBackref());
    }

    public void visitOpElementAsgnNode(OpElementAsgnNode iVisited) {
        this.setPosition(iVisited);
        RubyObject receiver = this.eval(iVisited.getReceiverNode());
        RubyPointer args = ArgsUtil.setupArgs(this.ruby, this, iVisited.getArgsNode());
        RubyObject firstValue = receiver.funcall("[]", args);
        if (iVisited.getOperatorName().equals("||")) {
            if (firstValue.isTrue()) {
                this.result = firstValue;
                return;
            }
            firstValue = this.eval(iVisited.getValueNode());
        } else if (iVisited.getOperatorName().equals("&&")) {
            if (firstValue.isFalse()) {
                this.result = firstValue;
                return;
            }
            firstValue = this.eval(iVisited.getValueNode());
        } else {
            firstValue = firstValue.funcall(iVisited.getOperatorName(), this.eval(iVisited.getValueNode()));
        }
        args.add(firstValue);
        this.result = receiver.funcall("[]=", args);
    }

    public void visitOpAsgnNode(OpAsgnNode iVisited) {
        this.setPosition(iVisited);
        RubyObject receiver = this.eval(iVisited.getReceiverNode());
        RubyObject value = receiver.funcall(iVisited.getVariableName(), (RubyObject[])null);
        if (iVisited.getOperatorName().equals("||")) {
            if (value.isTrue()) {
                this.result = value;
                return;
            }
            value = this.eval(iVisited.getValueNode());
        } else if (iVisited.getOperatorName().equals("&&")) {
            if (value.isFalse()) {
                this.result = value;
                return;
            }
            value = this.eval(iVisited.getValueNode());
        } else {
            value = value.funcall(iVisited.getOperatorName(), this.eval(iVisited.getValueNode()));
        }
        receiver.funcall(iVisited.getVariableName() + "=", value);
        this.result = value;
    }

    public void visitOpAsgnAndNode(OpAsgnAndNode iVisited) {
        this.setPosition(iVisited);
        if (this.eval(iVisited.getFirstNode()).isTrue()) {
            this.eval(iVisited.getSecondNode());
        }
    }

    public void visitOpAsgnOrNode(OpAsgnOrNode iVisited) {
        this.setPosition(iVisited);
        if (this.eval(iVisited.getFirstNode()).isFalse()) {
            this.eval(iVisited.getSecondNode());
        }
    }

    public void visitOptNNode(OptNNode iVisited) {
        this.setPosition(iVisited);
        block4: while (RubyKernel.gets(this.ruby, this.ruby.getRubyTopSelf(), new RubyObject[0]).isTrue()) {
            while (true) {
                try {
                    this.eval(iVisited.getBodyNode());
                    continue block4;
                }
                catch (RedoJump rJump) {
                    continue;
                }
                catch (NextJump nJump) {
                    continue block4;
                }
                catch (BreakJump bJump) {
                    return;
                }
                break;
            }
        }
    }

    public void visitOrNode(OrNode iVisited) {
        this.setPosition(iVisited);
        if (this.eval(iVisited.getFirstNode()).isFalse()) {
            this.eval(iVisited.getSecondNode());
        }
    }

    public void visitPostExeNode(PostExeNode iVisited) {
        this.setPosition(iVisited);
    }

    public void visitRedoNode(RedoNode iVisited) {
        this.setPosition(iVisited);
        throw new RedoJump();
    }

    public void visitRescueBodyNode(RescueBodyNode iVisited) {
        this.setPosition(iVisited);
        this.eval(iVisited.getBodyNode());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visitRescueNode(RescueNode iVisited) {
        this.setPosition(iVisited);
        try {
            block10: {
                while (true) {
                    RescueBodyNode rescueNode;
                    Iterator iter;
                    Object var7_2;
                    try {
                        this.eval(iVisited.getBodyNode());
                        if (iVisited.getElseNode() != null) {
                            this.eval(iVisited.getElseNode());
                        }
                        var7_2 = null;
                        break block10;
                    }
                    catch (RaiseException raiseJump) {
                        this.ruby.setGlobalVar("$!", raiseJump.getActException());
                        iter = iVisited.getRescueNodes().iterator();
                    }
                    do {
                        if (!iter.hasNext()) {
                            throw raiseJump;
                        }
                        rescueNode = (RescueBodyNode)iter.next();
                    } while (!this.isRescueHandled(raiseJump.getActException(), rescueNode.getExceptionNodes()));
                    try {
                        this.eval(rescueNode);
                        var7_2 = null;
                    }
                    catch (RetryException retryJump) {
                        this.ruby.setGlobalVar("$!", this.ruby.getNil());
                        var7_2 = null;
                        this.ruby.setGlobalVar("$!", this.ruby.getNil());
                        continue;
                    }
                    break;
                }
                this.ruby.setGlobalVar("$!", this.ruby.getNil());
                return;
            }
            this.ruby.setGlobalVar("$!", this.ruby.getNil());
            return;
        }
        catch (Throwable throwable) {
            Object var7_3 = null;
            this.ruby.setGlobalVar("$!", this.ruby.getNil());
            throw throwable;
        }
    }

    public void visitRestArgsNode(RestArgsNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.builtins.toArray(this.eval(iVisited.getArgumentNode()));
    }

    public void visitRetryNode(RetryNode iVisited) {
        this.setPosition(iVisited);
        throw new RetryException();
    }

    public void visitReturnNode(ReturnNode iVisited) {
        this.setPosition(iVisited);
        throw new ReturnException(this.eval(iVisited.getValueNode()));
    }

    public void visitSClassNode(SClassNode iVisited) {
        this.setPosition(iVisited);
        RubyObject receiver = this.eval(iVisited.getReceiverNode());
        RubyClass singletonClass = null;
        if (receiver.isNil()) {
            singletonClass = this.ruby.getClasses().getNilClass();
        } else if (receiver == this.ruby.getTrue()) {
            singletonClass = this.ruby.getClasses().getTrueClass();
        } else if (receiver == this.ruby.getFalse()) {
            singletonClass = this.ruby.getClasses().getFalseClass();
        } else {
            if (this.ruby.getSafeLevel() >= 4 && !receiver.isTaint()) {
                throw new RubySecurityException(this.ruby, "Insecure: can't extend object.");
            }
            if (receiver.getRubyClass().isSingleton()) {
                this.ruby.getMethodCache().clear();
            }
            singletonClass = receiver.getSingletonClass();
        }
        if (this.ruby.getWrapper() != null) {
            singletonClass.extendObject(this.ruby.getWrapper());
            singletonClass.includeModule(this.ruby.getWrapper());
        }
        this.evalClassDefinitionBody(iVisited.getBodyNode(), singletonClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitScopeNode(ScopeNode iVisited) {
        this.setPosition(iVisited);
        this.ruby.getActFrame().tmpPush();
        this.ruby.getScope().push(iVisited.getLocalNames());
        Namespace savedNamespace = null;
        try {
            this.eval(iVisited.getBodyNode());
            Object var4_3 = null;
            if (savedNamespace != null) {
                this.ruby.setNamespace(savedNamespace);
            }
            this.ruby.getScope().pop();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (savedNamespace != null) {
                this.ruby.setNamespace(savedNamespace);
            }
            this.ruby.getScope().pop();
            this.ruby.getActFrame().tmpPop();
            throw throwable;
        }
        this.ruby.getActFrame().tmpPop();
    }

    public void visitSelfNode(SelfNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.self;
    }

    public void visitStrNode(StrNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.builtins.toString(iVisited.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitSuperNode(SuperNode iVisited) {
        this.setPosition(iVisited);
        if (this.ruby.getActFrame().getLastClass() == null) {
            throw new NameError(this.ruby, "Superclass method '" + this.ruby.getActFrame().getLastFunc() + "' disabled.");
        }
        Block tmpBlock = ArgsUtil.beginCallArgs(this.ruby);
        RubyPointer args = ArgsUtil.setupArgs(this.ruby, this, iVisited.getArgsNode());
        ArgsUtil.endCallArgs(this.ruby, tmpBlock);
        this.ruby.getIterStack().push(this.ruby.getActIter().isNot() ? Iter.ITER_NOT : Iter.ITER_PRE);
        try {
            this.result = this.ruby.getActFrame().getLastClass().getSuperClass().call(this.ruby.getActFrame().getSelf(), this.ruby.getActFrame().getLastFunc(), args, 3);
            Object var5_4 = null;
            this.ruby.getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.ruby.getIterStack().pop();
            throw throwable;
        }
    }

    public void visitTrueNode(TrueNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.ruby.getTrue();
    }

    public void visitUndefNode(UndefNode iVisited) {
        this.setPosition(iVisited);
        if (this.ruby.getRubyClass() == null) {
            throw new TypeError(this.ruby, "No class to undef method '" + iVisited.getName() + "'.");
        }
        this.ruby.getRubyClass().undef(iVisited.getName());
    }

    public void visitUntilNode(UntilNode iVisited) {
        this.setPosition(iVisited);
        block4: while (this.eval(iVisited.getConditionNode()).isFalse()) {
            while (true) {
                try {
                    this.eval(iVisited.getBodyNode());
                    continue block4;
                }
                catch (RedoJump rJump) {
                    continue;
                }
                catch (NextJump nJump) {
                    continue block4;
                }
                catch (BreakJump bJump) {
                    return;
                }
                break;
            }
        }
    }

    public void visitVAliasNode(VAliasNode iVisited) {
        this.setPosition(iVisited);
        this.ruby.aliasGlobalVar(iVisited.getOldName(), iVisited.getNewName());
    }

    public void visitVCallNode(VCallNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.self.getRubyClass().call(this.self, iVisited.getMethodName(), null, 2);
    }

    public void visitWhenNode(WhenNode iVisited) {
        this.setPosition(iVisited);
        this.eval(iVisited.getBodyNode());
    }

    public void visitWhileNode(WhileNode iVisited) {
        this.setPosition(iVisited);
        block4: while (this.eval(iVisited.getConditionNode()).isTrue()) {
            while (true) {
                try {
                    this.eval(iVisited.getBodyNode());
                    continue block4;
                }
                catch (RedoJump rJump) {
                    continue;
                }
                catch (NextJump nJump) {
                    continue block4;
                }
                catch (BreakJump bJump) {
                    return;
                }
                break;
            }
        }
    }

    public void visitXStrNode(XStrNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.self.funcall("`", this.builtins.toString(iVisited.getValue()));
    }

    public void visitYieldNode(YieldNode iVisited) {
        this.setPosition(iVisited);
        this.eval(iVisited.getArgsNode());
        if (iVisited.getArgsNode() instanceof ExpandArrayNode && ((RubyArray)this.result).getLength() == 1) {
            this.result = ((RubyArray)this.result).entry(0L);
        }
        this.result = this.ruby.yield0(this.result, null, null, false);
    }

    public void visitZArrayNode(ZArrayNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.builtins.newArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitZSuperNode(ZSuperNode iVisited) {
        this.setPosition(iVisited);
        if (this.ruby.getActFrame().getLastClass() == null) {
            throw new NameError(this.ruby, "superclass method '" + this.ruby.getActFrame().getLastFunc() + "' disabled");
        }
        RubyPointer args = (RubyPointer)this.ruby.getActFrame().getArgs();
        this.ruby.getIterStack().push(this.ruby.getActIter().isNot() ? Iter.ITER_NOT : Iter.ITER_PRE);
        try {
            this.result = this.ruby.getActFrame().getLastClass().getSuperClass().call(this.ruby.getActFrame().getSelf(), this.ruby.getActFrame().getLastFunc(), args, 3);
            Object var4_3 = null;
            this.ruby.getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.ruby.getIterStack().pop();
            throw throwable;
        }
    }

    public void visitBignumNode(BignumNode iVisited) {
        this.setPosition(iVisited);
        this.result = RubyBignum.newBignum(this.ruby, iVisited.getValue());
    }

    public void visitFixnumNode(FixnumNode iVisited) {
        this.setPosition(iVisited);
        this.result = RubyFixnum.newFixnum(this.ruby, iVisited.getValue());
    }

    public void visitFloatNode(FloatNode iVisited) {
        this.setPosition(iVisited);
        this.result = RubyFloat.newFloat(this.ruby, iVisited.getValue());
    }

    public void visitRegexpNode(RegexpNode iVisited) {
        this.setPosition(iVisited);
        this.result = RubyRegexp.newRegexp(this.ruby, this.builtins.toString(iVisited.getValue()), iVisited.getOptions());
    }

    public void visitSymbolNode(SymbolNode iVisited) {
        this.setPosition(iVisited);
        this.result = this.builtins.toSymbol(iVisited.getName());
    }

    public void visitExpandArrayNode(ExpandArrayNode iVisited) {
        this.setPosition(iVisited);
        this.eval(iVisited.getExpandNode());
        if (!(this.result instanceof RubyArray)) {
            this.result = this.result.isNil() ? RubyArray.newArray(this.ruby, 0L) : RubyArray.newArray(this.ruby, this.result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalClassDefinitionBody(ScopeNode iVisited, RubyModule type) {
        this.ruby.getActFrame().tmpPush();
        this.ruby.pushClass(type);
        this.ruby.getScope().push(iVisited.getLocalNames());
        RubyVarmap.push(this.ruby);
        this.ruby.setNamespace(new Namespace(type, this.ruby.getNamespace()));
        this.ruby.getActFrame().setNamespace(this.ruby.getNamespace());
        RubyObject oldSelf = this.self;
        try {
            if (this.isTrace()) {
                this.callTraceFunction("class", this.ruby.getSourceFile(), this.ruby.getSourceLine(), type, this.ruby.getActFrame().getLastFunc(), this.ruby.getActFrame().getLastClass());
            }
            this.self = type;
            this.eval(iVisited.getBodyNode());
            Object var5_4 = null;
            this.self = oldSelf;
            this.ruby.setNamespace(this.ruby.getNamespace().getParent());
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.self = oldSelf;
            this.ruby.setNamespace(this.ruby.getNamespace().getParent());
            RubyVarmap.pop(this.ruby);
            this.ruby.getScope().pop();
            this.ruby.popClass();
            this.ruby.getActFrame().tmpPop();
            if (this.isTrace()) {
                this.callTraceFunction("end", this.ruby.getSourceFile(), this.ruby.getSourceLine(), null, this.ruby.getActFrame().getLastFunc(), this.ruby.getActFrame().getLastClass());
            }
            throw throwable;
        }
        RubyVarmap.pop(this.ruby);
        this.ruby.getScope().pop();
        this.ruby.popClass();
        this.ruby.getActFrame().tmpPop();
        if (this.isTrace()) {
            this.callTraceFunction("end", this.ruby.getSourceFile(), this.ruby.getSourceLine(), null, this.ruby.getActFrame().getLastFunc(), this.ruby.getActFrame().getLastClass());
        }
    }

    private ScopeNode copyNodeScope(ScopeNode node, Namespace namespace) {
        ScopeNode copy = new ScopeNode(node.getPosition(), null, node.getBodyNode());
        if (node.getLocalNames() != null) {
            copy.setLocalNames(new ArrayList(node.getLocalNames()));
        }
        return copy;
    }

    private boolean isRescueHandled(RubyException actExcptn, IListNode exceptionNodes) {
        if (exceptionNodes == null) {
            return actExcptn.kind_of(this.ruby.getExceptions().getStandardError()).isTrue();
        }
        Block tmpBlock = ArgsUtil.beginCallArgs(this.ruby);
        RubyPointer args = ArgsUtil.setupArgs(this.ruby, this, exceptionNodes);
        ArgsUtil.endCallArgs(this.ruby, tmpBlock);
        int i = 0;
        while (i < args.size()) {
            if (args.getRuby(i).kind_of(this.ruby.getClasses().getModuleClass()).isFalse()) {
                throw new TypeError(this.ruby, "class or module required for rescue clause");
            }
            if (actExcptn.kind_of((RubyModule)args.getRuby(i)).isTrue()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

