/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.ablaf.ast.INode;
import org.ablaf.common.ISourcePosition;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ScopeNode;
import org.jruby.ast.types.IListNode;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.EvaluateVisitor;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.ReturnException;
import org.jruby.internal.runtime.methods.AbstractMethod;
import org.jruby.runtime.Namespace;
import org.jruby.runtime.RubyVarmap;

public class DefaultMethod
extends AbstractMethod {
    private ScopeNode body;
    private ArgsNode argsNode;
    private Namespace namespace;

    public DefaultMethod(ScopeNode body, ArgsNode argsNode, Namespace namespace) {
        this.body = body;
        this.argsNode = argsNode;
        this.namespace = namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RubyObject execute(Ruby ruby, RubyObject receiver, String name, RubyObject[] args, boolean noSuper) {
        if (args == null) {
            args = new RubyObject[]{};
        }
        RubyProc optionalBlockArg = null;
        if (this.argsNode.getBlockArgNode() != null && ruby.isBlockGiven()) {
            optionalBlockArg = RubyProc.newProc(ruby, ruby.getClasses().getProcClass());
        }
        ruby.getScope().push();
        Namespace savedNamespace = null;
        if (this.namespace != null) {
            savedNamespace = ruby.getNamespace();
            ruby.setNamespace(this.namespace);
            ruby.getActFrame().setNamespace(this.namespace);
        }
        if (this.body.getLocalNames() != null) {
            ruby.getScope().setLocalValues(new ArrayList<RubyObject>(Collections.nCopies(this.body.getLocalNames().size(), ruby.getNil())));
            ruby.getScope().setLocalNames(this.body.getLocalNames());
        }
        RubyVarmap.push(ruby);
        try {
            try {
                block33: {
                    ISourcePosition lPos2;
                    block35: {
                        block34: {
                            if (this.argsNode != null) {
                                int i = this.argsNode.getArgsCount();
                                if (i > args.length) {
                                    throw new ArgumentError(ruby, "Wrong # of arguments(" + args.length + " for " + i + ")");
                                }
                                if (this.argsNode.getRestArg() == -1 && this.argsNode.getOptArgs() != null) {
                                    int opt = i;
                                    IListNode optNode = this.argsNode.getOptArgs();
                                    Iterator iter = optNode.iterator();
                                    while (iter.hasNext()) {
                                        iter.next();
                                        ++opt;
                                    }
                                    if (opt < args.length) {
                                        throw new ArgumentError(ruby, "wrong # of arguments(" + args.length + " for " + opt + ")");
                                    }
                                    ruby.getActFrame().setArgs(Arrays.asList(args));
                                }
                                if (ruby.getScope().getLocalValues() != null) {
                                    if (i > 0) {
                                        int j = 0;
                                        while (j < i) {
                                            ruby.getScope().setValue(j + 2, args[j]);
                                            ++j;
                                        }
                                    }
                                    if (this.argsNode.getOptArgs() != null) {
                                        IListNode optArgs = this.argsNode.getOptArgs();
                                        Iterator iter = optArgs.iterator();
                                        int j = i;
                                        while (j < args.length && iter.hasNext()) {
                                            new AssignmentVisitor(ruby, receiver).assign((INode)iter.next(), args[j], true);
                                            ++i;
                                            ++j;
                                        }
                                        while (iter.hasNext()) {
                                            new EvaluateVisitor(ruby, receiver).eval((INode)iter.next());
                                        }
                                    }
                                    if (this.argsNode.getRestArg() >= 0) {
                                        RubyArray array = null;
                                        array = args.length > i ? RubyArray.newArray(ruby, Arrays.asList(args).subList(i, args.length)) : RubyArray.newArray(ruby, 0L);
                                        ruby.getScope().setValue(this.argsNode.getRestArg(), array);
                                    }
                                }
                            }
                            if (optionalBlockArg != null) {
                                ruby.getScope().setValue(this.argsNode.getBlockArgNode().getCount(), optionalBlockArg);
                            }
                            if (ruby.getRuntime().getTraceFunction() == null) break block33;
                            lPos2 = null;
                            if (this.body == null) break block34;
                            if (this.body.getBodyNode() != null) {
                                if (this.body.getBodyNode().getPosition() != null) {
                                    lPos2 = this.body.getBodyNode().getPosition();
                                }
                                break block35;
                            } else if (this.body.getPosition() != null) {
                                lPos2 = this.body.getPosition();
                            }
                            break block35;
                        }
                        if (this.argsNode != null) {
                            lPos2 = this.argsNode.getPosition();
                        }
                    }
                    String lFile = ruby.getSourceFile();
                    int lLine = ruby.getSourceLine();
                    if (lPos2 != null) {
                        lFile = lPos2.getFile();
                        lLine = lPos2.getLine();
                    }
                    ruby.getRuntime().callTraceFunction("call", lFile, lLine, receiver, name, this.getImplementationClass());
                }
                RubyObject lPos2 = receiver.eval(this.body.getBodyNode());
                Object var13_21 = null;
                RubyVarmap.pop(ruby);
                ruby.getScope().pop();
                if (savedNamespace != null) {
                    ruby.setNamespace(savedNamespace);
                }
                if (ruby.getRuntime().getTraceFunction() == null) return lPos2;
                String file = ruby.getFrameStack().getPrevious().getFile();
                int line = ruby.getFrameStack().getPrevious().getLine();
                if (file == null) {
                    file = ruby.getSourceFile();
                    line = ruby.getSourceLine();
                }
                ruby.getRuntime().callTraceFunction("return", file, line, receiver, name, this.getImplementationClass());
                return lPos2;
            }
            catch (ReturnException rExcptn) {
                RubyObject rubyObject = rExcptn.getReturnValue();
                Object var13_22 = null;
                RubyVarmap.pop(ruby);
                ruby.getScope().pop();
                if (savedNamespace != null) {
                    ruby.setNamespace(savedNamespace);
                }
                if (ruby.getRuntime().getTraceFunction() == null) return rubyObject;
                String file = ruby.getFrameStack().getPrevious().getFile();
                int line = ruby.getFrameStack().getPrevious().getLine();
                if (file == null) {
                    file = ruby.getSourceFile();
                    line = ruby.getSourceLine();
                }
                ruby.getRuntime().callTraceFunction("return", file, line, receiver, name, this.getImplementationClass());
                return rubyObject;
            }
        }
        catch (Throwable throwable) {
            Object var13_23 = null;
            RubyVarmap.pop(ruby);
            ruby.getScope().pop();
            if (savedNamespace != null) {
                ruby.setNamespace(savedNamespace);
            }
            if (ruby.getRuntime().getTraceFunction() == null) throw throwable;
            String file = ruby.getFrameStack().getPrevious().getFile();
            int line = ruby.getFrameStack().getPrevious().getLine();
            if (file == null) {
                file = ruby.getSourceFile();
                line = ruby.getSourceLine();
            }
            ruby.getRuntime().callTraceFunction("return", file, line, receiver, name, this.getImplementationClass());
            throw throwable;
        }
    }
}

